/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber;

import cucumber.api.formatter.Formatter;
import cucumber.api.junit.Cucumber;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.formatter.SerenityReporter;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.junit.FeatureRunner;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.CucumberWithSerenityRuntime;
import net.serenitybdd.cucumber.suiteslicing.CucumberSuiteSlicer;
import net.serenitybdd.cucumber.suiteslicing.ScenarioFilter;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.FeatureRunnerExtractors;
import net.serenitybdd.cucumber.util.TagParser;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberWithSerenity
extends Cucumber {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberWithSerenity.class);
    private static ThreadLocal<RuntimeOptions> RUNTIME_OPTIONS = new ThreadLocal();

    public static void setRuntimeOptions(RuntimeOptions runtimeOptions) {
        RUNTIME_OPTIONS.set(runtimeOptions);
    }

    public CucumberWithSerenity(Class clazz) throws InitializationError, IOException {
        super(clazz);
    }

    public static RuntimeOptions currentRuntimeOptions() {
        return RUNTIME_OPTIONS.get();
    }

    protected Runtime createRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions) {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        runtimeOptions.getTagFilters().addAll(TagParser.additionalTagsSuppliedFrom(environmentVariables, runtimeOptions.getTagFilters()));
        CucumberWithSerenity.setRuntimeOptions(runtimeOptions);
        return CucumberWithSerenityRuntime.using(resourceLoader, classLoader, runtimeOptions);
    }

    public static Runtime createSerenityEnabledRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        CucumberWithSerenity.setRuntimeOptions(runtimeOptions);
        Runtime runtime = new Runtime(resourceLoader, (ClassFinder)classFinder, classLoader, runtimeOptions);
        SerenityReporter reporter = new SerenityReporter(systemConfiguration, resourceLoader);
        runtimeOptions.addPlugin((Formatter)reporter);
        return runtime;
    }

    public List<FeatureRunner> getChildren() {
        try {
            EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
            RuntimeOptions runtimeOptions = CucumberWithSerenity.currentRuntimeOptions();
            List tagFilters = runtimeOptions.getTagFilters();
            List featurePaths = runtimeOptions.getFeaturePaths();
            int batchNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_NUMBER, Integer.valueOf(1));
            int batchCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_COUNT, Integer.valueOf(1));
            int forkNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_NUMBER, Integer.valueOf(1));
            int forkCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_COUNT, Integer.valueOf(1));
            if (batchCount == 1 && forkCount == 1) {
                return super.getChildren();
            }
            LOGGER.info("Running slice {} of {} using fork {} of {} from feature paths {}", new Object[]{batchNumber, batchCount, forkNumber, forkCount, featurePaths});
            WeightedCucumberScenarios weightedCucumberScenarios = new CucumberSuiteSlicer(featurePaths, TestStatistics.from(environmentVariables, featurePaths)).scenarios(batchNumber, batchCount, forkNumber, forkCount, tagFilters);
            List unfilteredChildren = super.getChildren();
            AtomicInteger filteredInScenarioCount = new AtomicInteger();
            List<FeatureRunner> filteredChildren = unfilteredChildren.stream().filter(this.forIncludedFeatures(weightedCucumberScenarios)).map(this.toPossibleFeatureRunner(weightedCucumberScenarios, filteredInScenarioCount)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            if (filteredInScenarioCount.get() != weightedCucumberScenarios.totalScenarioCount()) {
                LOGGER.warn("There is a mismatch between the number of scenarios included in this test run ({}) and the expected number of scenarios loaded ({}). This suggests that the scenario filtering is not working correctly or feature file(s) of an unexpected structure are being run", (Object)filteredInScenarioCount.get(), (Object)weightedCucumberScenarios.scenarios.size());
            }
            LOGGER.info("Running {} of {} features", (Object)filteredChildren.size(), (Object)unfilteredChildren.size());
            return filteredChildren;
        }
        catch (Exception e) {
            LOGGER.error("Test failed to start", (Throwable)e);
            throw e;
        }
    }

    private Function<FeatureRunner, Optional<FeatureRunner>> toPossibleFeatureRunner(WeightedCucumberScenarios weightedCucumberScenarios, AtomicInteger filteredInScenarioCount) {
        return featureRunner -> {
            int initialScenarioCount = featureRunner.getDescription().getChildren().size();
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            try {
                ScenarioFilter filter = weightedCucumberScenarios.createFilterContainingScenariosIn(featureName);
                String featurePath = FeatureRunnerExtractors.featurePathFor(featureRunner);
                featureRunner.filter((Filter)filter);
                if (!filter.scenariosIncluded().isEmpty()) {
                    LOGGER.info("{} scenario(s) included for '{}' in {}", new Object[]{filter.scenariosIncluded().size(), featureName, featurePath});
                    filter.scenariosIncluded().forEach(scenario -> {
                        LOGGER.info("Included scenario '{}'", scenario);
                        filteredInScenarioCount.getAndIncrement();
                    });
                }
                if (!filter.scenariosExcluded().isEmpty()) {
                    LOGGER.debug("{} scenario(s) excluded for '{}' in {}", new Object[]{filter.scenariosExcluded().size(), featureName, featurePath});
                    filter.scenariosExcluded().forEach(scenario -> LOGGER.debug("Excluded scenario '{}'", scenario));
                }
                return Optional.of(featureRunner);
            }
            catch (NoTestsRemainException e) {
                LOGGER.info("Filtered out all {} scenarios for feature '{}'", (Object)initialScenarioCount, (Object)featureName);
                return Optional.empty();
            }
        };
    }

    private Predicate<FeatureRunner> forIncludedFeatures(WeightedCucumberScenarios weightedCucumberScenarios) {
        return featureRunner -> {
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            String featurePath = Paths.get(FeatureRunnerExtractors.featurePathFor(featureRunner), new String[0]).getFileName().toString();
            boolean matches = weightedCucumberScenarios.scenarios.stream().anyMatch(scenario -> featurePath.equals(scenario.featurePath));
            LOGGER.debug("{} in filtering '{}' in {}", new Object[]{matches ? "Including" : "Not including", featureName, featurePath});
            return matches;
        };
    }
}

