/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.util;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class BigDecimalAverageCollector
implements Collector<BigDecimal, BigDecimalAccumulator, BigDecimal> {
    private BigDecimalAverageCollector() {
    }

    public static BigDecimalAverageCollector create() {
        return new BigDecimalAverageCollector();
    }

    @Override
    public Supplier<BigDecimalAccumulator> supplier() {
        return BigDecimalAccumulator::new;
    }

    @Override
    public BiConsumer<BigDecimalAccumulator, BigDecimal> accumulator() {
        return BigDecimalAccumulator::add;
    }

    @Override
    public BinaryOperator<BigDecimalAccumulator> combiner() {
        return BigDecimalAccumulator::combine;
    }

    @Override
    public Function<BigDecimalAccumulator, BigDecimal> finisher() {
        return BigDecimalAccumulator::getAverage;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.emptySet();
    }

    static class BigDecimalAccumulator {
        public BigDecimal sum = BigDecimal.ZERO;
        public BigDecimal count = BigDecimal.ZERO;

        public BigDecimalAccumulator() {
        }

        private BigDecimalAccumulator(BigDecimal sum, BigDecimal count) {
            sum.add(sum);
            count.add(count);
        }

        public static BigDecimalAccumulator accumulateWith(BigDecimal sum, BigDecimal count) {
            return new BigDecimalAccumulator(sum, count);
        }

        BigDecimal getAverage() {
            return BigDecimal.ZERO.compareTo(this.count) == 0 ? BigDecimal.ZERO : this.sum.divide(this.count, 2, 4);
        }

        BigDecimalAccumulator combine(BigDecimalAccumulator another) {
            return BigDecimalAccumulator.accumulateWith(this.sum.add(another.sum), this.count.add(another.count));
        }

        void add(BigDecimal successRate) {
            this.count = this.count.add(BigDecimal.ONE);
            this.sum = this.sum.add(successRate);
        }
    }
}

