/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.eventbus.EventBus;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.core.plugin.Options;
import io.cucumber.core.plugin.SerenityReporter;
import io.cucumber.core.runtime.ExitStatus;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.core.runtime.FeatureSupplier;
import io.cucumber.core.runtime.Runtime;
import io.cucumber.core.runtime.ThreadLocalRunnerSupplier;
import io.cucumber.core.runtime.TimeServiceEventBus;
import io.cucumber.junit.Assertions;
import io.cucumber.junit.CucumberSerenityBaseRunner;
import io.cucumber.junit.JUnitOptions;
import io.cucumber.junit.LiteralExpression;
import io.cucumber.plugin.Plugin;
import io.cucumber.tagexpressions.Expression;
import java.time.Clock;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runners.model.InitializationError;

public class CucumberSerenityRunner
extends CucumberSerenityBaseRunner {
    public CucumberSerenityRunner(Class clazz) throws InitializationError {
        super(clazz);
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptions runtimeOptions = this.createRuntimeOptions(clazz);
        JUnitOptions junitOptions = this.createJUnitOptions(clazz);
        this.initializeBus();
        CucumberSerenityRunner.setRuntimeOptions(runtimeOptions);
        this.parseFeaturesEarly();
        this.initiatePluginsList(runtimeOptions);
        ExitStatus exitStatus = new ExitStatus((Options)runtimeOptions);
        this.addPlugin((Plugin)exitStatus);
        ThreadLocalRunnerSupplier runnerSupplier = this.initializeServices(clazz, runtimeOptions);
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        SerenityReporter reporter = new SerenityReporter(systemConfiguration);
        this.addPluginIfNotInList(reporter, SerenityReporter.class);
        this.initiateContext(exitStatus, runnerSupplier);
        this.createFeatureRunners(this.getFeatures(), runtimeOptions, junitOptions);
    }

    public static Runtime createSerenityEnabledRuntime(Supplier<ClassLoader> classLoaderSupplier, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        RuntimeOptionsBuilder runtimeOptionsBuilder = new RuntimeOptionsBuilder();
        Collection<String> allTagFilters = CucumberSerenityRunner.environmentSpecifiedTags(runtimeOptions.getTagExpressions());
        for (String tagFilter : allTagFilters) {
            runtimeOptionsBuilder.addTagFilter((Expression)new LiteralExpression(tagFilter));
        }
        runtimeOptionsBuilder.build(runtimeOptions);
        CucumberSerenityRunner.setRuntimeOptions(runtimeOptions);
        TimeServiceEventBus bus = new TimeServiceEventBus(Clock.systemUTC(), UUID::randomUUID);
        FeatureParser parser = new FeatureParser(() -> ((EventBus)bus).generateId());
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(classLoaderSupplier, (io.cucumber.core.feature.Options)runtimeOptions, parser);
        SerenityReporter serenityReporter = new SerenityReporter(systemConfiguration);
        return Runtime.builder().withClassLoader(classLoaderSupplier).withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{serenityReporter}).withEventBus((EventBus)bus).withFeatureSupplier((FeatureSupplier)featureSupplier).build();
    }
}

