/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps.events;

import io.cucumber.core.plugin.SerenityReporterParallel;
import io.cucumber.messages.types.Step;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestStep;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.events.StepEventBusEventBase;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;

public class RecordStepResultEvent
extends StepEventBusEventBase {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private Result result;
    private Step currentStep;
    private TestStep currentTestStep;
    private List<ScreenshotAndHtmlSource> screenshotList;

    public RecordStepResultEvent(Result result, Step currentStep, TestStep currentTestStep, List<ScreenshotAndHtmlSource> screenshotList) {
        this.result = result;
        this.currentStep = currentStep;
        this.currentTestStep = currentTestStep;
        this.screenshotList = screenshotList;
    }

    public void play() {
        if (this.getStepEventBus().currentTestIsSuspended()) {
            this.getStepEventBus().stepIgnored();
        } else if (Status.PASSED.equals((Object)this.result.getStatus())) {
            this.getStepEventBus().stepFinished(this.screenshotList);
        } else if (Status.FAILED.equals((Object)this.result.getStatus())) {
            this.failed(SerenityReporterParallel.stepTitleFrom(this.currentStep, this.currentTestStep), this.result.getError());
        } else if (Status.SKIPPED.equals((Object)this.result.getStatus())) {
            this.skipped(SerenityReporterParallel.stepTitleFrom(this.currentStep, this.currentTestStep), this.result.getError());
        } else if (Status.PENDING.equals((Object)this.result.getStatus())) {
            this.getStepEventBus().stepPending();
        } else if (Status.UNDEFINED.equals((Object)this.result.getStatus())) {
            this.getStepEventBus().stepPending();
        }
    }

    private void failed(String stepTitle, Throwable cause) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            Throwable rootCause;
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                this.getStepEventBus().updateCurrentStepTitle(stepTitle);
            }
            if (this.isAssumptionFailure(rootCause = new RootCauseAnalyzer(cause).getRootCause().toException())) {
                this.getStepEventBus().assumptionViolated(rootCause.getMessage());
            } else {
                this.getStepEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(this.currentStepTitle())), rootCause));
            }
        }
    }

    private void skipped(String stepTitle, Throwable cause) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                this.getStepEventBus().updateCurrentStepTitle(stepTitle);
            }
            if (cause == null) {
                this.getStepEventBus().stepIgnored();
            } else {
                Throwable rootCause = new RootCauseAnalyzer(cause).getRootCause().toException();
                if (this.isAssumptionFailure(rootCause)) {
                    this.getStepEventBus().assumptionViolated(rootCause.getMessage());
                } else {
                    this.getStepEventBus().stepIgnored();
                }
            }
        }
    }

    private boolean errorOrFailureRecordedForStep(String stepTitle, Throwable cause) {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        if (!this.latestTestOutcome().get().testStepWithDescription(stepTitle).isPresent()) {
            return false;
        }
        Optional matchingTestStep = this.latestTestOutcome().get().testStepWithDescription(stepTitle);
        if (matchingTestStep.isPresent() && ((net.thucydides.core.model.TestStep)matchingTestStep.get()).getNestedException() != null) {
            return ((net.thucydides.core.model.TestStep)matchingTestStep.get()).getNestedException().getOriginalCause() == cause;
        }
        return false;
    }

    private Optional<TestOutcome> latestTestOutcome() {
        if (!this.getStepEventBus().isBaseStepListenerRegistered()) {
            return Optional.empty();
        }
        List recordedOutcomes = this.getStepEventBus().getBaseStepListener().getTestOutcomes();
        return recordedOutcomes.isEmpty() ? Optional.empty() : Optional.of(recordedOutcomes.get(recordedOutcomes.size() - 1));
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private String currentStepTitle() {
        return this.getStepEventBus().getCurrentStep().isPresent() ? ((net.thucydides.core.model.TestStep)this.getStepEventBus().getCurrentStep().get()).getDescription() : "";
    }
}

