/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import com.google.common.collect.FluentIterable;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.gherkin.GherkinDocumentBuilder;
import io.cucumber.gherkin.GherkinException;
import io.cucumber.gherkin.IncrementingIdGenerator;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Source;
import io.cucumber.messages.types.SourceMediaType;
import io.cucumber.messages.types.Tag;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioLoader.class);
    private final Supplier<ClassLoader> classLoader = CucumberScenarioLoader.class::getClassLoader;
    private final List<URI> featurePaths;
    private final TestStatistics statistics;
    private Map<Feature, URI> mapsForFeatures = new HashMap<Feature, URI>();

    public CucumberScenarioLoader(List<URI> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios load() {
        LOGGER.debug("Feature paths are {}", this.featurePaths);
        FeatureParser parser = new FeatureParser(UUID::randomUUID);
        Options featureOptions = () -> this.featurePaths;
        FeaturePathFeatureSupplier supplier = new FeaturePathFeatureSupplier(this.classLoader, featureOptions, parser);
        IntStream.range(0, supplier.get().size()).forEach(i -> {
            io.cucumber.core.gherkin.Feature feature = (io.cucumber.core.gherkin.Feature)supplier.get().get(i);
            Parser gherkinParser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IncrementingIdGenerator(), feature.getUri().toString()));
            this.mapsForFeatures.put((Feature)((GherkinDocument)gherkinParser.parse(feature.getSource(), feature.getUri().toString())).getFeature().get(), feature.getUri());
        });
        ArrayList features = new ArrayList();
        List gherkinFeatures = supplier.get();
        for (io.cucumber.core.gherkin.Feature gherkinFeature : gherkinFeatures) {
            Parser gherkinParser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IncrementingIdGenerator(), gherkinFeature.getUri().toString()));
            GherkinDocument gherkinDocument = (GherkinDocument)gherkinParser.parse(gherkinFeature.getSource(), gherkinFeature.getUri().toString());
            features.add(gherkinDocument.getFeature().get());
        }
        List<WeightedCucumberScenario> weightedCucumberScenarios = this.mapsForFeatures.keySet().stream().map(this.getScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
        return new WeightedCucumberScenarios(weightedCucumberScenarios);
    }

    private Function<Feature, List<WeightedCucumberScenario>> getScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildren().stream().filter(child -> child.getScenario() != null && child.getScenario().isPresent()).map(FeatureChild::getScenario).map(scenarioDefinition -> new WeightedCucumberScenario(PathUtils.getAsFile(this.mapsForFeatures.get(cucumberFeature)).getName(), cucumberFeature.getName(), ((Scenario)scenarioDefinition.get()).getName(), this.scenarioWeightFor((Feature)cucumberFeature, (Scenario)scenarioDefinition.get()), this.tagsFor((Feature)cucumberFeature, (Scenario)scenarioDefinition.get()), this.scenarioCountFor((Scenario)scenarioDefinition.get()))).collect(Collectors.toList());
            }
            catch (Throwable e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", this.mapsForFeatures.get(cucumberFeature)), e);
            }
        };
    }

    private int scenarioCountFor(Scenario scenarioDefinition) {
        if (scenarioDefinition.getExamples().size() > 0) {
            return scenarioDefinition.getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
        }
        return 1;
    }

    private Set<String> tagsFor(Feature feature, Scenario scenarioDefinition) {
        return FluentIterable.concat((Iterable)feature.getTags(), this.scenarioTags(scenarioDefinition)).stream().map(Tag::getName).collect(Collectors.toSet());
    }

    private List<Tag> scenarioTags(Scenario scenario) {
        if (scenario.getExamples().isEmpty()) {
            return scenario.getTags();
        }
        return Stream.of(scenario.getTags(), scenario.getExamples().stream().flatMap(e -> e.getTags().stream()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private BigDecimal scenarioWeightFor(Feature feature, Scenario scenarioDefinition) {
        return this.statistics.scenarioWeightFor(feature.getName(), scenarioDefinition.getName());
    }

    private static Envelope readEnvelopeFromPath(Path path) {
        try {
            byte[] bytes = Files.readAllBytes(path);
            String data = new String(bytes, StandardCharsets.UTF_8);
            return Envelope.of((Source)new Source(path.toString(), data, SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN));
        }
        catch (IOException e) {
            throw new GherkinException(e.getMessage(), (Throwable)e);
        }
    }
}

