/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.serenitybdd.cucumber.suiteslicing.ScenarioFilter;
import net.serenitybdd.cucumber.suiteslicing.SliceBuilder;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedCucumberScenarios {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeightedCucumberScenarios.class);
    public final BigDecimal totalWeighting;
    public final List<WeightedCucumberScenario> scenarios;

    public WeightedCucumberScenarios(List<WeightedCucumberScenario> scenarios) {
        this.scenarios = scenarios;
        this.totalWeighting = scenarios.stream().map(WeightedCucumberScenario::weighting).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public SliceBuilder slice(int sliceNumber) {
        return new SliceBuilder(sliceNumber, this);
    }

    public List<WeightedCucumberScenarios> sliceInto(int sliceCount) {
        BigDecimal totalWeight = this.scenarios.stream().map(WeightedCucumberScenario::weighting).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal averageWeightPerSlice = totalWeight.divide(new BigDecimal(sliceCount), 2, RoundingMode.HALF_UP);
        LOGGER.debug("Total weighting for {} scenarios is {}, split across {} slices provides average weighting per slice of {}", new Object[]{this.scenarios.size(), totalWeight, sliceCount, averageWeightPerSlice});
        List allScenarios = IntStream.rangeClosed(1, sliceCount).mapToObj(initialiseAs -> new ArrayList()).collect(Collectors.toList());
        this.scenarios.stream().sorted(WeightedCucumberScenarios.bySlowestFirst().thenComparing(WeightedCucumberScenarios.byFeaturePathAscending())).forEach(scenario -> allScenarios.stream().min(WeightedCucumberScenarios.byLowestSumOfDurationFirst()).get().add((WeightedCucumberScenario)scenario));
        return allScenarios.stream().map(WeightedCucumberScenarios::new).collect(Collectors.toList());
    }

    public ScenarioFilter createFilterContainingScenariosIn(String featureName) {
        LOGGER.debug("Filtering for scenarios in feature {}", (Object)featureName);
        List<String> scenarios = this.scenarios.stream().filter((? super T scenario) -> {
            boolean matches = scenario.feature.equals(featureName);
            LOGGER.debug("Scenario {} matches {} -> {}", new Object[]{scenario.feature, featureName, matches});
            return matches;
        }).map(scenario -> scenario.scenario).collect(Collectors.toList());
        if (scenarios.isEmpty()) {
            throw new IllegalArgumentException("Can't find feature '" + featureName + "' in this slice");
        }
        return ScenarioFilter.onScenarios(scenarios);
    }

    public WeightedCucumberScenarios filter(Predicate<WeightedCucumberScenario> predicate) {
        return new WeightedCucumberScenarios(this.scenarios.stream().filter(predicate).collect(Collectors.toList()));
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private static Comparator<WeightedCucumberScenario> bySlowestFirst() {
        return (item1, item2) -> ObjectUtils.compare((Comparable)item2.weighting(), (Comparable)item1.weighting());
    }

    private static Comparator<WeightedCucumberScenario> byFeaturePathAscending() {
        return (item1, item2) -> ObjectUtils.compare((Comparable)((Object)item1.featurePath), (Comparable)((Object)item2.featurePath));
    }

    private static Comparator<List<WeightedCucumberScenario>> byLowestSumOfDurationFirst() {
        return (item1, item2) -> ObjectUtils.compare((Comparable)item1.stream().map(WeightedCucumberScenario::weighting).reduce(BigDecimal.ZERO, BigDecimal::add), (Comparable)item2.stream().map(WeightedCucumberScenario::weighting).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    public int totalScenarioCount() {
        return this.scenarios.stream().map(scenario -> scenario.scenarioCount).reduce(0, Integer::sum);
    }
}

