/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.events;

import io.cucumber.core.plugin.SerenityReporterParallel;
import io.cucumber.messages.types.Step;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestStep;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.steps.events.StepEventBusEventBase;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.stacktrace.RootCauseAnalyzer;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;

public class StepFinishedWithResultEvent
extends StepEventBusEventBase {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private final Result result;
    private final Step currentStep;
    private final TestStep currentTestStep;
    private final List<ScreenshotAndHtmlSource> screenshotList;
    boolean isInDataDrivenTest;

    public StepFinishedWithResultEvent(Result result, Step currentStep, TestStep currentTestStep, List<ScreenshotAndHtmlSource> screenshotList, ZonedDateTime time, boolean isInDataDrivenTest) {
        this.result = result;
        this.currentStep = currentStep;
        this.currentTestStep = currentTestStep;
        this.screenshotList = screenshotList;
        this.timestamp = time;
        this.isInDataDrivenTest = isInDataDrivenTest;
    }

    public void play() {
        if (this.getStepEventBus().currentTestIsSuspended()) {
            this.getStepEventBus().stepIgnored();
        } else if (Status.PASSED.equals((Object)this.result.getStatus())) {
            this.getStepEventBus().stepFinished(this.screenshotList, this.getTimestamp());
        } else if (Status.FAILED.equals((Object)this.result.getStatus())) {
            this.failed(SerenityReporterParallel.stepTitleFrom(this.currentStep, this.currentTestStep), this.result.getError(), this.screenshotList);
        } else if (Status.SKIPPED.equals((Object)this.result.getStatus())) {
            this.skipped(SerenityReporterParallel.stepTitleFrom(this.currentStep, this.currentTestStep), this.result.getError());
        } else if (Status.PENDING.equals((Object)this.result.getStatus())) {
            this.getStepEventBus().stepPending();
        } else if (Status.UNDEFINED.equals((Object)this.result.getStatus())) {
            this.getStepEventBus().stepPending();
        }
    }

    private void failed(String stepTitle, Throwable cause, List<ScreenshotAndHtmlSource> screenshots) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            Throwable rootCause;
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                this.getStepEventBus().updateCurrentStepTitle(stepTitle);
            }
            if (this.isAssumptionFailure(rootCause = new RootCauseAnalyzer(cause).getRootCause().toException())) {
                this.getStepEventBus().assumptionViolated(rootCause.getMessage());
            } else {
                StepFailure stepFailure = new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(this.currentStepTitle())), rootCause);
                this.getStepEventBus().stepFailed(stepFailure, screenshots, this.isInDataDrivenTest);
            }
        }
    }

    private void skipped(String stepTitle, Throwable cause) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                this.getStepEventBus().updateCurrentStepTitle(stepTitle);
            }
            if (cause == null) {
                this.getStepEventBus().stepIgnored();
            } else {
                Throwable rootCause = new RootCauseAnalyzer(cause).getRootCause().toException();
                if (this.isAssumptionFailure(rootCause)) {
                    this.getStepEventBus().assumptionViolated(rootCause.getMessage());
                } else {
                    this.getStepEventBus().stepIgnored();
                }
            }
        }
    }

    private boolean errorOrFailureRecordedForStep(String stepTitle, Throwable cause) {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        if (!this.latestTestOutcome().get().testStepWithDescription(stepTitle).isPresent()) {
            return false;
        }
        Optional matchingTestStep = this.latestTestOutcome().get().testStepWithDescription(stepTitle);
        if (matchingTestStep.isPresent() && ((net.thucydides.model.domain.TestStep)matchingTestStep.get()).getNestedException() != null) {
            return ((net.thucydides.model.domain.TestStep)matchingTestStep.get()).getNestedException().getOriginalCause() == cause;
        }
        return false;
    }

    private Optional<TestOutcome> latestTestOutcome() {
        if (!this.getStepEventBus().isBaseStepListenerRegistered()) {
            return Optional.empty();
        }
        List recordedOutcomes = this.getStepEventBus().getBaseStepListener().getTestOutcomes();
        return recordedOutcomes.isEmpty() ? Optional.empty() : Optional.of((TestOutcome)recordedOutcomes.get(recordedOutcomes.size() - 1));
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private String currentStepTitle() {
        return this.getStepEventBus().getCurrentStep().isPresent() ? ((net.thucydides.model.domain.TestStep)this.getStepEventBus().getCurrentStep().get()).getDescription() : "";
    }
}

