/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.FeaturePathFormatter;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.Tag;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.events.StepEventBusEvent;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.DataTableRow;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.steps.StepListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioContextParallel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioContextParallel.class);
    private final Map<String, List<StepEventBusEvent>> highPriorityEventBusEvents = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Queue<Step>> stepQueue = Collections.synchronizedMap(new HashMap());
    private final Map<UUID, Queue<TestStep>> testStepQueue = Collections.synchronizedMap(new HashMap());
    private final Map<String, Boolean> examplesRunningMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Boolean> addingScenarioOutlineStepsMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, DataTable> tableMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<Long, Map<String, String>>> exampleRowsMap = Collections.synchronizedMap(new HashMap());
    private Map<Long, List<Tag>> exampleTags;
    private final Map<String, AtomicInteger> exampleCountMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Boolean> waitingToProcessBackgroundSteps = Collections.synchronizedMap(new HashMap());
    private final List<String> currentScenarioIdList = Collections.synchronizedList(new ArrayList());
    private final Map<String, Scenario> currentScenarioDefinitionMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> currentScenarioMap = Collections.synchronizedMap(new HashMap());
    private List<Tag> featureTags = new ArrayList<Tag>();
    private final FeaturePathFormatter featurePathFormatter = new FeaturePathFormatter();
    private final List<BaseStepListener> baseStepListeners;
    private final Map<Integer, List<StepEventBusEvent>> allTestEventsByLine = Collections.synchronizedMap(new TreeMap());
    private final URI scenarioContextURI;
    private StepEventBus stepEventBus;
    private final Map<String, List<Tag>> scenarioTags = Collections.synchronizedMap(new HashMap());

    public ScenarioContextParallel(URI scenarioContextURI) {
        this.baseStepListeners = Collections.synchronizedList(new ArrayList());
        this.scenarioContextURI = scenarioContextURI;
        this.stepEventBus = this.stepEventBus(scenarioContextURI);
    }

    public synchronized Scenario currentScenarioOutline(String scenarioId) {
        return this.currentScenarioDefinitionMap.get(scenarioId);
    }

    public synchronized Queue<Step> getStepQueue(TestCase testCase) {
        this.stepQueue.computeIfAbsent(testCase.getId(), k -> new LinkedList());
        return this.stepQueue.get(testCase.getId());
    }

    public synchronized Queue<TestStep> getTestStepQueue(TestCase testCase) {
        this.testStepQueue.computeIfAbsent(testCase.getId(), k -> new LinkedList());
        return this.testStepQueue.get(testCase.getId());
    }

    public synchronized boolean examplesAreRunning(String scenarioId) {
        if (!this.examplesRunningMap.containsKey(scenarioId)) {
            return false;
        }
        return this.examplesRunningMap.get(scenarioId);
    }

    public synchronized Map<Long, Map<String, String>> getExampleRows(String scenarioId) {
        return this.exampleRowsMap.get(scenarioId);
    }

    public synchronized void setExampleRows(String scenarioId, Map<Long, Map<String, String>> exampleRows) {
        this.exampleRowsMap.put(scenarioId, exampleRows);
    }

    public synchronized Map<Long, List<Tag>> getExampleTags() {
        return this.exampleTags;
    }

    public synchronized void setExampleTags(Map<Long, List<Tag>> exampleTags) {
        this.exampleTags = exampleTags;
    }

    public synchronized int getExampleCount(String scenarioId) {
        if (this.exampleCountMap.containsKey(scenarioId)) {
            return this.exampleCountMap.get(scenarioId).get();
        }
        return 0;
    }

    public synchronized int decrementExampleCount(String scenarioId) {
        if (this.exampleCountMap.get(scenarioId) != null) {
            return this.exampleCountMap.get(scenarioId).decrementAndGet();
        }
        return 0;
    }

    public synchronized DataTable getTable(String scenarioId) {
        return this.tableMap.get(scenarioId);
    }

    public synchronized boolean isWaitingToProcessBackgroundSteps(String scenarioId) {
        return this.waitingToProcessBackgroundSteps.getOrDefault(scenarioId, false);
    }

    public synchronized void addCurrentScenarioId(String scenarioId) {
        if (scenarioId != null) {
            this.currentScenarioIdList.add(scenarioId);
        } else {
            this.currentScenarioIdList.clear();
        }
    }

    public synchronized Scenario getCurrentScenarioDefinition(String scenarioId) {
        return this.currentScenarioDefinitionMap.get(scenarioId);
    }

    public synchronized String getCurrentScenario(String scenarioId) {
        return this.currentScenarioMap.get(scenarioId);
    }

    public synchronized void setCurrentScenario(String scenarioId, String currentScenario) {
        this.currentScenarioMap.put(scenarioId, currentScenario);
    }

    public synchronized List<Tag> getFeatureTags() {
        return this.featureTags;
    }

    public synchronized boolean isAddingScenarioOutlineSteps(String scenarioId) {
        return this.addingScenarioOutlineStepsMap.get(scenarioId) != null ? this.addingScenarioOutlineStepsMap.get(scenarioId) : false;
    }

    public synchronized void doneAddingScenarioOutlineSteps(String scenarioId) {
        this.addingScenarioOutlineStepsMap.put(scenarioId, false);
    }

    public synchronized void setFeatureTags(List<Tag> tags) {
        this.featureTags = new ArrayList<Tag>(tags);
    }

    public synchronized void setCurrentScenarioDefinitionFrom(String scenarioId, TestSourcesModel.AstNode astNode) {
        this.currentScenarioDefinitionMap.put(scenarioId, TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode));
    }

    public synchronized boolean isAScenarioOutline(String scenarioId) {
        return this.currentScenarioDefinitionMap.get(scenarioId) != null && this.currentScenarioDefinitionMap.get(scenarioId).getExamples().size() > 0;
    }

    public synchronized void startNewExample(String scenarioId) {
        this.examplesRunningMap.put(scenarioId, true);
        this.addingScenarioOutlineStepsMap.put(scenarioId, true);
    }

    public synchronized void setExamplesRunning(String scenarioId, boolean examplesRunning) {
        this.examplesRunningMap.put(scenarioId, examplesRunning);
    }

    public synchronized void clearStepQueue(TestCase testCase) {
        this.getStepQueue(testCase).clear();
    }

    public synchronized void clearStepQueue() {
        this.stepQueue.clear();
    }

    public synchronized void clearTestStepQueue() {
        this.testStepQueue.clear();
    }

    public synchronized void queueStep(TestCase testCase, Step step) {
        this.getStepQueue(testCase).add(step);
    }

    public synchronized void queueTestStep(TestCase testCase, TestStep testStep) {
        this.getTestStepQueue(testCase).add(testStep);
    }

    public synchronized Step getCurrentStep(TestCase testCase) {
        return this.getStepQueue(testCase).peek();
    }

    public synchronized Step nextStep(TestCase testCase) {
        return this.getStepQueue(testCase).poll();
    }

    public synchronized TestStep nextTestStep(TestCase testCase) {
        return this.getTestStepQueue(testCase).poll();
    }

    public synchronized boolean noStepsAreQueued(TestCase testCase) {
        return this.getStepQueue(testCase).isEmpty();
    }

    public synchronized boolean hasScenarioId(String scenarioId) {
        return this.currentScenarioIdList.contains(scenarioId);
    }

    public synchronized void setTable(String scenarioId, DataTable table) {
        this.tableMap.put(scenarioId, table);
        this.exampleCountMap.put(scenarioId, new AtomicInteger(table.getSize()));
    }

    public synchronized void addTableRows(String scenarioId, List<String> headers, List<Map<String, String>> rows, String name, String description, Map<Integer, Long> lineNumbersOfEachRow) {
        DataTable table = this.tableMap.get(scenarioId);
        table.startNewDataSet(name, description);
        AtomicInteger rowNumber = new AtomicInteger();
        rows.forEach(row -> table.appendRow(this.newRow(headers, lineNumbersOfEachRow, rowNumber.getAndIncrement(), (Map<String, String>)row)));
        table.updateLineNumbers(lineNumbersOfEachRow);
        this.exampleCountMap.put(scenarioId, new AtomicInteger(table.getSize()));
    }

    @NotNull
    private DataTableRow newRow(List<String> headers, Map<Integer, Long> lineNumbersOfEachRow, int rowNumber, Map<String, String> row) {
        return new DataTableRow(this.rowValuesFrom(headers, row), lineNumbersOfEachRow.getOrDefault(rowNumber, 0L).longValue());
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(row::get).collect(Collectors.toList());
    }

    public synchronized void addTableTags(String scenarioId, List<TestTag> tags) {
        DataTable table = this.tableMap.get(scenarioId);
        table.addTagsToLatestDataSet(tags);
    }

    public synchronized void clearTable() {
        this.tableMap.clear();
    }

    private synchronized StepEventBus stepEventBus(URI featurePath) {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(featurePath);
        return StepEventBus.eventBusFor((Object)prefixedPath);
    }

    public synchronized StepEventBus stepEventBus() {
        return this.stepEventBus;
    }

    public void setStepEventBus(StepEventBus stepEventBus) {
        this.stepEventBus = stepEventBus;
    }

    public void addBaseStepListener(BaseStepListener baseStepListener) {
        this.baseStepListeners.add(baseStepListener);
        this.stepEventBus.registerListener((StepListener)baseStepListener);
    }

    public synchronized void collectAllBaseStepListeners(List<BaseStepListener> allBaseStepListeners) {
        allBaseStepListeners.addAll(this.baseStepListeners);
    }

    public void setWaitingToProcessBackgroundSteps(String scenarioId, boolean waitingToProcessBackgroundSteps) {
        this.waitingToProcessBackgroundSteps.put(scenarioId, waitingToProcessBackgroundSteps);
    }

    public void addHighPriorityStepEventBusEvent(String scenarioId, StepEventBusEvent event) {
        LOGGER.debug("SRP:addHighPriorityStepEventBusEvent " + String.valueOf(event) + " " + String.valueOf(Thread.currentThread()) + " " + scenarioId);
        List eventList = this.highPriorityEventBusEvents.computeIfAbsent(scenarioId, k -> Collections.synchronizedList(new LinkedList()));
        eventList.add(event);
        event.setStepEventBus(this.stepEventBus);
    }

    public void addStepEventBusEvent(StepEventBusEvent event) {
        if (TestSession.isSessionStarted()) {
            TestSession.addEvent((StepEventBusEvent)event);
            event.setStepEventBus(this.stepEventBus);
        } else {
            LOGGER.debug("SRP:ignored event " + String.valueOf(event) + " " + String.valueOf(Thread.currentThread()) + " because session not opened ", (Throwable)new Exception());
        }
    }

    public void storeAllStepEventBusEventsForLine(int line, TestCase testCase) {
        if (TestSession.isSessionStarted()) {
            TestSession.closeSession();
            List stepEventBusEvents = TestSession.getSessionEvents();
            ArrayList clonedEvents = new ArrayList(stepEventBusEvents);
            this.allTestEventsByLine.put(line, clonedEvents);
            TestSession.cleanupSession();
        }
    }

    public synchronized void playAllTestEvents() {
        LOGGER.debug("SRP:playAllTestEvents for URI " + String.valueOf(this.scenarioContextURI) + "--" + String.valueOf(this.allTestEventsByLine));
        for (Map.Entry<Integer, List<StepEventBusEvent>> entry : this.allTestEventsByLine.entrySet()) {
            try {
                this.replayAllTestCaseEventsForLine(entry.getKey(), entry.getValue());
            }
            catch (Throwable exception) {
                LOGGER.error("An unrecoverable error occurred during test execution: " + exception.getMessage(), exception);
                exception.printStackTrace();
                this.recordUnexpectedFailure((Throwable)new SerenityManagedException("An unrecoverable error occurred during test execution: " + exception.getMessage(), exception));
            }
        }
        this.clearEventBus();
    }

    public synchronized void recordUnexpectedFailure(Throwable throwable) {
        this.stepEventBus.getBaseStepListener().getCurrentTestOutcome().testFailedWith(throwable);
    }

    public synchronized void clearEventBus() {
        this.stepEventBus.clear();
        StepEventBus.getParallelEventBus().clear();
    }

    private void replayAllTestCaseEventsForLine(Integer lineNumber, List<StepEventBusEvent> stepEventBusEvents) {
        LOGGER.debug("SRP:PLAY session events for line   " + lineNumber);
        Optional<StepEventBusEvent> eventWithScenarioId = stepEventBusEvents.stream().filter(event -> !event.getScenarioId().isEmpty()).findFirst();
        LOGGER.debug("SRP:EventWithscenarioId   " + String.valueOf(eventWithScenarioId));
        if (eventWithScenarioId.isPresent() && this.highPriorityEventBusEvents.get(eventWithScenarioId.get().getScenarioId()) != null) {
            List<StepEventBusEvent> highPriorityEvents = this.highPriorityEventBusEvents.get(eventWithScenarioId.get().getScenarioId());
            for (StepEventBusEvent currentStepBusEvent : highPriorityEvents) {
                LOGGER.trace("SRP:PLAY session high priority event  " + String.valueOf(currentStepBusEvent));
                currentStepBusEvent.play();
            }
            this.highPriorityEventBusEvents.remove(eventWithScenarioId.get().getScenarioId());
        }
        for (StepEventBusEvent currentStepBusEvent : stepEventBusEvents) {
            LOGGER.trace("SRP:PLAY session event  " + String.valueOf(currentStepBusEvent) + " " + String.valueOf(Thread.currentThread()) + " " + currentStepBusEvent.hashCode());
            currentStepBusEvent.play();
        }
    }

    public List<Tag> getScenarioTags(String scenarioId) {
        return this.scenarioTags.get(scenarioId);
    }

    public void setScenarioTags(String scenarioId, List<Tag> scenarioTags) {
        this.scenarioTags.put(scenarioId, scenarioTags);
    }
}

