/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.Lists;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioFilter
extends Filter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScenarioFilter.class);
    private List<String> scenarios;
    private List<String> scenariosIncluded = Lists.newArrayList();
    private List<String> scenariosExcluded = Lists.newArrayList();

    private ScenarioFilter(List<String> scenarios) {
        this.scenarios = scenarios;
    }

    public static ScenarioFilter onScenarios(List<String> scenarios) {
        return new ScenarioFilter(scenarios);
    }

    public String describe() {
        return String.format("Filters out all test steps except those in the list of scenarios: %s", this.scenarios);
    }

    public boolean shouldRun(Description description) {
        String displayName = description.getDisplayName();
        String methodName = description.getMethodName();
        boolean shouldRun = this.scenarios.stream().anyMatch(methodName::equals) || displayName.startsWith("Examples") || displayName.contains("|");
        LOGGER.debug("Test should run: {} step: {}", (Object)shouldRun, (Object)description.getDisplayName());
        if (shouldRun) {
            this.scenariosIncluded.add(displayName);
        } else {
            this.scenariosExcluded.add(displayName);
        }
        return shouldRun;
    }

    public List<String> scenariosExcluded() {
        return this.scenariosExcluded;
    }

    public List<String> scenariosIncluded() {
        return this.scenariosIncluded;
    }
}

