/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber;

import cucumber.api.Plugin;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.runner.EventBus;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.FeatureSupplier;
import cucumber.runtime.Runtime;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.filter.RerunFilters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.formatter.SerenityReporter;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.junit.Assertions;
import cucumber.runtime.junit.FeatureRunner;
import cucumber.runtime.junit.JUnitOptions;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.CucumberSuiteSlicer;
import net.serenitybdd.cucumber.suiteslicing.ScenarioFilter;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.FeatureRunnerExtractors;
import net.serenitybdd.cucumber.util.Splitter;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberWithSerenity
extends ParentRunner<FeatureRunner> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberWithSerenity.class);
    private final List<FeatureRunner> children = new ArrayList<FeatureRunner>();
    private final EventBus bus;
    private final ThreadLocalRunnerSupplier runnerSupplier;
    private final Filters filters;
    private final JUnitOptions junitOptions;
    private static ThreadLocal<RuntimeOptions> RUNTIME_OPTIONS = new ThreadLocal();

    public CucumberWithSerenity(Class clazz) throws InitializationError {
        super(clazz);
        ClassLoader classLoader = clazz.getClassLoader();
        Assertions.assertNoCucumberAnnotatedMethods((Class)clazz);
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        RuntimeOptions runtimeOptions = runtimeOptionsFactory.create();
        runtimeOptions.getTagFilters().addAll(CucumberWithSerenity.environmentSpecifiedTags(runtimeOptions.getTagFilters()));
        CucumberWithSerenity.setRuntimeOptions(runtimeOptions);
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(featureLoader, runtimeOptions);
        List features = featureSupplier.get();
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier((ResourceLoader)resourceLoader, (ClassFinder)classFinder, runtimeOptions);
        this.bus = new TimeServiceEventBus(TimeService.SYSTEM);
        Plugins plugins = new Plugins(classLoader, new PluginFactory(), (EventPublisher)this.bus, runtimeOptions);
        Configuration systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        SerenityReporter reporter = new SerenityReporter(systemConfiguration, (ResourceLoader)resourceLoader);
        CucumberWithSerenity.addSerenityReporterPlugin(plugins, reporter);
        this.runnerSupplier = new ThreadLocalRunnerSupplier(runtimeOptions, this.bus, (BackendSupplier)backendSupplier);
        RerunFilters rerunFilters = new RerunFilters(runtimeOptions, featureLoader);
        this.filters = new Filters(runtimeOptions, rerunFilters);
        this.junitOptions = new JUnitOptions(runtimeOptions.isStrict(), runtimeOptions.getJunitOptions());
        StepDefinitionReporter stepDefinitionReporter = plugins.stepDefinitionReporter();
        this.bus.send((Event)new TestRunStarted(this.bus.getTime()));
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead(this.bus);
        }
        this.runnerSupplier.get().reportStepDefinitions(stepDefinitionReporter);
        this.addChildren(features);
    }

    public static void setRuntimeOptions(RuntimeOptions runtimeOptions) {
        RUNTIME_OPTIONS.set(runtimeOptions);
    }

    public static RuntimeOptions currentRuntimeOptions() {
        return RUNTIME_OPTIONS.get();
    }

    private static Collection<String> environmentSpecifiedTags(List<?> existingTags) {
        EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
        String tagsExpression = ThucydidesSystemProperty.TAGS.from(environmentVariables, "");
        List existingTagsValues = existingTags.stream().map(Object::toString).collect(Collectors.toList());
        return Splitter.on(",").trimResults().omitEmptyStrings().splitToList(tagsExpression).stream().map(CucumberWithSerenity::toCucumberTag).filter(t -> !existingTagsValues.contains(t)).collect(Collectors.toList());
    }

    private static String toCucumberTag(String from) {
        String tag = from.replaceAll(":", "=");
        if (tag.startsWith("~@") || tag.startsWith("@")) {
            return tag;
        }
        if (tag.startsWith("~")) {
            return "~@" + tag.substring(1);
        }
        return "@" + tag;
    }

    public static Runtime createSerenityEnabledRuntime(ResourceLoader resourceLoader, ClassLoader classLoader, RuntimeOptions runtimeOptions, Configuration systemConfiguration) {
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder(resourceLoader, classLoader);
        runtimeOptions.getTagFilters().addAll(CucumberWithSerenity.environmentSpecifiedTags(runtimeOptions.getTagFilters()));
        CucumberWithSerenity.setRuntimeOptions(runtimeOptions);
        FeatureLoader featureLoader = new FeatureLoader(resourceLoader);
        FeaturePathFeatureSupplier featureSupplier = new FeaturePathFeatureSupplier(featureLoader, runtimeOptions);
        List features = featureSupplier.get();
        TimeServiceEventBus bus = new TimeServiceEventBus(TimeService.SYSTEM);
        bus.send((Event)new TestRunStarted(bus.getTime()));
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead((EventBus)bus);
        }
        SerenityReporter serenityReporter = new SerenityReporter(systemConfiguration, resourceLoader);
        Runtime runtime = Runtime.builder().withResourceLoader(resourceLoader).withClassFinder((ClassFinder)classFinder).withClassLoader(classLoader).withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{serenityReporter}).withEventBus((EventBus)bus).withFeatureSupplier((FeatureSupplier)featureSupplier).build();
        return runtime;
    }

    private static void addSerenityReporterPlugin(Plugins plugins, SerenityReporter plugin) {
        for (Plugin currentPlugin : plugins.getPlugins()) {
            if (!(currentPlugin instanceof SerenityReporter)) continue;
            return;
        }
        plugins.addPlugin((Plugin)plugin);
    }

    protected Description describeChild(FeatureRunner child) {
        return child.getDescription();
    }

    protected void runChild(FeatureRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    protected Statement childrenInvoker(RunNotifier notifier) {
        final Statement features = super.childrenInvoker(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                features.evaluate();
                CucumberWithSerenity.this.bus.send((Event)new TestRunFinished(CucumberWithSerenity.this.bus.getTime()));
            }
        };
    }

    private void addChildren(List<CucumberFeature> cucumberFeatures) throws InitializationError {
        for (CucumberFeature cucumberFeature : cucumberFeatures) {
            FeatureRunner featureRunner = new FeatureRunner(cucumberFeature, this.filters, this.runnerSupplier, this.junitOptions);
            if (featureRunner.isEmpty()) continue;
            this.children.add(featureRunner);
        }
    }

    public List<FeatureRunner> getChildren() {
        try {
            EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
            RuntimeOptions runtimeOptions = CucumberWithSerenity.currentRuntimeOptions();
            List tagFilters = runtimeOptions.getTagFilters();
            List featurePaths = runtimeOptions.getFeaturePaths();
            int batchNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_NUMBER, Integer.valueOf(1));
            int batchCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_COUNT, Integer.valueOf(1));
            int forkNumber = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_NUMBER, Integer.valueOf(1));
            int forkCount = environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_COUNT, Integer.valueOf(1));
            if (batchCount == 1 && forkCount == 1) {
                return this.children;
            }
            LOGGER.info("Running slice {} of {} using fork {} of {} from feature paths {}", new Object[]{batchNumber, batchCount, forkNumber, forkCount, featurePaths});
            WeightedCucumberScenarios weightedCucumberScenarios = new CucumberSuiteSlicer(featurePaths, TestStatistics.from(environmentVariables, featurePaths)).scenarios(batchNumber, batchCount, forkNumber, forkCount, tagFilters);
            List<FeatureRunner> unfilteredChildren = this.children;
            AtomicInteger filteredInScenarioCount = new AtomicInteger();
            List<FeatureRunner> filteredChildren = unfilteredChildren.stream().filter(this.forIncludedFeatures(weightedCucumberScenarios)).map(this.toPossibleFeatureRunner(weightedCucumberScenarios, filteredInScenarioCount)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            if (filteredInScenarioCount.get() != weightedCucumberScenarios.totalScenarioCount()) {
                LOGGER.warn("There is a mismatch between the number of scenarios included in this test run ({}) and the expected number of scenarios loaded ({}). This suggests that the scenario filtering is not working correctly or feature file(s) of an unexpected structure are being run", (Object)filteredInScenarioCount.get(), (Object)weightedCucumberScenarios.scenarios.size());
            }
            LOGGER.info("Running {} of {} features", (Object)filteredChildren.size(), (Object)unfilteredChildren.size());
            return filteredChildren;
        }
        catch (Exception e) {
            LOGGER.error("Test failed to start", (Throwable)e);
            throw e;
        }
    }

    private Function<FeatureRunner, Optional<FeatureRunner>> toPossibleFeatureRunner(WeightedCucumberScenarios weightedCucumberScenarios, AtomicInteger filteredInScenarioCount) {
        return featureRunner -> {
            int initialScenarioCount = featureRunner.getDescription().getChildren().size();
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            try {
                ScenarioFilter filter = weightedCucumberScenarios.createFilterContainingScenariosIn(featureName);
                String featurePath = FeatureRunnerExtractors.featurePathFor(featureRunner);
                featureRunner.filter((Filter)filter);
                if (!filter.scenariosIncluded().isEmpty()) {
                    LOGGER.info("{} scenario(s) included for '{}' in {}", new Object[]{filter.scenariosIncluded().size(), featureName, featurePath});
                    filter.scenariosIncluded().forEach(scenario -> {
                        LOGGER.info("Included scenario '{}'", scenario);
                        filteredInScenarioCount.getAndIncrement();
                    });
                }
                if (!filter.scenariosExcluded().isEmpty()) {
                    LOGGER.debug("{} scenario(s) excluded for '{}' in {}", new Object[]{filter.scenariosExcluded().size(), featureName, featurePath});
                    filter.scenariosExcluded().forEach(scenario -> LOGGER.debug("Excluded scenario '{}'", scenario));
                }
                return Optional.of(featureRunner);
            }
            catch (NoTestsRemainException e) {
                LOGGER.info("Filtered out all {} scenarios for feature '{}'", (Object)initialScenarioCount, (Object)featureName);
                return Optional.empty();
            }
        };
    }

    private Predicate<FeatureRunner> forIncludedFeatures(WeightedCucumberScenarios weightedCucumberScenarios) {
        return featureRunner -> {
            String featureName = FeatureRunnerExtractors.extractFeatureName(featureRunner);
            String featurePath = Paths.get(FeatureRunnerExtractors.featurePathFor(featureRunner), new String[0]).getFileName().toString();
            boolean matches = weightedCucumberScenarios.scenarios.stream().anyMatch(scenario -> featurePath.equals(scenario.featurePath));
            LOGGER.debug("{} in filtering '{}' in {}", new Object[]{matches ? "Including" : "Not including", featureName, featurePath});
            return matches;
        };
    }
}

