/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import com.google.common.collect.Lists;
import cucumber.api.HookTestStep;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Plugin;
import cucumber.api.Result;
import cucumber.api.TestStep;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.runtime.formatter.ManualScenarioChecker;
import cucumber.runtime.formatter.TaggedScenario;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.runtime.formatter.UpdateManualScenario;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import gherkin.ast.Background;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.pickles.Argument;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SerenityListeners;
import net.serenitybdd.core.SerenityReports;
import net.serenitybdd.cucumber.CucumberWithSerenity;
import net.serenitybdd.cucumber.formatting.ScenarioOutlineDescription;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.TestSourceType;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReporter
implements Plugin,
ConcurrentEventListener {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private static final String SCENARIO_OUTLINE_NOT_KNOWN_YET = "";
    private final Queue<Step> stepQueue;
    private final Queue<TestStep> testStepQueue;
    private Configuration systemConfiguration;
    private final List<BaseStepListener> baseStepListeners;
    private boolean examplesRunning;
    private Map<Integer, Map<String, String>> exampleRows;
    private Map<Integer, List<Tag>> exampleTags;
    private int exampleCount = 0;
    private DataTable table;
    private boolean waitingToProcessBackgroundSteps = false;
    private static final String FEATURES_ROOT_PATH = "features";
    private final TestSourcesModel testSources = new TestSourcesModel();
    private String currentScenarioId;
    private ScenarioDefinition currentScenarioDefinition;
    private String currentScenario;
    private List<Tag> featureTags;
    private boolean addingScenarioOutlineSteps = false;
    private Map<String, List<Long>> lineFilters;
    private List<Tag> scenarioTags;
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityReporter.class);
    private ManualScenarioChecker manualScenarioDateChecker;
    private EventHandler<TestSourceRead> testSourceReadHandler = event -> this.handleTestSourceRead((TestSourceRead)event);
    private EventHandler<TestCaseStarted> caseStartedHandler = event -> this.handleTestCaseStarted((TestCaseStarted)event);
    private EventHandler<TestCaseFinished> caseFinishedHandler = event -> this.handleTestCaseFinished((TestCaseFinished)event);
    private EventHandler<TestStepStarted> stepStartedHandler = event -> this.handleTestStepStarted((TestStepStarted)event);
    private EventHandler<TestStepFinished> stepFinishedHandler = event -> this.handleTestStepFinished((TestStepFinished)event);
    private EventHandler<TestRunStarted> runStartedHandler = event -> this.handleTestRunStarted((TestRunStarted)event);
    private EventHandler<TestRunFinished> runFinishedHandler = event -> this.handleTestRunFinished((TestRunFinished)event);
    private EventHandler<WriteEvent> writeEventHandler = event -> this.handleWrite((WriteEvent)event);
    private ThreadLocal<String> currentFeaturePath = new ThreadLocal();

    public SerenityReporter() {
        this.systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        this.manualScenarioDateChecker = new ManualScenarioChecker(this.systemConfiguration.getEnvironmentVariables());
        this.stepQueue = new LinkedList<Step>();
        this.testStepQueue = new LinkedList<TestStep>();
        this.baseStepListeners = Collections.synchronizedList(new ArrayList());
        this.initLineFilters((ResourceLoader)new MultiLoader(SerenityReporter.class.getClassLoader()));
    }

    public SerenityReporter(Configuration systemConfiguration, ResourceLoader resourceLoader) {
        this.systemConfiguration = systemConfiguration;
        this.manualScenarioDateChecker = new ManualScenarioChecker(systemConfiguration.getEnvironmentVariables());
        this.stepQueue = new LinkedList<Step>();
        this.testStepQueue = new LinkedList<TestStep>();
        this.baseStepListeners = Collections.synchronizedList(new ArrayList());
        this.initLineFilters((ResourceLoader)new MultiLoader(SerenityReporter.class.getClassLoader()));
    }

    private StepEventBus getStepEventBus(String featurePath) {
        if (this.lineFilters.containsKey(featurePath)) {
            featurePath = featurePath + ":" + this.lineFilters.get(featurePath).get(0);
        }
        return StepEventBus.eventBusFor((Object)featurePath);
    }

    private void setStepEventBus(String featurePath) {
        if (this.lineFilters.containsKey(featurePath)) {
            featurePath = featurePath + ":" + this.lineFilters.get(featurePath).get(0);
        }
        StepEventBus.setCurrentBusToEventBusFor((Object)featurePath);
    }

    private void initialiseThucydidesListenersFor(String featurePath) {
        if (this.getStepEventBus(featurePath).isBaseStepListenerRegistered()) {
            return;
        }
        SerenityListeners listeners = new SerenityListeners(this.getStepEventBus(featurePath), this.systemConfiguration);
        this.baseStepListeners.add(listeners.getBaseStepListener());
    }

    private void handleTestRunStarted(TestRunStarted event) {
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunStarted.class, this.runStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
    }

    private void currentFeaturePathIs(String featurePath) {
        this.currentFeaturePath.set(featurePath);
    }

    private String currentFeaturePath() {
        return this.currentFeaturePath.get();
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
        String featurePath = event.uri;
        Optional<Feature> possibleFeature = this.featureFrom(featurePath);
        possibleFeature.ifPresent(feature -> {
            this.featureTags = new ArrayList<Tag>(feature.getTags());
            this.resetEventBusFor(featurePath);
            this.initialiseThucydidesListenersFor(featurePath);
            this.configureDriver((Feature)feature, featurePath);
            Story userStory = this.userStoryFrom((Feature)feature, this.relativeUriFrom(event.uri));
            this.getStepEventBus(event.uri).testSuiteStarted(userStory);
        });
    }

    private void resetEventBusFor(String featurePath) {
        StepEventBus.clearEventBusFor((Object)featurePath);
    }

    private String relativeUriFrom(String fullPathUri) {
        String featuresRoot = File.separatorChar + FEATURES_ROOT_PATH + File.separatorChar;
        if (fullPathUri.contains(featuresRoot)) {
            return fullPathUri.substring(fullPathUri.lastIndexOf(featuresRoot) + FEATURES_ROOT_PATH.length() + 2);
        }
        return fullPathUri;
    }

    private Optional<Feature> featureFrom(String featureFileUri) {
        String defaultFeatureId = new File(featureFileUri).getName().replace(".feature", SCENARIO_OUTLINE_NOT_KNOWN_YET);
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        this.parseGherkinIn(featureFileUri);
        if (StringUtils.isEmpty((CharSequence)this.testSources.getFeatureName(featureFileUri))) {
            return Optional.empty();
        }
        Feature feature = this.testSources.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureWithDefaultName(feature, defaultFeatureName);
        }
        return Optional.of(feature);
    }

    private void parseGherkinIn(String featureFileUri) {
        try {
            this.testSources.getFeature(featureFileUri);
        }
        catch (Throwable ignoreParsingErrors) {
            LOGGER.warn("Could not parse the Gherkin in feature file " + featureFileUri + ": file ignored");
        }
    }

    private Story userStoryFrom(Feature feature, String featureFileUri) {
        Story userStory = Story.withIdAndPath((String)TestSourcesModel.convertToId((String)feature.getName()), (String)feature.getName(), (String)featureFileUri).asFeature();
        if (!StringUtils.isEmpty((CharSequence)feature.getDescription())) {
            userStory = userStory.withNarrative(feature.getDescription());
        }
        return userStory;
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        this.currentFeaturePathIs(event.testCase.getUri());
        this.setStepEventBus(event.testCase.getUri());
        String scenarioName = event.testCase.getName();
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeaturePath(), event.testCase.getLine());
        Optional<Feature> currentFeature = this.featureFrom(event.testCase.getUri());
        if (astNode != null && currentFeature.isPresent()) {
            boolean newScenario;
            this.currentScenarioDefinition = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)astNode);
            String scenarioId = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)this.currentScenarioDefinition.getName()));
            boolean bl = newScenario = !scenarioId.equals(this.currentScenario);
            if (newScenario) {
                this.configureDriver(currentFeature.get(), this.currentFeaturePath());
                if (this.currentScenarioDefinition instanceof ScenarioOutline) {
                    this.examplesRunning = true;
                    this.addingScenarioOutlineSteps = true;
                    this.examples(currentFeature.get(), ((ScenarioOutline)this.currentScenarioDefinition).getTags(), this.currentScenarioDefinition.getName(), ((ScenarioOutline)this.currentScenarioDefinition).getExamples());
                }
                this.startOfScenarioLifeCycle(currentFeature.get(), scenarioName, this.currentScenarioDefinition, event.testCase.getLine());
                this.currentScenario = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)this.currentScenarioDefinition.getName()));
            } else if (this.currentScenarioDefinition instanceof ScenarioOutline) {
                this.startExample(event.testCase.getLine());
            }
            Background background = TestSourcesModel.getBackgroundForTestCase((TestSourcesModel.AstNode)astNode);
            if (background != null) {
                this.handleBackground(background);
            }
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (this.examplesRunning) {
            this.handleResult(event.result);
        }
        if (this.examplesRunning) {
            this.finishExample();
        }
        if (event.result.is(Result.Type.FAILED) && this.noAnnotatedResultIdDefinedFor(event)) {
            this.getStepEventBus(event.testCase.getUri()).testFailed(event.result.getError());
        } else {
            this.getStepEventBus(event.testCase.getUri()).testFinished(this.examplesRunning);
        }
        this.stepQueue.clear();
    }

    private boolean noAnnotatedResultIdDefinedFor(TestCaseFinished event) {
        BaseStepListener baseStepListener = this.getStepEventBus(event.testCase.getUri()).getBaseStepListener();
        return baseStepListener.getTestOutcomes().isEmpty() || this.latestOf(baseStepListener.getTestOutcomes()).getAnnotatedResult() == null;
    }

    private TestOutcome latestOf(List<TestOutcome> testOutcomes) {
        return testOutcomes.get(testOutcomes.size() - 1);
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (!(event.testStep instanceof HookTestStep) && event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep pickleTestStep = (PickleStepTestStep)event.testStep;
            TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeaturePath(), pickleTestStep.getStepLine());
            if (astNode != null) {
                Step step = (Step)astNode.node;
                if (!this.addingScenarioOutlineSteps) {
                    this.stepQueue.add(step);
                    this.testStepQueue.add(event.testStep);
                }
                Step currentStep = this.stepQueue.peek();
                String stepTitle = this.stepTitleFrom(currentStep, (TestStep)pickleTestStep);
                this.getStepEventBus(this.currentFeaturePath()).stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
                this.getStepEventBus(this.currentFeaturePath()).updateCurrentStepTitle(this.normalized(stepTitle));
            }
        }
    }

    private void handleWrite(WriteEvent event) {
        this.getStepEventBus(this.currentFeaturePath()).stepStarted(ExecutedStepDescription.withTitle((String)event.text));
        this.getStepEventBus(this.currentFeaturePath()).stepFinished();
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (!(event.testStep instanceof HookTestStep)) {
            this.handleResult(event.result);
        }
    }

    private void handleTestRunFinished(TestRunFinished event) {
        this.generateReports();
        this.assureTestSuiteFinished();
    }

    private ReportService getReportService() {
        return SerenityReports.getReportService((Configuration)this.systemConfiguration);
    }

    private Feature featureWithDefaultName(Feature feature, String defaultName) {
        return new Feature(feature.getTags(), feature.getLocation(), feature.getLanguage(), feature.getKeyword(), defaultName, feature.getDescription(), feature.getChildren());
    }

    private void configureDriver(Feature feature, String featurePath) {
        this.getStepEventBus(featurePath).setUniqueSession(this.systemConfiguration.shouldUseAUniqueBrowser());
        List<String> tags = this.getTagNamesFrom(feature.getTags());
        String requestedDriver = this.getDriverFrom(tags);
        String requestedDriverOptions = this.getDriverOptionsFrom(tags);
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)requestedDriver);
            ThucydidesWebDriverSupport.useDriverOptions((String)requestedDriverOptions);
        }
    }

    private List<String> getTagNamesFrom(List<Tag> tags) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Tag tag : tags) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    private String getDriverFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver:")) continue;
            requestedDriver = tag.substring(8);
        }
        return requestedDriver;
    }

    private String getDriverOptionsFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver-options:")) continue;
            requestedDriver = tag.substring(16);
        }
        return requestedDriver;
    }

    private void examples(Feature currentFeature, List<Tag> scenarioOutlineTags, String id, List<Examples> examplesList) {
        String featureName = currentFeature.getName();
        List currentFeatureTags = currentFeature.getTags();
        this.addingScenarioOutlineSteps = false;
        this.initializeExamples();
        for (Examples examples : examplesList) {
            if (!this.examplesAreNotExcludedByTags(examples, scenarioOutlineTags, currentFeatureTags) || !this.examplesAreNotExcludedByLinesFilter(examples)) continue;
            List<TableRow> examplesTableRows = examples.getTableBody().stream().filter(tableRow -> this.tableRowIsNotExcludedByLinesFilter((TableRow)tableRow)).collect(Collectors.toList());
            List<String> headers = this.getHeadersFrom(examples.getTableHeader());
            List<Map<String, String>> rows = this.getValuesFrom(examplesTableRows, headers);
            for (int i = 0; i < examplesTableRows.size(); ++i) {
                this.addRow(this.exampleRows(), headers, examplesTableRows.get(i));
                if (examples.getTags() == null) continue;
                this.exampleTags().put(examplesTableRows.get(i).getLocation().getLine(), examples.getTags());
            }
            String scenarioId = this.scenarioIdFrom(featureName, id);
            boolean newScenario = !scenarioId.equals(this.currentScenarioId);
            this.table = newScenario ? this.thucydidesTableFrom(SCENARIO_OUTLINE_NOT_KNOWN_YET, headers, rows, this.trim(examples.getName()), this.trim(examples.getDescription())) : this.addTableRowsTo(this.table, headers, rows, this.trim(examples.getName()), this.trim(examples.getDescription()));
            this.table.addTagsToLatestDataSet(examples.getTags().stream().map(tag -> TestTag.withValue((String)tag.getName().substring(1))).collect(Collectors.toList()));
            this.exampleCount = this.table.getSize();
            this.currentScenarioId = scenarioId;
        }
    }

    private void initLineFilters(ResourceLoader resourceLoader) {
        if (this.lineFilters == null) {
            Map lineFiltersFromRuntime = CucumberWithSerenity.currentRuntimeOptions().getLineFilters();
            this.lineFilters = lineFiltersFromRuntime == null ? new HashMap<String, List<Long>>() : lineFiltersFromRuntime;
        }
    }

    private boolean examplesAreNotExcludedByLinesFilter(Examples examples) {
        if (this.lineFilters.isEmpty()) {
            return true;
        }
        if (!this.lineFilters.containsKey(this.currentFeaturePath())) {
            return false;
        }
        return examples.getTableBody().stream().anyMatch(row -> this.lineFilters.get(this.currentFeaturePath()).contains(row.getLocation().getLine()));
    }

    private boolean tableRowIsNotExcludedByLinesFilter(TableRow tableRow) {
        if (this.lineFilters.isEmpty()) {
            return true;
        }
        if (!this.lineFilters.containsKey(this.currentFeaturePath())) {
            return false;
        }
        return this.lineFilters.get(this.currentFeaturePath()).contains(tableRow.getLocation().getLine());
    }

    private boolean examplesAreNotExcludedByTags(Examples examples, List<Tag> scenarioOutlineTags, List<Tag> currentFeatureTags) {
        if (this.testRunHasFilterTags()) {
            return this.examplesMatchFilter(examples, scenarioOutlineTags, currentFeatureTags);
        }
        return true;
    }

    private boolean examplesMatchFilter(Examples examples, List<Tag> scenarioOutlineTags, List<Tag> currentFeatureTags) {
        List<Tag> allExampleTags = this.getExampleAllTags(examples, scenarioOutlineTags, currentFeatureTags);
        List allTagsForAnExampleScenario = allExampleTags.stream().map(Tag::getName).collect(Collectors.toList());
        String TagValuesFromCucumberOptions = this.getCucumberRuntimeTags().get(0);
        TagExpressionParser parser = new TagExpressionParser();
        Expression expressionNode = parser.parse(TagValuesFromCucumberOptions);
        return expressionNode.evaluate(allTagsForAnExampleScenario);
    }

    private boolean testRunHasFilterTags() {
        List<String> tagFilters = this.getCucumberRuntimeTags();
        return tagFilters != null && tagFilters.size() > 0;
    }

    private List<String> getCucumberRuntimeTags() {
        if (CucumberWithSerenity.currentRuntimeOptions() == null) {
            return new ArrayList<String>();
        }
        return CucumberWithSerenity.currentRuntimeOptions().getTagFilters();
    }

    private List<Tag> getExampleAllTags(Examples examples, List<Tag> scenarioOutlineTags, List<Tag> currentFeatureTags) {
        List exampleTags = examples.getTags();
        ArrayList<Tag> allTags = new ArrayList<Tag>();
        if (exampleTags != null) {
            allTags.addAll(exampleTags);
        }
        if (scenarioOutlineTags != null) {
            allTags.addAll(scenarioOutlineTags);
        }
        if (currentFeatureTags != null) {
            allTags.addAll(currentFeatureTags);
        }
        return allTags;
    }

    private List<String> getHeadersFrom(TableRow headerRow) {
        return headerRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
    }

    private List<Map<String, String>> getValuesFrom(List<TableRow> examplesTableRows, List<String> headers) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (int row = 0; row < examplesTableRows.size(); ++row) {
            HashMap<String, String> rowValues = new HashMap<String, String>();
            int column = 0;
            List cells = examplesTableRows.get(row).getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
            for (String cellValue : cells) {
                String columnName = headers.get(column++);
                rowValues.put(columnName, cellValue);
            }
            rows.add(rowValues);
        }
        return rows;
    }

    private void addRow(Map<Integer, Map<String, String>> exampleRows, List<String> headers, TableRow currentTableRow) {
        LinkedHashMap row = new LinkedHashMap();
        for (int j = 0; j < headers.size(); ++j) {
            List cells = currentTableRow.getCells().stream().map(TableCell::getValue).collect(Collectors.toList());
            row.put(headers.get(j), cells.get(j));
        }
        this.exampleRows().put(currentTableRow.getLocation().getLine(), row);
    }

    private String scenarioIdFrom(String featureId, String scenarioIdOrExampleId) {
        return featureId != null && scenarioIdOrExampleId != null ? String.format("%s;%s", featureId, scenarioIdOrExampleId) : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private void initializeExamples() {
        this.examplesRunning = true;
    }

    private Map<Integer, Map<String, String>> exampleRows() {
        if (this.exampleRows == null) {
            this.exampleRows = Collections.synchronizedMap(new HashMap());
        }
        return this.exampleRows;
    }

    private Map<Integer, List<Tag>> exampleTags() {
        if (this.exampleTags == null) {
            this.exampleTags = Collections.synchronizedMap(new HashMap());
        }
        return this.exampleTags;
    }

    private DataTable thucydidesTableFrom(String scenarioOutline, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        return DataTable.withHeaders(headers).andScenarioOutline(scenarioOutline).andMappedRows(rows).andTitle(name).andDescription(description).build();
    }

    private DataTable addTableRowsTo(DataTable table, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        table.startNewDataSet(name, description);
        for (Map<String, String> row : rows) {
            table.appendRow(this.rowValuesFrom(headers, row));
        }
        return table;
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(header -> (String)row.get(header)).collect(Collectors.toList());
    }

    private void startOfScenarioLifeCycle(Feature feature, String scenarioName, ScenarioDefinition scenario, Integer currentLine) {
        boolean newScenario = !this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName())).equals(this.currentScenario);
        this.currentScenario = this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName()));
        if (this.examplesRunning) {
            if (newScenario) {
                this.startScenario(feature, scenario, scenarioName);
                this.getStepEventBus(this.currentFeaturePath()).useExamplesFrom(this.table);
                this.getStepEventBus(this.currentFeaturePath()).useScenarioOutline(ScenarioOutlineDescription.from(scenario).getDescription());
            } else {
                this.getStepEventBus(this.currentFeaturePath()).addNewExamplesFrom(this.table);
            }
            this.startExample(currentLine);
        } else {
            this.startScenario(feature, scenario, scenarioName);
        }
    }

    private void startScenario(Feature currentFeature, ScenarioDefinition scenarioDefinition, String scenarioName) {
        this.getStepEventBus(this.currentFeaturePath()).setTestSource(TestSourceType.TEST_SOURCE_CUCUMBER.getValue());
        this.getStepEventBus(this.currentFeaturePath()).testStarted(scenarioName, this.scenarioIdFrom(TestSourcesModel.convertToId((String)currentFeature.getName()), TestSourcesModel.convertToId((String)scenarioName)));
        this.getStepEventBus(this.currentFeaturePath()).addDescriptionToCurrentTest(scenarioDefinition.getDescription());
        this.getStepEventBus(this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(currentFeature.getTags()));
        if (this.isScenario(scenarioDefinition)) {
            this.getStepEventBus(this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(((Scenario)scenarioDefinition).getTags()));
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            this.getStepEventBus(this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(((ScenarioOutline)scenarioDefinition).getTags()));
        }
        this.registerFeatureJiraIssues(currentFeature.getTags());
        List<Tag> tags = this.getTagsOfScenarioDefinition(scenarioDefinition);
        this.registerScenarioJiraIssues(tags);
        this.scenarioTags = this.tagsForScenario(scenarioDefinition);
        this.updateResultFromTags(this.scenarioTags);
    }

    private List<Tag> tagsForScenario(ScenarioDefinition scenarioDefinition) {
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>(this.featureTags);
        scenarioTags.addAll(this.getTagsOfScenarioDefinition(scenarioDefinition));
        return scenarioTags;
    }

    private boolean isScenario(ScenarioDefinition scenarioDefinition) {
        return scenarioDefinition instanceof Scenario;
    }

    private boolean isScenarioOutline(ScenarioDefinition scenarioDefinition) {
        return scenarioDefinition instanceof ScenarioOutline;
    }

    private List<Tag> getTagsOfScenarioDefinition(ScenarioDefinition scenarioDefinition) {
        List tags = new ArrayList();
        if (this.isScenario(scenarioDefinition)) {
            tags = ((Scenario)scenarioDefinition).getTags();
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            tags = ((ScenarioOutline)scenarioDefinition).getTags();
        }
        return tags;
    }

    private void registerFeatureJiraIssues(List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            this.getStepEventBus(this.currentFeaturePath()).addIssuesToCurrentStory(issues);
        }
    }

    private void registerScenarioJiraIssues(List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            this.getStepEventBus(this.currentFeaturePath()).addIssuesToCurrentTest(issues);
        }
    }

    private List<TestTag> convertCucumberTags(List<Tag> cucumberTags) {
        cucumberTags = this.completeManualTagsIn(cucumberTags);
        return cucumberTags.stream().map(tag -> TestTag.withValue((String)tag.getName().substring(1))).collect(Collectors.toList());
    }

    private List<Tag> completeManualTagsIn(List<Tag> cucumberTags) {
        if (this.unqualifiedManualTag(cucumberTags).isPresent() && this.doesNotContainResultTag(cucumberTags)) {
            ArrayList updatedTags = Lists.newArrayList(cucumberTags);
            updatedTags.add(new Tag(this.unqualifiedManualTag(cucumberTags).get().getLocation(), "@manual:pending"));
            return updatedTags;
        }
        return cucumberTags;
    }

    private boolean doesNotContainResultTag(List<Tag> tags) {
        return !tags.stream().noneMatch(tag -> tag.getName().startsWith("@manual:"));
    }

    private Optional<Tag> unqualifiedManualTag(List<Tag> tags) {
        return tags.stream().filter(tag -> tag.getName().equalsIgnoreCase("@manual")).findFirst();
    }

    private List<String> extractJiraIssueTags(List<Tag> cucumberTags) {
        ArrayList<String> issues = new ArrayList<String>();
        for (Tag tag : cucumberTags) {
            if (tag.getName().startsWith("@issue:")) {
                String tagIssueValue = tag.getName().substring("@issue:".length());
                issues.add(tagIssueValue);
            }
            if (!tag.getName().startsWith("@issues:")) continue;
            String tagIssuesValues = tag.getName().substring("@issues:".length());
            issues.addAll(Arrays.asList(tagIssuesValues.split(",")));
        }
        return issues;
    }

    private void startExample(Integer lineNumber) {
        Map<String, String> data = this.exampleRows().get(lineNumber);
        this.getStepEventBus(this.currentFeaturePath()).clearStepFailures();
        this.getStepEventBus(this.currentFeaturePath()).exampleStarted(data);
        if (this.exampleTags().containsKey(lineNumber)) {
            List<Tag> currentExampleTags = this.exampleTags().get(lineNumber);
            this.getStepEventBus(this.currentFeaturePath()).addTagsToCurrentTest(this.convertCucumberTags(currentExampleTags));
        }
    }

    private void finishExample() {
        this.getStepEventBus(this.currentFeaturePath()).exampleFinished();
        --this.exampleCount;
        if (this.exampleCount == 0) {
            this.examplesRunning = false;
            this.setTableScenarioOutline();
        } else {
            this.examplesRunning = true;
        }
    }

    private void setTableScenarioOutline() {
        List steps = this.currentScenarioDefinition.getSteps();
        StringBuffer scenarioOutlineBuffer = new StringBuffer();
        for (Step step : steps) {
            scenarioOutlineBuffer.append(step.getKeyword()).append(step.getText()).append("\n\r");
        }
        String scenarioOutline = scenarioOutlineBuffer.toString();
        if (this.table != null) {
            this.table.setScenarioOutline(scenarioOutline);
        }
    }

    private void handleBackground(Background background) {
        String backgroundDescription;
        this.waitingToProcessBackgroundSteps = true;
        String backgroundName = background.getName();
        if (backgroundName != null) {
            this.getStepEventBus(this.currentFeaturePath()).setBackgroundTitle(backgroundName);
        }
        if ((backgroundDescription = background.getDescription()) == null) {
            backgroundDescription = SCENARIO_OUTLINE_NOT_KNOWN_YET;
        }
        this.getStepEventBus(this.currentFeaturePath()).setBackgroundDescription(backgroundDescription);
    }

    private void assureTestSuiteFinished() {
        this.stepQueue.clear();
        this.testStepQueue.clear();
        Optional.ofNullable(this.currentFeaturePath()).ifPresent(featurePath -> {
            this.getStepEventBus((String)featurePath).testSuiteFinished();
            this.getStepEventBus((String)featurePath).dropAllListeners();
            this.getStepEventBus((String)featurePath).clear();
            StepEventBus.clearEventBusFor((Object)featurePath);
        });
        Serenity.done();
        this.table = null;
        this.currentScenarioId = null;
    }

    private void handleResult(Result result) {
        Step currentStep = this.stepQueue.poll();
        TestStep currentTestStep = this.testStepQueue.poll();
        this.recordStepResult(result, currentStep, currentTestStep);
        if (this.stepQueue.isEmpty()) {
            this.recordFinalResult();
        }
    }

    private void recordStepResult(Result result, Step currentStep, TestStep currentTestStep) {
        if (StepEventBus.getEventBus().currentTestIsSuspended()) {
            this.getStepEventBus(this.currentFeaturePath()).stepIgnored();
        } else if (Result.Type.PASSED.equals((Object)result.getStatus())) {
            this.getStepEventBus(this.currentFeaturePath()).stepFinished();
        } else if (Result.Type.FAILED.equals((Object)result.getStatus())) {
            this.failed(this.stepTitleFrom(currentStep, currentTestStep), result.getError());
        } else if (Result.Type.SKIPPED.equals((Object)result.getStatus())) {
            this.getStepEventBus(this.currentFeaturePath()).stepIgnored();
        } else if (Result.Type.PENDING.equals((Object)result.getStatus())) {
            this.getStepEventBus(this.currentFeaturePath()).stepPending();
        } else if (Result.Type.SKIPPED.equals((Object)result.getStatus())) {
            this.getStepEventBus(this.currentFeaturePath()).stepIgnored();
        } else if (Result.Type.UNDEFINED.equals((Object)result.getStatus())) {
            this.getStepEventBus(this.currentFeaturePath()).stepPending();
        }
    }

    private void recordFinalResult() {
        if (this.waitingToProcessBackgroundSteps) {
            this.waitingToProcessBackgroundSteps = false;
        } else {
            this.updateResultFromTags(this.scenarioTags);
        }
    }

    private void updateResultFromTags(List<Tag> scenarioTags) {
        if (TaggedScenario.isManual(scenarioTags)) {
            this.updateManualResultsFrom(scenarioTags);
        } else if (TaggedScenario.isPending(scenarioTags)) {
            this.getStepEventBus(this.currentFeaturePath()).testPending();
        } else if (TaggedScenario.isSkippedOrWIP(scenarioTags)) {
            this.getStepEventBus(this.currentFeaturePath()).testSkipped();
            this.updateCurrentScenarioResultTo(TestResult.SKIPPED);
        } else if (TaggedScenario.isIgnored(scenarioTags)) {
            this.getStepEventBus(this.currentFeaturePath()).testIgnored();
            this.updateCurrentScenarioResultTo(TestResult.IGNORED);
        }
    }

    private void updateManualResultsFrom(List<Tag> scenarioTags) {
        this.getStepEventBus(this.currentFeaturePath()).testIsManual();
        TaggedScenario.manualResultDefinedIn(scenarioTags).ifPresent(testResult -> UpdateManualScenario.forScenario(this.currentScenarioDefinition.getDescription()).inContext(this.getStepEventBus(this.currentFeaturePath()).getBaseStepListener(), this.systemConfiguration.getEnvironmentVariables()).updateManualScenario((TestResult)testResult, scenarioTags));
    }

    private void updateCurrentScenarioResultTo(TestResult pending) {
        this.getStepEventBus(this.currentFeaturePath()).getBaseStepListener().overrideResultTo(pending);
    }

    private void failed(String stepTitle, Throwable cause) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            Throwable rootCause;
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                this.getStepEventBus(this.currentFeaturePath()).updateCurrentStepTitle(stepTitle);
            }
            if (this.isAssumptionFailure(rootCause = new RootCauseAnalyzer(cause).getRootCause().toException())) {
                this.getStepEventBus(this.currentFeaturePath()).assumptionViolated(rootCause.getMessage());
            } else {
                this.getStepEventBus(this.currentFeaturePath()).stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(this.currentStepTitle())), rootCause));
            }
        }
    }

    private String currentStepTitle() {
        return this.getStepEventBus(this.currentFeaturePath()).getCurrentStep().isPresent() ? ((net.thucydides.core.model.TestStep)this.getStepEventBus(this.currentFeaturePath()).getCurrentStep().get()).getDescription() : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private boolean errorOrFailureRecordedForStep(String stepTitle, Throwable cause) {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        if (!this.latestTestOutcome().get().testStepWithDescription(stepTitle).isPresent()) {
            return false;
        }
        Optional matchingTestStep = this.latestTestOutcome().get().testStepWithDescription(stepTitle);
        if (matchingTestStep.isPresent() && ((net.thucydides.core.model.TestStep)matchingTestStep.get()).getException() != null) {
            return ((net.thucydides.core.model.TestStep)matchingTestStep.get()).getException().getOriginalCause() == cause;
        }
        return false;
    }

    private Optional<TestOutcome> latestTestOutcome() {
        if (!this.getStepEventBus(this.currentFeaturePath()).isBaseStepListenerRegistered()) {
            return Optional.empty();
        }
        List recordedOutcomes = this.getStepEventBus(this.currentFeaturePath()).getBaseStepListener().getTestOutcomes();
        return recordedOutcomes.isEmpty() ? Optional.empty() : Optional.of(recordedOutcomes.get(recordedOutcomes.size() - 1));
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    private String stepTitleFrom(Step currentStep, TestStep testStep) {
        if (currentStep != null && testStep instanceof PickleStepTestStep) {
            return currentStep.getKeyword() + ((PickleStepTestStep)testStep).getPickleStep().getText() + this.embeddedTableDataIn((PickleStepTestStep)testStep);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private String embeddedTableDataIn(PickleStepTestStep currentStep) {
        Argument argument;
        if (!currentStep.getStepArgument().isEmpty() && (argument = (Argument)currentStep.getStepArgument().get(0)) instanceof PickleTable) {
            ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
            for (PickleRow row : ((PickleTable)argument).getRows()) {
                HashMap<String, List<String>> rowMap = new HashMap<String, List<String>>();
                rowMap.put("cells", this.createCellList(row));
                rowList.add(rowMap);
            }
            return this.convertToTextTable(rowList);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private String convertToTextTable(List<Map<String, Object>> rows) {
        StringBuilder textTable = new StringBuilder();
        textTable.append(System.lineSeparator());
        for (Map<String, Object> row : rows) {
            textTable.append("|");
            for (String cell : (List)row.get("cells")) {
                textTable.append(" ");
                textTable.append(cell);
                textTable.append(" |");
            }
            if (row == rows.get(rows.size() - 1)) continue;
            textTable.append(System.lineSeparator());
        }
        return textTable.toString();
    }

    private void generateReports() {
        this.getReportService().generateReportsFor(this.getAllTestOutcomes());
    }

    public List<TestOutcome> getAllTestOutcomes() {
        return this.baseStepListeners.stream().map(BaseStepListener::getTestOutcomes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private String trim(String stringToBeTrimmed) {
        return stringToBeTrimmed == null ? null : stringToBeTrimmed.trim();
    }
}

