/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Predicate;
import net.serenitybdd.cucumber.suiteslicing.CucumberScenarioLoader;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.TagParser;

public class CucumberSuiteSlicer {
    private final List<String> featurePaths;
    private final TestStatistics statistics;

    public CucumberSuiteSlicer(List<String> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios scenarios(int batchNumber, int batchCount, int forkNumber, int forkCount, List<String> tagFilters) {
        return new CucumberScenarioLoader(this.featurePaths, this.statistics).load().filter(this.forSuppliedTags(tagFilters)).slice(batchNumber).of(batchCount).slice(forkNumber).of(forkCount);
    }

    private Predicate<WeightedCucumberScenario> forSuppliedTags(List<String> tagFilters) {
        return cucumberScenario -> TagParser.parseFromTagFilters(tagFilters).evaluate((List)Lists.newArrayList(cucumberScenario.tags));
    }
}

