/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import gherkin.ast.Examples;
import gherkin.ast.TableRow;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.serenitybdd.cucumber.CucumberWithSerenity;

public class LineFilters {
    private Map<URI, Set<Integer>> lineFilters = this.newLineFilters();

    public static LineFilters forCurrentContext() {
        return new LineFilters();
    }

    public Optional<URI> getURIForFeaturePath(String featurePath) {
        return this.lineFilters.keySet().stream().filter(uri -> featurePath.equals(uri.toString())).findFirst();
    }

    private Map<URI, Set<Integer>> newLineFilters() {
        Map lineFiltersFromRuntime = CucumberWithSerenity.currentRuntimeOptions().getLineFilters();
        if (lineFiltersFromRuntime == null) {
            return new HashMap<URI, Set<Integer>>();
        }
        return lineFiltersFromRuntime;
    }

    public Set<Integer> getLineNumbersFor(URI featurePath) {
        return this.lineFilters.get(featurePath);
    }

    public boolean examplesAreNotExcluded(Examples examples, String featurePath) {
        if (this.lineFilters.isEmpty()) {
            return true;
        }
        if (this.lineFiltersContainFeaturePath(featurePath)) {
            return false;
        }
        Optional<URI> uriForFeaturePath = this.getURIForFeaturePath(featurePath);
        return uriForFeaturePath.filter(uri -> examples.getTableBody().stream().anyMatch(row -> this.lineFilters.get(uri).contains(row.getLocation().getLine()))).isPresent();
    }

    public boolean tableRowIsNotExcludedBy(TableRow tableRow, String featurePath) {
        if (this.lineFilters.isEmpty()) {
            return true;
        }
        if (this.lineFiltersContainFeaturePath(featurePath)) {
            return false;
        }
        Optional<URI> uriForFeaturePath = this.getURIForFeaturePath(featurePath);
        return uriForFeaturePath.filter(uri -> this.lineFilters.get(uri).contains(tableRow.getLocation().getLine())).isPresent();
    }

    private boolean lineFiltersContainFeaturePath(String featurePath) {
        return this.getURIForFeaturePath(featurePath) != null;
    }
}

