/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import com.google.common.collect.ImmutableMap;
import gherkin.ast.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.model.TestResult;

class TaggedScenario {
    private static final List<String> SKIPPED_TAGS = Arrays.asList("@skip", "@wip");
    private static final List<String> IGNORED_TAGS = Arrays.asList("@ignore", "@ignored");
    private static Map<String, TestResult> MANUAL_TEST_RESULTS = ImmutableMap.of((Object)"pass", (Object)TestResult.SUCCESS, (Object)"passed", (Object)TestResult.SUCCESS, (Object)"success", (Object)TestResult.SUCCESS, (Object)"failure", (Object)TestResult.FAILURE, (Object)"failed", (Object)TestResult.FAILURE);

    TaggedScenario() {
    }

    static boolean isPending(List<Tag> tags) {
        return TaggedScenario.hasTag("@pending", tags);
    }

    static boolean isManual(List<Tag> tags) {
        return tags.stream().anyMatch(tag -> tag.getName().toLowerCase().startsWith("@manual"));
    }

    static Optional<TestResult> manualResultDefinedIn(List<Tag> tags) {
        if (!TaggedScenario.isManual(tags)) {
            return Optional.empty();
        }
        Optional<Tag> manualTagWithResult = tags.stream().filter(tag -> tag.getName().toLowerCase().startsWith("@manual:")).findFirst();
        if (manualTagWithResult.isPresent()) {
            String result = manualTagWithResult.get().getName().substring(8);
            return Optional.of(MANUAL_TEST_RESULTS.getOrDefault(result.toLowerCase(), TestResult.PENDING));
        }
        return Optional.empty();
    }

    static boolean isSkippedOrWIP(List<Tag> tags) {
        for (Tag tag : tags) {
            if (!SKIPPED_TAGS.contains(tag.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static boolean isIgnored(List<Tag> tags) {
        for (Tag tag : tags) {
            if (!IGNORED_TAGS.contains(tag.getName().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTag(String tagName, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getName().equalsIgnoreCase(tagName)) continue;
            return true;
        }
        return false;
    }
}

