/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.ast.Background;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.CucumberSuiteSlicer;
import net.serenitybdd.cucumber.suiteslicing.TestScenarioResult;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.thucydides.core.util.Inflector;

public class ScenarioLineCountStatistics
implements TestStatistics {
    private final List<String> featurePaths;
    private final List<TestScenarioResult> results;

    private ScenarioLineCountStatistics(List<String> featurePaths) {
        this.featurePaths = featurePaths;
        MultiLoader resourceLoader = new MultiLoader(CucumberSuiteSlicer.class.getClassLoader());
        this.results = new FeatureLoader((ResourceLoader)resourceLoader).load(featurePaths).stream().map(this.featureToScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ScenarioLineCountStatistics fromFeaturePath(String featurePaths) {
        return ScenarioLineCountStatistics.fromFeaturePaths(Arrays.asList(featurePaths));
    }

    public static ScenarioLineCountStatistics fromFeaturePaths(List<String> featurePaths) {
        return new ScenarioLineCountStatistics(featurePaths);
    }

    private Function<CucumberFeature, List<TestScenarioResult>> featureToScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature.getGherkinFeature().getFeature() == null ? Collections.emptyList() : cucumberFeature.getGherkinFeature().getFeature().getChildren().stream().filter(child -> Arrays.asList(ScenarioOutline.class, Scenario.class).contains(child.getClass())).map(this.scenarioToResult((CucumberFeature)cucumberFeature)).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", cucumberFeature.getUri()), e);
            }
        };
    }

    private Function<ScenarioDefinition, TestScenarioResult> scenarioToResult(CucumberFeature feature) {
        return scenarioDefinition -> {
            try {
                return new TestScenarioResult(feature.getGherkinFeature().getFeature().getName(), scenarioDefinition.getName(), this.scenarioStepCountFor(this.backgroundStepCountFor(feature), (ScenarioDefinition)scenarioDefinition));
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not determine step count for scenario '%s'", scenarioDefinition.getDescription()), e);
            }
        };
    }

    private BigDecimal scenarioStepCountFor(int backgroundStepCount, ScenarioDefinition scenarioDefinition) {
        int stepCount;
        if (scenarioDefinition instanceof ScenarioOutline) {
            ScenarioOutline outline = (ScenarioOutline)scenarioDefinition;
            Integer exampleCount = outline.getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
            stepCount = exampleCount * (backgroundStepCount + outline.getSteps().size());
        } else {
            stepCount = backgroundStepCount + scenarioDefinition.getSteps().size();
        }
        return BigDecimal.valueOf(stepCount);
    }

    private int backgroundStepCountFor(CucumberFeature feature) {
        ScenarioDefinition scenarioDefinition = (ScenarioDefinition)feature.getGherkinFeature().getFeature().getChildren().get(0);
        if (scenarioDefinition instanceof Background) {
            return scenarioDefinition.getSteps().size();
        }
        return 0;
    }

    @Override
    public BigDecimal scenarioWeightFor(String feature, String scenario) {
        return this.results.stream().filter(record -> record.feature.equals(feature) && record.scenario.equals(scenario)).map(TestScenarioResult::duration).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("no result found for scenario '%s' in feature '%s'", scenario, feature)));
    }

    @Override
    public List<TestScenarioResult> records() {
        return this.results;
    }

    public String toString() {
        return Inflector.getInstance().kebabCase(this.getClass().getSimpleName(), new char[0]);
    }
}

