/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.formatter.LineFilters;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class FeaturePathFormatter {
    private LineFilters lineFilters = LineFilters.forCurrentContext();

    public String featurePathWithPrefixIfNecessary(String featurePath) {
        return this.lineFilters.getURIForFeaturePath(featurePath).map(matchingURI -> this.featurePathWithPrefix((URI)matchingURI, featurePath)).orElse(featurePath);
    }

    private String featurePathWithPrefix(URI featurePathUri, String featurePath) {
        Set<Integer> allLineNumbersSet = this.lineFilters.getLineNumbersFor(featurePathUri);
        ArrayList<Integer> allLineNumbersList = new ArrayList<Integer>(allLineNumbersSet);
        long featurePathPrefix = ((Integer)allLineNumbersList.get(0)).intValue();
        return featurePath + ":" + featurePathPrefix;
    }

    private URI getURIForFeaturePath(Map<URI, Set<Integer>> map, String featurePath) {
        for (URI currentURI : map.keySet()) {
            if (!featurePath.equals(currentURI.toString())) continue;
            return currentURI;
        }
        return null;
    }
}

