/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.FluentIterable;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Tag;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.cucumber.suiteslicing.CucumberSuiteSlicer;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioLoader.class);
    private final List<URI> featurePaths;
    private final TestStatistics statistics;

    public CucumberScenarioLoader(List<URI> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios load() {
        LOGGER.debug("Feature paths are {}", this.featurePaths);
        MultiLoader resourceLoader = new MultiLoader(CucumberSuiteSlicer.class.getClassLoader());
        List<WeightedCucumberScenario> weightedCucumberScenarios = new FeatureLoader((ResourceLoader)resourceLoader).load(this.featurePaths).stream().map(this.getScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
        return new WeightedCucumberScenarios(weightedCucumberScenarios);
    }

    private Function<CucumberFeature, List<WeightedCucumberScenario>> getScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature.getGherkinFeature().getFeature() == null ? Collections.emptyList() : cucumberFeature.getGherkinFeature().getFeature().getChildren().stream().filter(child -> Arrays.asList(ScenarioOutline.class, Scenario.class).contains(child.getClass())).map(scenarioDefinition -> new WeightedCucumberScenario(PathUtils.getAsFile(cucumberFeature.getUri()).getName(), cucumberFeature.getGherkinFeature().getFeature().getName(), scenarioDefinition.getName(), this.scenarioWeightFor((CucumberFeature)cucumberFeature, (ScenarioDefinition)scenarioDefinition), this.tagsFor((CucumberFeature)cucumberFeature, (ScenarioDefinition)scenarioDefinition), this.scenarioCountFor((ScenarioDefinition)scenarioDefinition))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", cucumberFeature.getUri()), e);
            }
        };
    }

    private int scenarioCountFor(ScenarioDefinition scenarioDefinition) {
        if (scenarioDefinition instanceof ScenarioOutline) {
            return ((ScenarioOutline)scenarioDefinition).getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
        }
        return 1;
    }

    private Set<String> tagsFor(CucumberFeature feature, ScenarioDefinition scenarioDefinition) {
        return FluentIterable.concat((Iterable)feature.getGherkinFeature().getFeature().getTags(), this.scenarioTags(scenarioDefinition)).stream().map(Tag::getName).collect(Collectors.toSet());
    }

    private List<Tag> scenarioTags(ScenarioDefinition scenario) {
        if (Scenario.class.isAssignableFrom(scenario.getClass())) {
            return ((Scenario)scenario).getTags();
        }
        return ((ScenarioOutline)scenario).getTags();
    }

    private BigDecimal scenarioWeightFor(CucumberFeature feature, ScenarioDefinition scenarioDefinition) {
        return this.statistics.scenarioWeightFor(feature.getGherkinFeature().getFeature().getName(), scenarioDefinition.getName());
    }
}

