/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.FluentIterable;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.internal.gherkin.AstBuilder;
import io.cucumber.core.internal.gherkin.Parser;
import io.cucumber.core.internal.gherkin.TokenMatcher;
import io.cucumber.core.internal.gherkin.ast.GherkinDocument;
import io.cucumber.core.internal.gherkin.ast.Scenario;
import io.cucumber.core.internal.gherkin.ast.ScenarioDefinition;
import io.cucumber.core.internal.gherkin.ast.ScenarioOutline;
import io.cucumber.core.internal.gherkin.ast.Tag;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioLoader.class);
    private final Supplier<ClassLoader> classLoader = CucumberScenarioLoader.class::getClassLoader;
    private final FeatureParser parser = new FeatureParser(UUID::randomUUID);
    private final List<URI> featurePaths;
    private final TestStatistics statistics;
    private Map<io.cucumber.core.internal.gherkin.ast.Feature, URI> mapsForFeatures = new HashMap<io.cucumber.core.internal.gherkin.ast.Feature, URI>();

    public CucumberScenarioLoader(List<URI> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios load() {
        LOGGER.debug("Feature paths are {}", this.featurePaths);
        Options featureOptions = () -> this.featurePaths;
        Parser gherkinParser = new Parser((Parser.Builder)new AstBuilder());
        TokenMatcher matcher = new TokenMatcher();
        FeaturePathFeatureSupplier supplier = new FeaturePathFeatureSupplier(this.classLoader, featureOptions, this.parser);
        IntStream.range(0, supplier.get().size()).forEach(i -> this.mapsForFeatures.put(((GherkinDocument)gherkinParser.parse(((Feature)supplier.get().get(i)).getSource(), (Parser.ITokenMatcher)matcher)).getFeature(), ((Feature)supplier.get().get(i)).getUri()));
        List<WeightedCucumberScenario> weightedCucumberScenarios = this.mapsForFeatures.keySet().stream().map(this.getScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
        return new WeightedCucumberScenarios(weightedCucumberScenarios);
    }

    private Function<io.cucumber.core.internal.gherkin.ast.Feature, List<WeightedCucumberScenario>> getScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildren().stream().filter(child -> Arrays.asList(ScenarioOutline.class, Scenario.class).contains(child.getClass())).map(scenarioDefinition -> new WeightedCucumberScenario(PathUtils.getAsFile(this.mapsForFeatures.get(cucumberFeature)).getName(), cucumberFeature.getName(), scenarioDefinition.getName(), this.scenarioWeightFor((io.cucumber.core.internal.gherkin.ast.Feature)cucumberFeature, (ScenarioDefinition)scenarioDefinition), this.tagsFor((io.cucumber.core.internal.gherkin.ast.Feature)cucumberFeature, (ScenarioDefinition)scenarioDefinition), this.scenarioCountFor((ScenarioDefinition)scenarioDefinition))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", this.mapsForFeatures.get(cucumberFeature)), e);
            }
        };
    }

    private int scenarioCountFor(ScenarioDefinition scenarioDefinition) {
        if (scenarioDefinition instanceof ScenarioOutline) {
            return ((ScenarioOutline)scenarioDefinition).getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
        }
        return 1;
    }

    private Set<String> tagsFor(io.cucumber.core.internal.gherkin.ast.Feature feature, ScenarioDefinition scenarioDefinition) {
        return FluentIterable.concat((Iterable)feature.getTags(), this.scenarioTags(scenarioDefinition)).stream().map(Tag::getName).collect(Collectors.toSet());
    }

    private List<Tag> scenarioTags(ScenarioDefinition scenario) {
        if (Scenario.class.isAssignableFrom(scenario.getClass())) {
            return ((Scenario)scenario).getTags();
        }
        return Stream.of(((ScenarioOutline)scenario).getTags(), ((ScenarioOutline)scenario).getExamples().stream().flatMap(e -> e.getTags().stream()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private BigDecimal scenarioWeightFor(io.cucumber.core.internal.gherkin.ast.Feature feature, ScenarioDefinition scenarioDefinition) {
        return this.statistics.scenarioWeightFor(feature.getName(), scenarioDefinition.getName());
    }
}

