/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityTags {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityTags.class);
    private final String TEST_BATCH = "test batch";
    private final String TEST_FORK = "test fork";
    private final EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);

    private SerenityTags() {
    }

    public static SerenityTags create() {
        return new SerenityTags();
    }

    public Optional<TestTag> batches() {
        Integer batchNumber = this.environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_BATCH_NUMBER, Integer.valueOf(0));
        return SerenityTags.numberedTagFor(batchNumber, "batch", "test batch");
    }

    public Optional<TestTag> forks() {
        Integer forkNumber = this.environmentVariables.getPropertyAsInteger((Enum)ThucydidesSystemProperty.SERENITY_FORK_NUMBER, Integer.valueOf(0));
        return SerenityTags.numberedTagFor(forkNumber, "fork", "test fork");
    }

    private static Optional<TestTag> numberedTagFor(Integer value, String shardType, String tagType) {
        return shardType.isEmpty() || value == 0 ? Optional.empty() : Optional.of(TestTag.withName((String)String.format("%s %s", shardType, value)).andType(tagType));
    }

    public void tagScenarioWithBatchingInfo() {
        this.batches().ifPresent(this.addTag());
        this.forks().ifPresent(this.addTag());
    }

    private Consumer<TestTag> addTag() {
        return this::addTagWith;
    }

    public void addTagWith(TestTag tag) {
        LOGGER.info("adding tag to {} scenario", (Object)tag);
        StepEventBus.getEventBus().addTagsToCurrentStory((List)Lists.newArrayList((Object[])new TestTag[]{tag}));
    }

    public void addTagWith(String tagName, String tagType) {
        this.addTagWith(TestTag.withName((String)tagName).andType(tagType));
    }
}

