/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import com.google.common.collect.Lists;
import io.cucumber.core.plugin.FeatureFileLoader;
import io.cucumber.core.plugin.FeaturePathFormatter;
import io.cucumber.core.plugin.LineFilters;
import io.cucumber.core.plugin.ManualScenarioChecker;
import io.cucumber.core.plugin.ScenarioContext;
import io.cucumber.core.plugin.TaggedScenario;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.core.plugin.UpdateManualScenario;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.EventHandler;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import io.cucumber.tagexpressions.Expression;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SerenityListeners;
import net.serenitybdd.core.SerenityReports;
import net.serenitybdd.cucumber.CucumberWithSerenity;
import net.serenitybdd.cucumber.formatting.ScenarioOutlineDescription;
import net.serenitybdd.cucumber.util.PathUtils;
import net.serenitybdd.cucumber.util.StepDefinitionAnnotationReader;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.screenshots.StepDefinitionAnnotations;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.TestSourceType;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.internal.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReporter
implements Plugin,
ConcurrentEventListener {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private static final String SCENARIO_OUTLINE_NOT_KNOWN_YET = "";
    private Configuration systemConfiguration;
    private final List<BaseStepListener> baseStepListeners;
    private static final String FEATURES_ROOT_PATH = "features";
    private FeatureFileLoader featureLoader = new FeatureFileLoader();
    private LineFilters lineFilters;
    private List<Messages.GherkinDocument.Feature.Tag> scenarioTags;
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityReporter.class);
    private ManualScenarioChecker manualScenarioDateChecker;
    private ThreadLocal<ScenarioContext> localContext = ThreadLocal.withInitial(ScenarioContext::new);
    private FeaturePathFormatter featurePathFormatter = new FeaturePathFormatter();
    private EventHandler<TestSourceRead> testSourceReadHandler = this::handleTestSourceRead;
    private EventHandler<TestCaseStarted> caseStartedHandler = this::handleTestCaseStarted;
    private EventHandler<TestCaseFinished> caseFinishedHandler = this::handleTestCaseFinished;
    private EventHandler<TestStepStarted> stepStartedHandler = this::handleTestStepStarted;
    private EventHandler<TestStepFinished> stepFinishedHandler = this::handleTestStepFinished;
    private EventHandler<TestRunStarted> runStartedHandler = this::handleTestRunStarted;
    private EventHandler<TestRunFinished> runFinishedHandler = this::handleTestRunFinished;
    private EventHandler<WriteEvent> writeEventHandler = this::handleWrite;

    private ScenarioContext getContext() {
        return this.localContext.get();
    }

    public SerenityReporter() {
        this.systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        this.manualScenarioDateChecker = new ManualScenarioChecker(this.systemConfiguration.getEnvironmentVariables());
        this.baseStepListeners = Collections.synchronizedList(new ArrayList());
        this.lineFilters = LineFilters.forCurrentContext();
    }

    public SerenityReporter(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.manualScenarioDateChecker = new ManualScenarioChecker(systemConfiguration.getEnvironmentVariables());
        this.baseStepListeners = Collections.synchronizedList(new ArrayList());
        this.lineFilters = LineFilters.forCurrentContext();
    }

    private StepEventBus getStepEventBus(URI featurePath) {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(featurePath);
        return StepEventBus.eventBusFor((Object)prefixedPath);
    }

    private void setStepEventBus(URI featurePath) {
        URI prefixedPath = this.featurePathFormatter.featurePathWithPrefixIfNecessary(featurePath);
        StepEventBus.setCurrentBusToEventBusFor((Object)prefixedPath);
    }

    private void initialiseListenersFor(URI featurePath) {
        if (this.getStepEventBus(featurePath).isBaseStepListenerRegistered()) {
            return;
        }
        SerenityListeners listeners = new SerenityListeners(this.getStepEventBus(featurePath), this.systemConfiguration);
        this.baseStepListeners.add(listeners.getBaseStepListener());
    }

    private void handleTestRunStarted(TestRunStarted event) {
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestRunStarted.class, this.runStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.featureLoader.addTestSourceReadEvent(event);
        URI featurePath = event.getUri();
        this.featureFrom(featurePath).ifPresent(feature -> {
            this.getContext().setFeatureTags(feature.getTagsList());
            this.resetEventBusFor(featurePath);
            this.initialiseListenersFor(featurePath);
            this.configureDriver((Messages.GherkinDocument.Feature)feature, featurePath);
            Story userStory = this.userStoryFrom((Messages.GherkinDocument.Feature)feature, this.relativeUriFrom(event.getUri()));
            this.getStepEventBus(event.getUri()).testSuiteStarted(userStory);
        });
    }

    private void resetEventBusFor(URI featurePath) {
        StepEventBus.clearEventBusFor((Object)featurePath);
    }

    private String relativeUriFrom(URI fullPathUri) {
        String featuresRoot;
        String pathURIAsString;
        boolean useDecodedURI = this.systemConfiguration.getEnvironmentVariables().getPropertyAsBoolean("use.decoded.url", false);
        if (useDecodedURI) {
            try {
                pathURIAsString = URLDecoder.decode(fullPathUri.toString(), StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                pathURIAsString = fullPathUri.toString();
            }
        } else {
            pathURIAsString = fullPathUri.toString();
        }
        if (pathURIAsString.contains(featuresRoot = File.separatorChar + FEATURES_ROOT_PATH + File.separatorChar)) {
            return pathURIAsString.substring(pathURIAsString.lastIndexOf(featuresRoot) + FEATURES_ROOT_PATH.length() + 2);
        }
        return pathURIAsString;
    }

    private Optional<Messages.GherkinDocument.Feature> featureFrom(URI featureFileUri) {
        LOGGER.info("Running feature from " + featureFileUri.toString());
        String featuresRoot = File.separatorChar + FEATURES_ROOT_PATH + File.separatorChar;
        if (!featureFileUri.toString().contains(featuresRoot)) {
            LOGGER.warn("Feature from " + featureFileUri + " is not under the 'features' directory. Requirements report will not be correctly generated!");
        }
        String defaultFeatureId = PathUtils.getAsFile(featureFileUri).getName().replace(".feature", SCENARIO_OUTLINE_NOT_KNOWN_YET);
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        this.parseGherkinIn(featureFileUri);
        if (StringUtils.isEmpty((CharSequence)this.featureLoader.getFeatureName(featureFileUri))) {
            return Optional.empty();
        }
        Messages.GherkinDocument.Feature feature = this.featureLoader.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureLoader.featureWithDefaultName(feature, defaultFeatureName);
        }
        return Optional.of(feature);
    }

    private void parseGherkinIn(URI featureFileUri) {
        try {
            this.featureLoader.getFeature(featureFileUri);
        }
        catch (Throwable ignoreParsingErrors) {
            LOGGER.warn("Could not parse the Gherkin in feature file " + featureFileUri + ": file ignored");
        }
    }

    private Story userStoryFrom(Messages.GherkinDocument.Feature feature, String featureFileUriString) {
        Story userStory = Story.withIdAndPath((String)TestSourcesModel.convertToId((String)feature.getName()), (String)feature.getName(), (String)featureFileUriString).asFeature();
        if (!StringUtils.isEmpty((CharSequence)feature.getDescription())) {
            userStory = userStory.withNarrative(feature.getDescription());
        }
        return userStory;
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        URI featurePath = event.getTestCase().getUri();
        this.getContext().currentFeaturePathIs(featurePath);
        this.setStepEventBus(featurePath);
        String scenarioName = event.getTestCase().getName();
        TestSourcesModel.AstNode astNode = this.featureLoader.getAstNode(this.getContext().currentFeaturePath(), event.getTestCase().getLine());
        Optional<Messages.GherkinDocument.Feature> currentFeature = this.featureFrom(featurePath);
        if (astNode != null && currentFeature.isPresent()) {
            boolean newScenario;
            this.getContext().setCurrentScenarioDefinitionFrom(astNode);
            String scenarioId = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)this.getContext().currentScenarioDefinition.getName()));
            boolean bl = newScenario = !scenarioId.equals(this.getContext().getCurrentScenario());
            if (newScenario) {
                this.configureDriver(currentFeature.get(), this.getContext().currentFeaturePath());
                if (this.getContext().isAScenarioOutline()) {
                    this.getContext().startNewExample();
                    this.handleExamples(currentFeature.get(), this.getContext().currentScenarioOutline().getTagsList(), this.getContext().currentScenarioOutline().getName(), this.getContext().currentScenarioOutline().getExamplesList());
                }
                this.startOfScenarioLifeCycle(currentFeature.get(), scenarioName, this.getContext().currentScenarioDefinition, event.getTestCase().getLine());
                this.getContext().currentScenario = this.scenarioIdFrom(currentFeature.get().getName(), TestSourcesModel.convertToId((String)this.getContext().currentScenarioDefinition.getName()));
            } else if (this.getContext().isAScenarioOutline()) {
                this.startExample(event.getTestCase().getLine());
            }
            Messages.GherkinDocument.Feature.Background background = TestSourcesModel.getBackgroundForTestCase((TestSourcesModel.AstNode)astNode);
            if (background != null) {
                this.handleBackground(background);
            }
        }
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (this.getContext().examplesAreRunning()) {
            this.handleResult(event.getResult());
            this.finishExample();
        }
        if (Status.FAILED.equals((Object)event.getResult()) && this.noAnnotatedResultIdDefinedFor(event)) {
            this.getStepEventBus(event.getTestCase().getUri()).testFailed(event.getResult().getError());
        } else {
            this.getStepEventBus(event.getTestCase().getUri()).testFinished(this.getContext().examplesAreRunning());
        }
        this.getContext().clearStepQueue();
    }

    private boolean noAnnotatedResultIdDefinedFor(TestCaseFinished event) {
        BaseStepListener baseStepListener = this.getStepEventBus(event.getTestCase().getUri()).getBaseStepListener();
        return baseStepListener.getTestOutcomes().isEmpty() || this.latestOf(baseStepListener.getTestOutcomes()).getAnnotatedResult() == null;
    }

    private TestOutcome latestOf(List<TestOutcome> testOutcomes) {
        return testOutcomes.get(testOutcomes.size() - 1);
    }

    private void handleTestStepStarted(TestStepStarted event) {
        StepDefinitionAnnotations.setScreenshotPreferencesTo((TakeScreenshots)StepDefinitionAnnotationReader.withScreenshotLevel(this.systemConfiguration.getScreenshotLevel().orElse(TakeScreenshots.UNDEFINED)).forStepDefinition(event.getTestStep().getCodeLocation()).getScreenshotPreferences());
        if (!(event.getTestStep() instanceof HookTestStep) && event.getTestStep() instanceof PickleStepTestStep) {
            PickleStepTestStep pickleTestStep = (PickleStepTestStep)event.getTestStep();
            TestSourcesModel.AstNode astNode = this.featureLoader.getAstNode(this.getContext().currentFeaturePath(), pickleTestStep.getStepLine());
            if (astNode != null) {
                Messages.GherkinDocument.Feature.Step step = (Messages.GherkinDocument.Feature.Step)astNode.node;
                if (!this.getContext().isAddingScenarioOutlineSteps()) {
                    this.getContext().queueStep(step);
                    this.getContext().queueTestStep(event.getTestStep());
                }
                if (this.getContext().isAScenarioOutline()) {
                    int lineNumber = event.getTestCase().getLine();
                    this.getContext().stepEventBus().updateExampleLineNumber(lineNumber);
                }
                Messages.GherkinDocument.Feature.Step currentStep = this.getContext().getCurrentStep();
                String stepTitle = this.stepTitleFrom(currentStep, (io.cucumber.plugin.event.TestStep)pickleTestStep);
                this.getContext().stepEventBus().stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
                this.getContext().stepEventBus().updateCurrentStepTitle(this.normalized(stepTitle));
            }
        }
    }

    private void handleWrite(WriteEvent event) {
        this.getContext().stepEventBus().stepStarted(ExecutedStepDescription.withTitle((String)event.getText()));
        this.getContext().stepEventBus().stepFinished();
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (!(event.getTestStep() instanceof HookTestStep)) {
            this.handleResult(event.getResult());
            StepDefinitionAnnotations.clear();
        }
    }

    private void handleTestRunFinished(TestRunFinished event) {
        this.generateReports();
        this.assureTestSuiteFinished();
    }

    private ReportService getReportService() {
        return SerenityReports.getReportService((Configuration)this.systemConfiguration);
    }

    private void configureDriver(Messages.GherkinDocument.Feature feature, URI featurePath) {
        this.getStepEventBus(featurePath).setUniqueSession(this.systemConfiguration.shouldUseAUniqueBrowser());
        List<String> tags = this.getTagNamesFrom(feature.getTagsList());
        String requestedDriver = this.getDriverFrom(tags);
        String requestedDriverOptions = this.getDriverOptionsFrom(tags);
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)requestedDriver);
            ThucydidesWebDriverSupport.useDriverOptions((String)requestedDriverOptions);
        }
    }

    private List<String> getTagNamesFrom(List<Messages.GherkinDocument.Feature.Tag> tags) {
        ArrayList<String> tagNames = new ArrayList<String>();
        for (Messages.GherkinDocument.Feature.Tag tag : tags) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    private String getDriverFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver:")) continue;
            requestedDriver = tag.substring(8);
        }
        return requestedDriver;
    }

    private String getDriverOptionsFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver-options:")) continue;
            requestedDriver = tag.substring(16);
        }
        return requestedDriver;
    }

    private void handleExamples(Messages.GherkinDocument.Feature currentFeature, List<Messages.GherkinDocument.Feature.Tag> scenarioOutlineTags, String id, List<Messages.GherkinDocument.Feature.Scenario.Examples> examplesList) {
        String featureName = currentFeature.getName();
        List currentFeatureTags = currentFeature.getTagsList();
        this.getContext().doneAddingScenarioOutlineSteps();
        this.initializeExamples();
        for (Messages.GherkinDocument.Feature.Scenario.Examples examples : examplesList) {
            if (!this.examplesAreNotExcludedByTags(examples, scenarioOutlineTags, currentFeatureTags) || !this.lineFilters.examplesAreNotExcluded(examples, this.getContext().currentFeaturePath())) continue;
            List<Messages.GherkinDocument.Feature.TableRow> examplesTableRows = examples.getTableBodyList().stream().filter(tableRow -> this.lineFilters.tableRowIsNotExcludedBy((Messages.GherkinDocument.Feature.TableRow)tableRow, this.getContext().currentFeaturePath())).collect(Collectors.toList());
            List<String> headers = this.getHeadersFrom(examples.getTableHeader());
            List<Map<String, String>> rows = this.getValuesFrom(examplesTableRows, headers);
            HashMap<Integer, Integer> lineNumbersOfEachRow = new HashMap<Integer, Integer>();
            for (int i = 0; i < examplesTableRows.size(); ++i) {
                Messages.GherkinDocument.Feature.TableRow tableRow2 = examplesTableRows.get(i);
                lineNumbersOfEachRow.put(i, tableRow2.getLocation().getLine());
                this.addRow(this.exampleRows(), headers, tableRow2);
                if (examples.getTagsList() == null) continue;
                this.exampleTags().put(examplesTableRows.get(i).getLocation().getLine(), examples.getTagsList());
            }
            String scenarioId = this.scenarioIdFrom(featureName, id);
            boolean newScenario = !this.getContext().hasScenarioId(scenarioId);
            String exampleTableName = this.trim(examples.getName());
            String exampleTableDescription = this.trim(examples.getDescription());
            if (newScenario) {
                this.getContext().setTable(this.dataTableFrom(SCENARIO_OUTLINE_NOT_KNOWN_YET, headers, rows, exampleTableName, exampleTableDescription, lineNumbersOfEachRow));
            } else {
                this.getContext().addTableRows(headers, rows, exampleTableName, exampleTableDescription, lineNumbersOfEachRow);
            }
            this.getContext().addTableTags(this.tagsIn(examples));
            this.getContext().currentScenarioId = scenarioId;
        }
    }

    @NotNull
    private List<TestTag> tagsIn(Messages.GherkinDocument.Feature.Scenario.Examples examples) {
        return examples.getTagsList().stream().map(tag -> TestTag.withValue((String)tag.getName().substring(1))).collect(Collectors.toList());
    }

    private boolean examplesAreNotExcludedByTags(Messages.GherkinDocument.Feature.Scenario.Examples examples, List<Messages.GherkinDocument.Feature.Tag> scenarioOutlineTags, List<Messages.GherkinDocument.Feature.Tag> currentFeatureTags) {
        if (this.testRunHasFilterTags()) {
            return this.examplesMatchFilter(examples, scenarioOutlineTags, currentFeatureTags);
        }
        return true;
    }

    private boolean examplesMatchFilter(Messages.GherkinDocument.Feature.Scenario.Examples examples, List<Messages.GherkinDocument.Feature.Tag> scenarioOutlineTags, List<Messages.GherkinDocument.Feature.Tag> currentFeatureTags) {
        List<Messages.GherkinDocument.Feature.Tag> allExampleTags = this.getExampleAllTags(examples, scenarioOutlineTags, currentFeatureTags);
        List allTagsForAnExampleScenario = allExampleTags.stream().map(Messages.GherkinDocument.Feature.Tag::getName).collect(Collectors.toList());
        Expression tagValuesFromCucumberOptions = this.getCucumberRuntimeTags().get(0);
        return tagValuesFromCucumberOptions.evaluate(allTagsForAnExampleScenario);
    }

    private boolean testRunHasFilterTags() {
        List<Expression> tagFilters = this.getCucumberRuntimeTags();
        return tagFilters != null && tagFilters.size() > 0;
    }

    private List<Expression> getCucumberRuntimeTags() {
        if (CucumberWithSerenity.currentRuntimeOptions() == null) {
            return new ArrayList<Expression>();
        }
        return CucumberWithSerenity.currentRuntimeOptions().getTagExpressions();
    }

    private List<Messages.GherkinDocument.Feature.Tag> getExampleAllTags(Messages.GherkinDocument.Feature.Scenario.Examples examples, List<Messages.GherkinDocument.Feature.Tag> scenarioOutlineTags, List<Messages.GherkinDocument.Feature.Tag> currentFeatureTags) {
        List exampleTags = examples.getTagsList();
        ArrayList<Messages.GherkinDocument.Feature.Tag> allTags = new ArrayList<Messages.GherkinDocument.Feature.Tag>();
        if (exampleTags != null) {
            allTags.addAll(exampleTags);
        }
        if (scenarioOutlineTags != null) {
            allTags.addAll(scenarioOutlineTags);
        }
        if (currentFeatureTags != null) {
            allTags.addAll(currentFeatureTags);
        }
        return allTags;
    }

    private List<String> getHeadersFrom(Messages.GherkinDocument.Feature.TableRow headerRow) {
        return headerRow.getCellsList().stream().map(Messages.GherkinDocument.Feature.TableRow.TableCell::getValue).collect(Collectors.toList());
    }

    private List<Map<String, String>> getValuesFrom(List<Messages.GherkinDocument.Feature.TableRow> examplesTableRows, List<String> headers) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        for (int row = 0; row < examplesTableRows.size(); ++row) {
            HashMap<String, String> rowValues = new HashMap<String, String>();
            int column = 0;
            List cells = examplesTableRows.get(row).getCellsList().stream().map(Messages.GherkinDocument.Feature.TableRow.TableCell::getValue).collect(Collectors.toList());
            for (String cellValue : cells) {
                String columnName = headers.get(column++);
                rowValues.put(columnName, cellValue);
            }
            rows.add(rowValues);
        }
        return rows;
    }

    private void addRow(Map<Integer, Map<String, String>> exampleRows, List<String> headers, Messages.GherkinDocument.Feature.TableRow currentTableRow) {
        LinkedHashMap row = new LinkedHashMap();
        for (int j = 0; j < headers.size(); ++j) {
            List cells = currentTableRow.getCellsList().stream().map(Messages.GherkinDocument.Feature.TableRow.TableCell::getValue).collect(Collectors.toList());
            row.put(headers.get(j), cells.get(j));
        }
        this.exampleRows().put(currentTableRow.getLocation().getLine(), row);
    }

    private String scenarioIdFrom(String featureId, String scenarioIdOrExampleId) {
        return featureId != null && scenarioIdOrExampleId != null ? String.format("%s;%s", featureId, scenarioIdOrExampleId) : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private void initializeExamples() {
        this.getContext().setExamplesRunning(true);
    }

    private Map<Integer, Map<String, String>> exampleRows() {
        if (this.getContext().exampleRows == null) {
            this.getContext().exampleRows = Collections.synchronizedMap(new HashMap());
        }
        return this.getContext().exampleRows;
    }

    private Map<Integer, List<Messages.GherkinDocument.Feature.Tag>> exampleTags() {
        if (this.getContext().exampleTags == null) {
            this.getContext().exampleTags = Collections.synchronizedMap(new HashMap());
        }
        return this.getContext().exampleTags;
    }

    private DataTable dataTableFrom(String scenarioOutline, List<String> headers, List<Map<String, String>> rows, String name, String description, Map<Integer, Integer> lineNumbersOfEachRow) {
        return DataTable.withHeaders(headers).andScenarioOutline(scenarioOutline).andMappedRows(rows, lineNumbersOfEachRow).andTitle(name).andDescription(description).build();
    }

    private DataTable addTableRowsTo(DataTable table, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        table.startNewDataSet(name, description);
        for (Map<String, String> row : rows) {
            table.appendRow(this.rowValuesFrom(headers, row));
        }
        return table;
    }

    private List<String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        return headers.stream().map(header -> (String)row.get(header)).collect(Collectors.toList());
    }

    private void startOfScenarioLifeCycle(Messages.GherkinDocument.Feature feature, String scenarioName, Messages.GherkinDocument.Feature.Scenario scenario, Integer currentLine) {
        boolean newScenario = !this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName())).equals(this.getContext().currentScenario);
        this.getContext().currentScenario = this.scenarioIdFrom(TestSourcesModel.convertToId((String)feature.getName()), TestSourcesModel.convertToId((String)scenario.getName()));
        if (this.getContext().examplesAreRunning()) {
            if (newScenario) {
                this.startScenario(feature, scenario, scenario.getName());
                this.getContext().stepEventBus().useExamplesFrom(this.getContext().getTable());
                this.getContext().stepEventBus().useScenarioOutline(ScenarioOutlineDescription.from(scenario).getDescription());
            } else {
                this.getContext().stepEventBus().addNewExamplesFrom(this.getContext().getTable());
            }
            this.startExample(currentLine);
        } else {
            this.startScenario(feature, scenario, scenarioName);
        }
    }

    private void startScenario(Messages.GherkinDocument.Feature currentFeature, Messages.GherkinDocument.Feature.Scenario scenarioDefinition, String scenarioName) {
        this.getContext().stepEventBus().setTestSource(TestSourceType.TEST_SOURCE_CUCUMBER.getValue());
        this.getContext().stepEventBus().testStarted(scenarioName, this.scenarioIdFrom(TestSourcesModel.convertToId((String)currentFeature.getName()), TestSourcesModel.convertToId((String)scenarioName)));
        this.getContext().stepEventBus().addDescriptionToCurrentTest(scenarioDefinition.getDescription());
        this.getContext().stepEventBus().addTagsToCurrentTest(this.convertCucumberTags(currentFeature.getTagsList()));
        if (this.isScenario(scenarioDefinition)) {
            this.getContext().stepEventBus().addTagsToCurrentTest(this.convertCucumberTags(scenarioDefinition.getTagsList()));
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            this.getContext().stepEventBus().addTagsToCurrentTest(this.convertCucumberTags(scenarioDefinition.getTagsList()));
        }
        this.registerFeatureJiraIssues(currentFeature.getTagsList());
        List<Messages.GherkinDocument.Feature.Tag> tags = this.getTagsOfScenarioDefinition(scenarioDefinition);
        this.registerScenarioJiraIssues(tags);
        this.scenarioTags = this.tagsForScenario(scenarioDefinition);
        this.updateResultFromTags(this.scenarioTags);
    }

    private List<Messages.GherkinDocument.Feature.Tag> tagsForScenario(Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        ArrayList<Messages.GherkinDocument.Feature.Tag> scenarioTags = new ArrayList<Messages.GherkinDocument.Feature.Tag>(this.getContext().featureTags);
        scenarioTags.addAll(this.getTagsOfScenarioDefinition(scenarioDefinition));
        return scenarioTags;
    }

    private boolean isScenario(Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        return scenarioDefinition.getExamplesCount() == 0;
    }

    private boolean isScenarioOutline(Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        return scenarioDefinition.getExamplesCount() > 0;
    }

    private List<Messages.GherkinDocument.Feature.Tag> getTagsOfScenarioDefinition(Messages.GherkinDocument.Feature.Scenario scenarioDefinition) {
        List tags = new ArrayList();
        if (this.isScenario(scenarioDefinition)) {
            tags = scenarioDefinition.getTagsList();
        } else if (this.isScenarioOutline(scenarioDefinition)) {
            tags = scenarioDefinition.getTagsList();
        }
        return tags;
    }

    private void registerFeatureJiraIssues(List<Messages.GherkinDocument.Feature.Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            this.getContext().stepEventBus().addIssuesToCurrentStory(issues);
        }
    }

    private void registerScenarioJiraIssues(List<Messages.GherkinDocument.Feature.Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            this.getContext().stepEventBus().addIssuesToCurrentTest(issues);
        }
    }

    private List<TestTag> convertCucumberTags(List<Messages.GherkinDocument.Feature.Tag> cucumberTags) {
        cucumberTags = this.completeManualTagsIn(cucumberTags);
        return cucumberTags.stream().map(tag -> TestTag.withValue((String)tag.getName().substring(1))).collect(Collectors.toList());
    }

    private List<Messages.GherkinDocument.Feature.Tag> completeManualTagsIn(List<Messages.GherkinDocument.Feature.Tag> cucumberTags) {
        if (this.unqualifiedManualTag(cucumberTags).isPresent() && this.doesNotContainResultTag(cucumberTags)) {
            ArrayList updatedTags = Lists.newArrayList(cucumberTags);
            Messages.GherkinDocument.Feature.Tag newManualTag = Messages.GherkinDocument.Feature.Tag.newBuilder().setLocation(this.unqualifiedManualTag(cucumberTags).get().getLocation()).setName("@manual:pending").build();
            updatedTags.add(newManualTag);
            return updatedTags;
        }
        return cucumberTags;
    }

    private boolean doesNotContainResultTag(List<Messages.GherkinDocument.Feature.Tag> tags) {
        return !tags.stream().noneMatch(tag -> tag.getName().startsWith("@manual:"));
    }

    private Optional<Messages.GherkinDocument.Feature.Tag> unqualifiedManualTag(List<Messages.GherkinDocument.Feature.Tag> tags) {
        return tags.stream().filter(tag -> tag.getName().equalsIgnoreCase("@manual")).findFirst();
    }

    private List<String> extractJiraIssueTags(List<Messages.GherkinDocument.Feature.Tag> cucumberTags) {
        ArrayList<String> issues = new ArrayList<String>();
        for (Messages.GherkinDocument.Feature.Tag tag : cucumberTags) {
            if (tag.getName().startsWith("@issue:")) {
                String tagIssueValue = tag.getName().substring("@issue:".length());
                issues.add(tagIssueValue);
            }
            if (!tag.getName().startsWith("@issues:")) continue;
            String tagIssuesValues = tag.getName().substring("@issues:".length());
            issues.addAll(Arrays.asList(tagIssuesValues.split(",")));
        }
        return issues;
    }

    private void startExample(Integer lineNumber) {
        Map<String, String> data = this.exampleRows().get(lineNumber);
        this.getContext().stepEventBus().clearStepFailures();
        this.getContext().stepEventBus().exampleStarted(data);
        if (this.exampleTags().containsKey(lineNumber)) {
            List<Messages.GherkinDocument.Feature.Tag> currentExampleTags = this.exampleTags().get(lineNumber);
            this.getContext().stepEventBus().addTagsToCurrentTest(this.convertCucumberTags(currentExampleTags));
        }
    }

    private void finishExample() {
        this.getContext().stepEventBus().exampleFinished();
        --this.getContext().exampleCount;
        if (this.getContext().exampleCount == 0) {
            this.getContext().setExamplesRunning(false);
            this.setTableScenarioOutline();
        } else {
            this.getContext().setExamplesRunning(true);
        }
    }

    private void setTableScenarioOutline() {
        List steps = this.getContext().currentScenarioDefinition.getStepsList();
        StringBuffer scenarioOutlineBuffer = new StringBuffer();
        for (Messages.GherkinDocument.Feature.Step step : steps) {
            scenarioOutlineBuffer.append(step.getKeyword()).append(step.getText()).append("\n\r");
        }
        String scenarioOutline = scenarioOutlineBuffer.toString();
        if (this.getContext().getTable() != null) {
            this.getContext().getTable().setScenarioOutline(scenarioOutline);
        }
    }

    private void handleBackground(Messages.GherkinDocument.Feature.Background background) {
        String backgroundDescription;
        this.getContext().waitingToProcessBackgroundSteps = true;
        String backgroundName = background.getName();
        if (backgroundName != null) {
            this.getContext().stepEventBus().setBackgroundTitle(backgroundName);
        }
        if ((backgroundDescription = background.getDescription()) == null) {
            backgroundDescription = SCENARIO_OUTLINE_NOT_KNOWN_YET;
        }
        this.getContext().stepEventBus().setBackgroundDescription(backgroundDescription);
    }

    private void assureTestSuiteFinished() {
        this.getContext().clearStepQueue();
        this.getContext().clearTestStepQueue();
        Optional.ofNullable(this.getContext().currentFeaturePath()).ifPresent(featurePath -> {
            this.getStepEventBus((URI)featurePath).testSuiteFinished();
            this.getStepEventBus((URI)featurePath).dropAllListeners();
            this.getStepEventBus((URI)featurePath).clear();
            StepEventBus.clearEventBusFor((Object)featurePath);
        });
        Serenity.done();
        this.getContext().clearTable();
        this.getContext().currentScenarioId = null;
    }

    private void handleResult(Result result) {
        Messages.GherkinDocument.Feature.Step currentStep = this.getContext().nextStep();
        io.cucumber.plugin.event.TestStep currentTestStep = this.getContext().nextTestStep();
        this.recordStepResult(result, currentStep, currentTestStep);
        if (this.getContext().noStepsAreQueued()) {
            this.recordFinalResult();
        }
    }

    private void recordStepResult(Result result, Messages.GherkinDocument.Feature.Step currentStep, io.cucumber.plugin.event.TestStep currentTestStep) {
        if (this.getContext().stepEventBus().currentTestIsSuspended()) {
            this.getContext().stepEventBus().stepIgnored();
        } else if (Status.PASSED.equals((Object)result.getStatus())) {
            this.getContext().stepEventBus().stepFinished();
        } else if (Status.FAILED.equals((Object)result.getStatus())) {
            this.failed(this.stepTitleFrom(currentStep, currentTestStep), result.getError());
        } else if (Status.SKIPPED.equals((Object)result.getStatus())) {
            this.getContext().stepEventBus().stepIgnored();
        } else if (Status.PENDING.equals((Object)result.getStatus())) {
            this.getContext().stepEventBus().stepPending();
        } else if (Status.UNDEFINED.equals((Object)result.getStatus())) {
            this.getContext().stepEventBus().stepPending();
        }
    }

    private void recordFinalResult() {
        if (this.getContext().waitingToProcessBackgroundSteps) {
            this.getContext().waitingToProcessBackgroundSteps = false;
        } else {
            this.updateResultFromTags(this.scenarioTags);
        }
    }

    private void updateResultFromTags(List<Messages.GherkinDocument.Feature.Tag> scenarioTags) {
        if (TaggedScenario.isManual(scenarioTags)) {
            this.updateManualResultsFrom(scenarioTags);
        } else if (TaggedScenario.isPending(scenarioTags)) {
            this.getContext().stepEventBus().testPending();
        } else if (TaggedScenario.isSkippedOrWIP(scenarioTags)) {
            this.getContext().stepEventBus().testSkipped();
            this.updateCurrentScenarioResultTo(TestResult.SKIPPED);
        } else if (TaggedScenario.isIgnored(scenarioTags)) {
            this.getContext().stepEventBus().testIgnored();
            this.updateCurrentScenarioResultTo(TestResult.IGNORED);
        }
    }

    private void updateManualResultsFrom(List<Messages.GherkinDocument.Feature.Tag> scenarioTags) {
        this.getContext().stepEventBus().testIsManual();
        TaggedScenario.manualResultDefinedIn(scenarioTags).ifPresent(testResult -> UpdateManualScenario.forScenario(this.getContext().currentScenarioDefinition.getDescription()).inContext(this.getContext().stepEventBus().getBaseStepListener(), this.systemConfiguration.getEnvironmentVariables()).updateManualScenario((TestResult)testResult, scenarioTags));
    }

    private void updateCurrentScenarioResultTo(TestResult pending) {
        this.getContext().stepEventBus().getBaseStepListener().overrideResultTo(pending);
    }

    private void failed(String stepTitle, Throwable cause) {
        if (!this.errorOrFailureRecordedForStep(stepTitle, cause)) {
            Throwable rootCause;
            if (!StringUtils.isEmpty((CharSequence)stepTitle)) {
                this.getContext().stepEventBus().updateCurrentStepTitle(stepTitle);
            }
            if (this.isAssumptionFailure(rootCause = new RootCauseAnalyzer(cause).getRootCause().toException())) {
                this.getContext().stepEventBus().assumptionViolated(rootCause.getMessage());
            } else {
                this.getContext().stepEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(this.currentStepTitle())), rootCause));
            }
        }
    }

    private String currentStepTitle() {
        return this.getContext().stepEventBus().getCurrentStep().isPresent() ? ((TestStep)this.getContext().stepEventBus().getCurrentStep().get()).getDescription() : SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private boolean errorOrFailureRecordedForStep(String stepTitle, Throwable cause) {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        if (!this.latestTestOutcome().get().testStepWithDescription(stepTitle).isPresent()) {
            return false;
        }
        Optional matchingTestStep = this.latestTestOutcome().get().testStepWithDescription(stepTitle);
        if (matchingTestStep.isPresent() && ((TestStep)matchingTestStep.get()).getException() != null) {
            return ((TestStep)matchingTestStep.get()).getException().getOriginalCause() == cause;
        }
        return false;
    }

    private Optional<TestOutcome> latestTestOutcome() {
        if (!this.getContext().stepEventBus().isBaseStepListenerRegistered()) {
            return Optional.empty();
        }
        List recordedOutcomes = this.getContext().stepEventBus().getBaseStepListener().getTestOutcomes();
        return recordedOutcomes.isEmpty() ? Optional.empty() : Optional.of(recordedOutcomes.get(recordedOutcomes.size() - 1));
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    private String stepTitleFrom(Messages.GherkinDocument.Feature.Step currentStep, io.cucumber.plugin.event.TestStep testStep) {
        if (currentStep != null && testStep instanceof PickleStepTestStep) {
            return currentStep.getKeyword() + ((PickleStepTestStep)testStep).getStep().getText() + this.embeddedTableDataIn((PickleStepTestStep)testStep);
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private String embeddedTableDataIn(PickleStepTestStep currentStep) {
        if (currentStep.getStep().getArgument() != null) {
            StepArgument stepArgument = currentStep.getStep().getArgument();
            System.out.println("Step argument " + stepArgument.getClass());
            if (stepArgument instanceof DataTableArgument) {
                ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
                for (List row : ((DataTableArgument)stepArgument).cells()) {
                    HashMap<String, List> rowMap = new HashMap<String, List>();
                    rowMap.put("cells", row);
                    rowList.add(rowMap);
                }
                return this.convertToTextTable(rowList);
            }
        }
        return SCENARIO_OUTLINE_NOT_KNOWN_YET;
    }

    private String convertToTextTable(List<Map<String, Object>> rows) {
        StringBuilder textTable = new StringBuilder();
        textTable.append(System.lineSeparator());
        for (Map<String, Object> row : rows) {
            textTable.append("|");
            for (String cell : (List)row.get("cells")) {
                textTable.append(" ");
                textTable.append(cell);
                textTable.append(" |");
            }
            if (row == rows.get(rows.size() - 1)) continue;
            textTable.append(System.lineSeparator());
        }
        return textTable.toString();
    }

    private void generateReports() {
        this.getReportService().generateReportsFor(this.getAllTestOutcomes());
    }

    public List<TestOutcome> getAllTestOutcomes() {
        return this.baseStepListeners.stream().map(BaseStepListener::getTestOutcomes).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private String trim(String stringToBeTrimmed) {
        return stringToBeTrimmed == null ? null : stringToBeTrimmed.trim();
    }
}

