/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.BiPerformableExpectation;
import net.serenitybdd.screenplay.ensure.BlackBox;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DoubleValueExpectation;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import net.serenitybdd.screenplay.ensure.PerformablePredicate;
import net.serenitybdd.screenplay.ensure.PredicateExpectation;
import net.serenitybdd.screenplay.ensure.StringEnsure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001AB)\b\u0016\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u00a2\u0006\u0002\u0010\u0007B1\b\u0016\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\tB\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0002\u0010\nBI\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\fj\b\u0012\u0004\u0012\u00020\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000fJi\u0010\u0012\u001aL\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012(\u0012&\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJi\u0010\u001c\u001aL\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012(\u0012&\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u001d\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u0010\u001f\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u0010 \u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u0010!\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u0010\"\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJi\u0010#\u001aL\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012(\u0012&\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001a\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ&\u0010$\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJR\u0010%\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020\u0015JR\u0010&\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020'JR\u0010(\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020\u0015JR\u0010)\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020'JZ\u0010*\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(,\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(,0+2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'JR\u0010.\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020'JR\u0010/\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020'JR\u00100\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020'JR\u00101\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0'\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020'J\b\u00102\u001a\u00020\u0000H\u0016J&\u00103\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u00104\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJR\u00105\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020\u0015J&\u00106\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u00107\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u00108\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u00109\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJ&\u0010:\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u001eJR\u0010;\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020\u0015JR\u0010<\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0=\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020=JR\u0010<\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020\u0015J\b\u0010>\u001a\u00020\u0000H\u0016JR\u0010?\u001aF\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\"\u0012 0\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u00190\u00132\u0006\u0010\u0019\u001a\u00020\u0015J \u0010@\u001a\u00020\u00002\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00020\fj\b\u0012\u0004\u0012\u00020\u0002`\rH\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006B"}, d2={"Lnet/serenitybdd/screenplay/ensure/StringEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "(Lkotlin/jvm/functions/Function1;)V", "valueDescription", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "expectedDescription", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;Ljava/lang/String;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "contains", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "", "", "Lkotlin/ParameterName;", "name", "expectedList", "expected", "", "([Ljava/lang/String;)Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "containsIgnoringCase", "containsOnlyDigits", "Lnet/serenitybdd/screenplay/ensure/PerformablePredicate;", "containsOnlyLetters", "containsOnlyLettersOrDigits", "containsOnlyWhitespaces", "containsWhitespaces", "doesNotContain", "doesNotContainAnyWhitespaces", "endsWith", "hasLineCount", "", "hasSameSizeAs", "hasSize", "hasSizeBetween", "Lnet/serenitybdd/screenplay/ensure/BiPerformableExpectation;", "startRange", "endRange", "hasSizeGreaterThan", "hasSizeGreaterThanOrEqualTo", "hasSizeLessThan", "hasSizeLessThanOrEqualTo", "hasValue", "isBlank", "isEmpty", "isEqualToIgnoringCase", "isInLowercase", "isInUppercase", "isNotBlank", "isNotEmpty", "isNullOrEmpty", "isSubstringOf", "matches", "Ljava/util/regex/Pattern;", "not", "startsWith", "usingComparator", "Companion", "serenity-ensure"})
public final class StringEnsure
extends ComparableEnsure<String> {
    @NotNull
    private final Function1<Actor, String> value;
    private static final PredicateExpectation<Function1<Actor, String>> NULL_OR_EMPTY;
    private static final PredicateExpectation<Function1<Actor, String>> IS_EMPTY;
    private static final PredicateExpectation<Function1<Actor, String>> IS_NOT_EMPTY;
    private static final Expectation<Function1<Actor, String>, List<CharSequence>> CONTAINS;
    private static final Expectation<Function1<Actor, String>, List<CharSequence>> DOES_NOT_CONTAINS;
    private static final Expectation<Function1<Actor, String>, List<CharSequence>> CONTAINS_IGNORING_CASE;
    private static final Expectation<Function1<Actor, String>, CharSequence> EQUALS_IGNORING_CASE;
    private static final PredicateExpectation<Function1<Actor, String>> IS_UPPER_CASE;
    private static final PredicateExpectation<Function1<Actor, String>> IS_LOWER_CASE;
    private static final PredicateExpectation<Function1<Actor, String>> BLANK;
    private static final PredicateExpectation<Function1<Actor, String>> NOT_BLANK;
    private static final Expectation<Function1<Actor, String>, CharSequence> SUBSTRING_OF;
    private static final Expectation<Function1<Actor, String>, CharSequence> STARTS_WITH;
    private static final Expectation<Function1<Actor, String>, CharSequence> ENDS_WITH;
    private static final Expectation<Function1<Actor, String>, CharSequence> MATCHES;
    private static final Expectation<Function1<Actor, String>, Pattern> MATCHES_PATTERN;
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_WHITESPACES;
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_WHITESPACES;
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_NO_WHITESPACES;
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_DIGITS;
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_LETTERS;
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_LETTERS_OR_DIGITS;
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE;
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_LESS_THAN;
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_LESS_THAN_OR_EQUAL_TO;
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_GREATER_THAN;
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_GREATER_THAN_OR_EQUAL_TO;
    private static final DoubleValueExpectation<Function1<Actor, String>, Integer> HAS_SIZE_BETWEEN;
    private static final Expectation<Function1<Actor, String>, Integer> HAS_LINE_COUNT;
    private static final Expectation<Function1<Actor, String>, CharSequence> HAS_SAME_SIZE;
    public static final Companion Companion;

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isNullOrEmpty() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), NULL_OR_EMPTY, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isEmpty() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_EMPTY, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isNotEmpty() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_NOT_EMPTY, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, List<CharSequence>> contains(String ... expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, List<CharSequence>>(this.getValue(), CONTAINS, ArraysKt.toList((Object[])expected), this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, List<CharSequence>> doesNotContain(String ... expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, List<CharSequence>>(this.getValue(), DOES_NOT_CONTAINS, ArraysKt.toList((Object[])expected), this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, List<CharSequence>> containsIgnoringCase(String ... expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, List<CharSequence>>(this.getValue(), CONTAINS_IGNORING_CASE, ArraysKt.toList((Object[])expected), this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> isEqualToIgnoringCase(@NotNull CharSequence expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), EQUALS_IGNORING_CASE, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isInUppercase() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_UPPER_CASE, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isInLowercase() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_LOWER_CASE, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isBlank() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), BLANK, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isNotBlank() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), NOT_BLANK, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> isSubstringOf(@NotNull CharSequence expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), SUBSTRING_OF, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> startsWith(@NotNull CharSequence expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), STARTS_WITH, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> endsWith(@NotNull CharSequence expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), ENDS_WITH, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> matches(@NotNull CharSequence expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), MATCHES, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Pattern> matches(@NotNull Pattern expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, Pattern>(this.getValue(), MATCHES_PATTERN, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsWhitespaces() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_WHITESPACES, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyWhitespaces() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_WHITESPACES, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> doesNotContainAnyWhitespaces() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_NO_WHITESPACES, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyDigits() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_DIGITS, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyLetters() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_LETTERS, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyLettersOrDigits() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_LETTERS_OR_DIGITS, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSize(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeLessThan(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_LESS_THAN, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeLessThanOrEqualTo(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_LESS_THAN_OR_EQUAL_TO, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeGreaterThan(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_GREATER_THAN, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeGreaterThanOrEqualTo(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_GREATER_THAN_OR_EQUAL_TO, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final BiPerformableExpectation<Function1<Actor, String>, Integer> hasSizeBetween(int startRange, int endRange) {
        return new BiPerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_BETWEEN, startRange, endRange, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasLineCount(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_LINE_COUNT, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> hasSameSizeAs(@NotNull CharSequence expected) {
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), HAS_SAME_SIZE, expected, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public StringEnsure hasValue() {
        return this;
    }

    @Override
    @NotNull
    public StringEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        if (commonEnsure == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.StringEnsure");
        }
        return (StringEnsure)commonEnsure;
    }

    @NotNull
    public StringEnsure usingComparator(@NotNull Comparator<String> comparator) {
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        return new StringEnsure(this.getValue(), comparator, null, 4, null);
    }

    @Override
    @NotNull
    public Function1<Actor, String> getValue() {
        return this.value;
    }

    public StringEnsure(@NotNull Function1<? super Actor, String> value, @NotNull Comparator<String> comparator, @NotNull String expectedDescription) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull(comparator, (String)"comparator");
        Intrinsics.checkParameterIsNotNull((Object)expectedDescription, (String)"expectedDescription");
        super(value, comparator, expectedDescription);
        this.value = value;
    }

    public /* synthetic */ StringEnsure(Function1 function1, Comparator comparator, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "a string";
        }
        this((Function1<? super Actor, String>)function1, comparator, string);
    }

    public StringEnsure(@NotNull Function1<? super Actor, String> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"Comparator.naturalOrder<String>()");
        this(value, comparator, null, 4, null);
    }

    public StringEnsure(@NotNull Function1<? super Actor, String> value, @NotNull String valueDescription) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)valueDescription, (String)"valueDescription");
        Comparator<String> comparator = Comparator.naturalOrder();
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"Comparator.naturalOrder<String>()");
        this(value, comparator, valueDescription);
    }

    public StringEnsure(@Nullable String value) {
        Function1 function1 = new KnownValue<String>(value, value == null ? "<null>" : '\"' + value + '\"');
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkExpressionValueIsNotNull(comparator, (String)"naturalOrder<String>()");
        this(function1, comparator, null, 4, null);
    }

    static {
        Companion = new Companion(null);
        NULL_OR_EMPTY = ExpectationKt.expectThatActualIs("null or empty", Companion.NULL_OR_EMPTY.1.INSTANCE);
        IS_EMPTY = ExpectationKt.expectThatActualIs("empty", Companion.IS_EMPTY.1.INSTANCE);
        IS_NOT_EMPTY = ExpectationKt.expectThatActualIs("not empty", Companion.IS_NOT_EMPTY.1.INSTANCE);
        CONTAINS = ExpectationKt.expectThatActualIs("contains", "does not contain", Companion.CONTAINS.1.INSTANCE);
        DOES_NOT_CONTAINS = ExpectationKt.expectThatActualIs("does not contain", "contains", Companion.DOES_NOT_CONTAINS.1.INSTANCE);
        CONTAINS_IGNORING_CASE = ExpectationKt.expectThatActualIs("contains (ignoring case)", "does not contain (ignoring case)", Companion.CONTAINS_IGNORING_CASE.1.INSTANCE);
        EQUALS_IGNORING_CASE = ExpectationKt.expectThatActualIs("equal to (ignoring case)", Companion.EQUALS_IGNORING_CASE.1.INSTANCE);
        IS_UPPER_CASE = ExpectationKt.expectThatActualIs("in uppercase", Companion.IS_UPPER_CASE.1.INSTANCE);
        IS_LOWER_CASE = ExpectationKt.expectThatActualIs("in lowercase", Companion.IS_LOWER_CASE.1.INSTANCE);
        BLANK = ExpectationKt.expectThatActualIs("blank", Companion.BLANK.1.INSTANCE);
        NOT_BLANK = ExpectationKt.expectThatActualIs("is not blank", "is blank", Companion.NOT_BLANK.1.INSTANCE);
        SUBSTRING_OF = ExpectationKt.expectThatActualIs("a substring of", Companion.SUBSTRING_OF.1.INSTANCE);
        STARTS_WITH = ExpectationKt.expectThatActualIs("starts with", "does not start with", Companion.STARTS_WITH.1.INSTANCE);
        ENDS_WITH = ExpectationKt.expectThatActualIs("ends with", "does not end with", Companion.ENDS_WITH.1.INSTANCE);
        MATCHES = ExpectationKt.expectThatActualIs("a match for", Companion.MATCHES.1.INSTANCE);
        MATCHES_PATTERN = ExpectationKt.expectThatActualIs("a match for", Companion.MATCHES_PATTERN.1.INSTANCE);
        CONTAINS_WHITESPACES = ExpectationKt.expectThatActualIs("containing whitespaces", Companion.CONTAINS_WHITESPACES.1.INSTANCE);
        CONTAINS_ONLY_WHITESPACES = ExpectationKt.expectThatActualIs("containing only whitespaces", Companion.CONTAINS_ONLY_WHITESPACES.1.INSTANCE);
        CONTAINS_NO_WHITESPACES = ExpectationKt.expectThatActualIs("without any whitespaces", Companion.CONTAINS_NO_WHITESPACES.1.INSTANCE);
        CONTAINS_ONLY_DIGITS = ExpectationKt.expectThatActualIs("containing only digits", Companion.CONTAINS_ONLY_DIGITS.1.INSTANCE);
        CONTAINS_ONLY_LETTERS = ExpectationKt.expectThatActualIs("containing only letters", Companion.CONTAINS_ONLY_LETTERS.1.INSTANCE);
        CONTAINS_ONLY_LETTERS_OR_DIGITS = ExpectationKt.expectThatActualIs("containing only letters or digits", Companion.CONTAINS_ONLY_LETTERS_OR_DIGITS.1.INSTANCE);
        HAS_SIZE = ExpectationKt.expectThatActualIs("of size", Companion.HAS_SIZE.1.INSTANCE);
        HAS_SIZE_LESS_THAN = ExpectationKt.expectThatActualIs("of size less than", Companion.HAS_SIZE_LESS_THAN.1.INSTANCE);
        HAS_SIZE_LESS_THAN_OR_EQUAL_TO = ExpectationKt.expectThatActualIs("of size less than or equal to", Companion.HAS_SIZE_LESS_THAN_OR_EQUAL_TO.1.INSTANCE);
        HAS_SIZE_GREATER_THAN = ExpectationKt.expectThatActualIs("of size greater than", Companion.HAS_SIZE_GREATER_THAN.1.INSTANCE);
        HAS_SIZE_GREATER_THAN_OR_EQUAL_TO = ExpectationKt.expectThatActualIs("of size greater than or equal to", Companion.HAS_SIZE_GREATER_THAN_OR_EQUAL_TO.1.INSTANCE);
        HAS_SIZE_BETWEEN = ExpectationKt.expectThatActualIs("of size of between", Companion.HAS_SIZE_BETWEEN.1.INSTANCE);
        HAS_LINE_COUNT = ExpectationKt.expectThatActualIs("has a line count of", "does not have a line count of", Companion.HAS_LINE_COUNT.1.INSTANCE);
        HAS_SAME_SIZE = ExpectationKt.expectThatActualIs("has the same size as", "does not have the same size as", Companion.HAS_SAME_SIZE.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u00102\u001a\u0004\u0018\u00010\u00072\"\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b2\b\u00103\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0001H\u0002RN\u0010\u0003\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rx\u0010\f\u001al\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012(\u0012&\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0010\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rx\u0010\u0012\u001al\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012(\u0012&\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0010\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0013\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0014\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0015\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0016\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0017\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0018\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rx\u0010\u0019\u001al\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012(\u0012&\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0010\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\u001a\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\u001b\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\u001c\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\u001e\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010\u001f\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010 \u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\"\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010#\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010$\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010%\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010&\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u001d\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010'\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010(\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010)\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010*\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010+\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u0010,\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0-\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010.\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010/\u001aB\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u00100\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rr\u00101\u001af\u0012>\u0012<\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00020\u0007\u0018\u0001`\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\"\u0012 0\u000f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lnet/serenitybdd/screenplay/ensure/StringEnsure$Companion;", "", "()V", "BLANK", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "Lkotlin/ParameterName;", "name", "actual", "CONTAINS", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "", "", "expectedList", "expected", "CONTAINS_IGNORING_CASE", "CONTAINS_NO_WHITESPACES", "CONTAINS_ONLY_DIGITS", "CONTAINS_ONLY_LETTERS", "CONTAINS_ONLY_LETTERS_OR_DIGITS", "CONTAINS_ONLY_WHITESPACES", "CONTAINS_WHITESPACES", "DOES_NOT_CONTAINS", "ENDS_WITH", "EQUALS_IGNORING_CASE", "HAS_LINE_COUNT", "", "HAS_SAME_SIZE", "HAS_SIZE", "HAS_SIZE_BETWEEN", "Lnet/serenitybdd/screenplay/ensure/DoubleValueExpectation;", "startRange", "HAS_SIZE_GREATER_THAN", "HAS_SIZE_GREATER_THAN_OR_EQUAL_TO", "HAS_SIZE_LESS_THAN", "HAS_SIZE_LESS_THAN_OR_EQUAL_TO", "IS_EMPTY", "IS_LOWER_CASE", "IS_NOT_EMPTY", "IS_UPPER_CASE", "MATCHES", "MATCHES_PATTERN", "Ljava/util/regex/Pattern;", "NOT_BLANK", "NULL_OR_EMPTY", "STARTS_WITH", "SUBSTRING_OF", "resolveActual", "actor", "serenity-ensure"})
    public static final class Companion {
        private final String resolveActual(Function1<? super Actor, String> actual, Actor actor, Object expectedList) {
            Function1<? super Actor, String> function1 = actual;
            if (function1 == null) {
                Intrinsics.throwNpe();
            }
            Actor actor2 = actor;
            if (actor2 == null) {
                Intrinsics.throwNpe();
            }
            String actualValue = (String)function1.invoke((Object)actor2);
            BlackBox.INSTANCE.logAssertion(actualValue, expectedList);
            return actualValue;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ String access$resolveActual(Companion $this, Function1 actual, Actor actor, Object expectedList) {
            return $this.resolveActual((Function1<? super Actor, String>)actual, actor, expectedList);
        }
    }
}

