/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure.web;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.BlackBox;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.PerformablePredicate;
import net.serenitybdd.screenplay.ensure.PredicateExpectation;
import net.serenitybdd.screenplay.ensure.StringEnsure;
import net.serenitybdd.screenplay.ensure.web.TargetEnsure;
import net.serenitybdd.screenplay.targets.Target;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 02\u00020\u0001:\u00010B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0002\u001a\u00020\u0003J6\u0010\u0015\u001a(\u0012$\u0012\"\u0018\u00010\t\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a0\u00162\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J8\u0010\u0015\u001a(\u0012$\u0012\"\u0018\u00010\t\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a0\u00162\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u001c\u001a\u00020\u0006J6\u0010\u001d\u001a(\u0012$\u0012\"\u0018\u00010\t\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a0\u00162\u0006\u0010\u001c\u001a\u00020\u0006H\u0002J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u0013J\b\u0010!\u001a\u00020\rH\u0002J\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020$J(\u0010%\u001a\u001a\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\u00060&j\b\u0012\u0004\u0012\u00020\u0006`(2\u0006\u0010)\u001a\u00020\tH\u0002J\u0006\u0010*\u001a\u00020$J(\u0010+\u001a\u001a\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\u00060&j\b\u0012\u0004\u0012\u00020\u0006`(2\u0006\u0010)\u001a\u00020\tH\u0002J\u0006\u0010,\u001a\u00020$J\u0006\u0010-\u001a\u00020$J(\u0010.\u001a\u001a\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\u00060&j\b\u0012\u0004\u0012\u00020\u0006`(2\u0006\u0010)\u001a\u00020\tH\u0002J\u0006\u0010\b\u001a\u00020$J(\u0010/\u001a\u001a\u0012\u0004\u0012\u00020'\u0012\u0006\u0012\u0004\u0018\u00010\u00060&j\b\u0012\u0004\u0012\u00020\u0006`(2\u0006\u0010)\u001a\u00020\tH\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00061"}, d2={"Lnet/serenitybdd/screenplay/ensure/web/TargetEnsure;", "", "byLocator", "Lorg/openqa/selenium/By;", "(Lorg/openqa/selenium/By;)V", "xPathOrCssExpression", "", "(Ljava/lang/String;)V", "value", "Lnet/serenitybdd/screenplay/targets/Target;", "targetDescription", "(Lnet/serenitybdd/screenplay/targets/Target;Ljava/lang/String;)V", "negated", "", "getTargetDescription", "()Ljava/lang/String;", "getValue", "()Lnet/serenitybdd/screenplay/targets/Target;", "containsElements", "Lnet/serenitybdd/screenplay/ensure/PerformablePredicate;", "cssOrXPathExpression", "containsElementsLocatedBy", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "Lkotlin/ParameterName;", "name", "element", "actual", "hasCssClass", "cssClass", "hasCssClassWithName", "isDisabled", "isDisplayed", "isEnabled", "isNegated", "not", "selectedValue", "Lnet/serenitybdd/screenplay/ensure/StringEnsure;", "selectedValueOf", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "target", "selectedVisibleText", "selectedVisibleTextOf", "text", "textContent", "textValueOf", "valueOf", "Companion", "serenity-ensure"})
public final class TargetEnsure {
    private boolean negated;
    @NotNull
    private final Target value;
    @NotNull
    private final String targetDescription;
    private static final PredicateExpectation<Target> IS_DISPLAYED;
    private static final PredicateExpectation<Target> IS_DISABLED;
    private static final PredicateExpectation<Target> IS_ENABLED;
    public static final Companion Companion;

    @NotNull
    public final TargetEnsure not() {
        this.negated = !this.negated;
        return this;
    }

    private final boolean isNegated() {
        return this.negated;
    }

    @NotNull
    public final PerformablePredicate<Target> isDisplayed() {
        return new PerformablePredicate<Target>(this.value, IS_DISPLAYED, this.isNegated(), this.targetDescription);
    }

    @NotNull
    public final PerformablePredicate<Target> isDisabled() {
        return new PerformablePredicate<Target>(this.value, IS_DISABLED, this.isNegated(), this.targetDescription);
    }

    @NotNull
    public final PerformablePredicate<Target> isEnabled() {
        return new PerformablePredicate<Target>(this.value, IS_ENABLED, this.isNegated(), this.targetDescription);
    }

    @NotNull
    public final StringEnsure text() {
        return new StringEnsure((Function1<? super Actor, String>)this.textValueOf(this.value), this.targetDescription + " with text value");
    }

    @NotNull
    public final StringEnsure textContent() {
        return new StringEnsure((Function1<? super Actor, String>)this.textValueOf(this.value), this.targetDescription + " with text content");
    }

    @NotNull
    public final StringEnsure value() {
        return new StringEnsure((Function1<? super Actor, String>)this.valueOf(this.value), this.targetDescription + " with value");
    }

    @NotNull
    public final StringEnsure selectedValue() {
        return new StringEnsure((Function1<? super Actor, String>)this.selectedValueOf(this.value), this.targetDescription + " with selected value");
    }

    @NotNull
    public final StringEnsure selectedVisibleText() {
        return new StringEnsure((Function1<? super Actor, String>)this.selectedVisibleTextOf(this.value), this.targetDescription + " with selected visible text");
    }

    @NotNull
    public final PerformablePredicate<Target> hasCssClass(@NotNull String cssClass) {
        Intrinsics.checkParameterIsNotNull((Object)cssClass, (String)"cssClass");
        return new PerformablePredicate<Target>(this.value, this.hasCssClassWithName(cssClass), this.isNegated(), this.targetDescription);
    }

    @NotNull
    public final PerformablePredicate<Target> containsElements(@NotNull String cssOrXPathExpression) {
        Intrinsics.checkParameterIsNotNull((Object)cssOrXPathExpression, (String)"cssOrXPathExpression");
        return new PerformablePredicate<Target>(this.value, this.containsElementsLocatedBy(cssOrXPathExpression), this.isNegated(), this.targetDescription);
    }

    @NotNull
    public final PerformablePredicate<Target> containsElements(@NotNull By byLocator) {
        Intrinsics.checkParameterIsNotNull((Object)byLocator, (String)"byLocator");
        return new PerformablePredicate<Target>(this.value, this.containsElementsLocatedBy(byLocator), this.isNegated(), this.targetDescription);
    }

    private final Function1<Actor, String> textValueOf(Target target) {
        return (Function1)new Function1<Actor, String>(target){
            final /* synthetic */ Target $target;

            @NotNull
            public final String invoke(@Nullable Actor actor) {
                if (actor == null) {
                    return "";
                }
                WebElementFacade webElementFacade = this.$target.resolveFor(actor);
                Intrinsics.checkExpressionValueIsNotNull((Object)webElementFacade, (String)"target.resolveFor(actor)");
                String string = webElementFacade.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.resolveFor(actor).text");
                return string;
            }
            {
                this.$target = target;
                super(1);
            }
        };
    }

    private final Function1<Actor, String> valueOf(Target target) {
        return (Function1)new Function1<Actor, String>(target){
            final /* synthetic */ Target $target;

            @NotNull
            public final String invoke(@Nullable Actor actor) {
                if (actor == null) {
                    return "";
                }
                WebElementFacade webElementFacade = this.$target.resolveFor(actor);
                Intrinsics.checkExpressionValueIsNotNull((Object)webElementFacade, (String)"target.resolveFor(actor)");
                String string = webElementFacade.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.resolveFor(actor).value");
                return string;
            }
            {
                this.$target = target;
                super(1);
            }
        };
    }

    private final Function1<Actor, String> selectedValueOf(Target target) {
        return (Function1)new Function1<Actor, String>(target){
            final /* synthetic */ Target $target;

            @NotNull
            public final String invoke(@Nullable Actor actor) {
                if (actor == null) {
                    return "";
                }
                WebElementFacade webElementFacade = this.$target.resolveFor(actor);
                Intrinsics.checkExpressionValueIsNotNull((Object)webElementFacade, (String)"target.resolveFor(actor)");
                String string = webElementFacade.getSelectedValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.resolveFor(actor).selectedValue");
                return string;
            }
            {
                this.$target = target;
                super(1);
            }
        };
    }

    private final Function1<Actor, String> selectedVisibleTextOf(Target target) {
        return (Function1)new Function1<Actor, String>(target){
            final /* synthetic */ Target $target;

            @NotNull
            public final String invoke(@Nullable Actor actor) {
                if (actor == null) {
                    return "";
                }
                WebElementFacade webElementFacade = this.$target.resolveFor(actor);
                Intrinsics.checkExpressionValueIsNotNull((Object)webElementFacade, (String)"target.resolveFor(actor)");
                String string = webElementFacade.getSelectedVisibleTextValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"target.resolveFor(actor).selectedVisibleTextValue");
                return string;
            }
            {
                this.$target = target;
                super(1);
            }
        };
    }

    private final PredicateExpectation<Target> hasCssClassWithName(String cssClass) {
        return ExpectationKt.expectThatActualIs("has CSS class: \"" + cssClass + '\"', "does not have CSS class: \"" + cssClass + '\"', (Function2)new Function2<Actor, Target, Boolean>(cssClass){
            final /* synthetic */ String $cssClass;

            public final boolean invoke(@Nullable Actor actor, @Nullable Target element) {
                if (actor == null || element == null) {
                    return false;
                }
                WebElementFacade resolvedElement = element.resolveFor(actor);
                String actualCssClasses = resolvedElement.getAttribute("class");
                BlackBox.INSTANCE.logAssertionValues(actualCssClasses, this.$cssClass);
                return resolvedElement.hasClass(this.$cssClass);
            }
            {
                this.$cssClass = string;
                super(2);
            }
        });
    }

    private final PredicateExpectation<Target> containsElementsLocatedBy(String xPathOrCssExpression) {
        return ExpectationKt.expectThatActualIs("contains elements located by: " + xPathOrCssExpression, "does not contain any elements located by: " + xPathOrCssExpression, (Function2)new Function2<Actor, Target, Boolean>(xPathOrCssExpression){
            final /* synthetic */ String $xPathOrCssExpression;

            public final boolean invoke(@Nullable Actor actor, @Nullable Target element) {
                if (actor == null || element == null) {
                    return false;
                }
                return element.resolveFor(actor).containsElements(this.$xPathOrCssExpression);
            }
            {
                this.$xPathOrCssExpression = string;
                super(2);
            }
        });
    }

    private final PredicateExpectation<Target> containsElementsLocatedBy(By byLocator) {
        return ExpectationKt.expectThatActualIs("contains elements located by: " + byLocator, "does not contain any elements located by: " + byLocator, (Function2)new Function2<Actor, Target, Boolean>(byLocator){
            final /* synthetic */ By $byLocator;

            public final boolean invoke(@Nullable Actor actor, @Nullable Target element) {
                if (actor == null || element == null) {
                    return false;
                }
                return element.resolveFor(actor).containsElements(this.$byLocator);
            }
            {
                this.$byLocator = by;
                super(2);
            }
        });
    }

    @NotNull
    public final Target getValue() {
        return this.value;
    }

    @NotNull
    public final String getTargetDescription() {
        return this.targetDescription;
    }

    public TargetEnsure(@NotNull Target value, @NotNull String targetDescription) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)targetDescription, (String)"targetDescription");
        this.value = value;
        this.targetDescription = targetDescription;
    }

    public /* synthetic */ TargetEnsure(Target target, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = target.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"value.toString()");
            string = string2;
        }
        this(target, string);
    }

    public TargetEnsure(@NotNull By byLocator) {
        Intrinsics.checkParameterIsNotNull((Object)byLocator, (String)"byLocator");
        Target target = Target.the((String)byLocator.toString()).located(byLocator);
        Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"Target.the(byLocator.toS\u2026ing()).located(byLocator)");
        this(target, null, 2, null);
    }

    public TargetEnsure(@NotNull String xPathOrCssExpression) {
        Intrinsics.checkParameterIsNotNull((Object)xPathOrCssExpression, (String)"xPathOrCssExpression");
        Target target = Target.the((String)xPathOrCssExpression).locatedBy(xPathOrCssExpression);
        Intrinsics.checkExpressionValueIsNotNull((Object)target, (String)"Target.the(xPathOrCssExp\u2026dBy(xPathOrCssExpression)");
        this(target, null, 2, null);
    }

    static {
        Companion = new Companion(null);
        IS_DISPLAYED = ExpectationKt.expectThatActualIs("displayed", Companion.IS_DISPLAYED.1.INSTANCE);
        IS_DISABLED = ExpectationKt.expectThatActualIs("disabled", Companion.IS_DISABLED.1.INSTANCE);
        IS_ENABLED = ExpectationKt.expectThatActualIs("enabled", Companion.IS_ENABLED.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R4\u0010\u0003\u001a(\u0012$\u0012\"\u0018\u00010\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\n\u001a(\u0012$\u0012\"\u0018\u00010\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000b\u001a(\u0012$\u0012\"\u0018\u00010\u0005\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lnet/serenitybdd/screenplay/ensure/web/TargetEnsure$Companion;", "", "()V", "IS_DISABLED", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "Lnet/serenitybdd/screenplay/targets/Target;", "Lkotlin/ParameterName;", "name", "element", "actual", "IS_DISPLAYED", "IS_ENABLED", "isDisabledOrNot", "", "actualValue", "", "isDisplayedOrNot", "isEnabledOrNot", "serenity-ensure"})
    public static final class Companion {
        private final String isDisabledOrNot(boolean actualValue) {
            return actualValue ? "web element is disabled" : "web element is not disabled";
        }

        private final String isEnabledOrNot(boolean actualValue) {
            return actualValue ? "web element is enabled" : "web element is not enabled";
        }

        private final String isDisplayedOrNot(boolean actualValue) {
            return actualValue ? "web element is displayed" : "web element is not displayed";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ String access$isDisplayedOrNot(Companion $this, boolean actualValue) {
            return $this.isDisplayedOrNot(actualValue);
        }

        public static final /* synthetic */ String access$isDisabledOrNot(Companion $this, boolean actualValue) {
            return $this.isDisabledOrNot(actualValue);
        }

        public static final /* synthetic */ String access$isEnabledOrNot(Companion $this, boolean actualValue) {
            return $this.isEnabledOrNot(actualValue);
        }
    }
}

