/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.ensure.BooleanEnsure;
import net.serenitybdd.screenplay.ensure.CollectionEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DateEnsure;
import net.serenitybdd.screenplay.ensure.DoubleEnsure;
import net.serenitybdd.screenplay.ensure.FloatEnsure;
import net.serenitybdd.screenplay.ensure.KnowableBooleanAnswer;
import net.serenitybdd.screenplay.ensure.KnowableCollectionAnswer;
import net.serenitybdd.screenplay.ensure.KnowableCollectionTarget;
import net.serenitybdd.screenplay.ensure.KnowableComparableAnswer;
import net.serenitybdd.screenplay.ensure.KnowableStringAnswer;
import net.serenitybdd.screenplay.ensure.StringEnsure;
import net.serenitybdd.screenplay.ensure.TimeEnsure;
import net.serenitybdd.screenplay.ensure.web.PageObjectEnsure;
import net.serenitybdd.screenplay.ensure.web.TargetEnsure;
import net.serenitybdd.screenplay.targets.Target;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.By;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00042\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u001a\u0015\u0010\u0000\u001a\u00020\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a \u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u0004\b\u0000\u0010\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\n0\u000b\u001a\u0015\u0010\u0000\u001a\u00020\f2\b\u0010\u0002\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000e\u001a\u0015\u0010\u0000\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0000\u001a\u00020\u00122\b\u0010\u0002\u001a\u0004\u0018\u00010\u0013\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014\"\u0004\b\u0000\u0010\n2\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u0002H\n\u0018\u00010\u0015\u001a\u000e\u0010\u0000\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0017\u001a\u000e\u0010\u0000\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0002\u001a\u00020\u0017\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0002\u001a\u00020\u0018\u001a2\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\u0006\u0010\u001c\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\n0\u001e\u001a*\u0010\u001b\u001a\u00020\u0006\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u00132\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001e\u001a*\u0010\u001b\u001a\u00020\u0012\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u00132\u0006\u0010\u001c\u001a\u00020\u00132\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001e\u001a*\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\u000e\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\n0\u001e\u001a\"\u0010\u001b\u001a\u00020\u0006\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u00072\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001e\u001a\"\u0010\u001b\u001a\u00020\u0012\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u00132\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u001e\u001a.\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014\"\u0004\b\u0000\u0010\n2\u0006\u0010\u001c\u001a\u00020\u00132\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00150\u001e\u001a&\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0014\"\u0004\b\u0000\u0010\n2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00150\u001e\u001a\u0006\u0010 \u001a\u00020!\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0002\u001a\u00020\u0017\u001a\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00142\u0006\u0010\u0002\u001a\u00020\u0018\u00a8\u0006#"}, d2={"that", "Lnet/serenitybdd/screenplay/ensure/DateEnsure;", "value", "Ljava/time/LocalDate;", "Lnet/serenitybdd/screenplay/ensure/TimeEnsure;", "Ljava/time/LocalTime;", "Lnet/serenitybdd/screenplay/ensure/BooleanEnsure;", "", "(Ljava/lang/Boolean;)Lnet/serenitybdd/screenplay/ensure/BooleanEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "A", "", "Lnet/serenitybdd/screenplay/ensure/DoubleEnsure;", "", "(Ljava/lang/Double;)Lnet/serenitybdd/screenplay/ensure/DoubleEnsure;", "Lnet/serenitybdd/screenplay/ensure/FloatEnsure;", "", "(Ljava/lang/Float;)Lnet/serenitybdd/screenplay/ensure/FloatEnsure;", "Lnet/serenitybdd/screenplay/ensure/StringEnsure;", "", "Lnet/serenitybdd/screenplay/ensure/CollectionEnsure;", "", "Lnet/serenitybdd/screenplay/ensure/web/TargetEnsure;", "Lnet/serenitybdd/screenplay/targets/Target;", "Lorg/openqa/selenium/By;", "thatAmongst", "Lnet/serenitybdd/core/pages/WebElementFacade;", "thatTheAnswerTo", "description", "question", "Lnet/serenitybdd/screenplay/Question;", "thatTheAnswersTo", "thatTheCurrentPage", "Lnet/serenitybdd/screenplay/ensure/web/PageObjectEnsure;", "thatTheSetOf", "serenity-ensure"})
@JvmName(name="Ensure")
public final class Ensure {
    @NotNull
    public static final StringEnsure that(@Nullable String value) {
        return new StringEnsure(value);
    }

    @NotNull
    public static final DateEnsure that(@Nullable LocalDate value) {
        return new DateEnsure(value);
    }

    @NotNull
    public static final TimeEnsure that(@Nullable LocalTime value) {
        return new TimeEnsure(value);
    }

    @NotNull
    public static final BooleanEnsure that(@Nullable Boolean value) {
        return new BooleanEnsure(value);
    }

    @NotNull
    public static final FloatEnsure that(@Nullable Float value) {
        return new FloatEnsure(value);
    }

    @NotNull
    public static final DoubleEnsure that(@Nullable Double value) {
        return new DoubleEnsure(value);
    }

    @NotNull
    public static final <A> ComparableEnsure<A> that(@NotNull Comparable<? super A> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return new ComparableEnsure(value, null, 2, null);
    }

    @NotNull
    public static final <A> CollectionEnsure<A> that(@Nullable Collection<? extends A> value) {
        return new CollectionEnsure<A>(value);
    }

    @NotNull
    public static final <A extends Boolean> BooleanEnsure thatTheAnswerTo(@NotNull String description, @NotNull Question<Boolean> question) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(question, (String)"question");
        return new BooleanEnsure((Function1<? super Actor, Boolean>)((Function1)new KnowableBooleanAnswer(question, description)));
    }

    @NotNull
    public static final <A extends Boolean> BooleanEnsure thatTheAnswerTo(@NotNull Question<Boolean> question) {
        Intrinsics.checkNotNullParameter(question, (String)"question");
        String string = question.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"question.subject");
        return new BooleanEnsure((Function1<? super Actor, Boolean>)((Function1)new KnowableBooleanAnswer(question, string)));
    }

    @NotNull
    public static final <A extends String> StringEnsure thatTheAnswerTo(@NotNull String description, @NotNull Question<String> question) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(question, (String)"question");
        return new StringEnsure((Function1<? super Actor, String>)((Function1)new KnowableStringAnswer(question, description)));
    }

    @NotNull
    public static final <A extends String> StringEnsure thatTheAnswerTo(@NotNull Question<String> question) {
        Intrinsics.checkNotNullParameter(question, (String)"question");
        String string = question.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"question.subject");
        return new StringEnsure((Function1<? super Actor, String>)((Function1)new KnowableStringAnswer(question, string)));
    }

    @NotNull
    public static final <A extends Comparable<? super A>> ComparableEnsure<A> thatTheAnswerTo(@NotNull String description, @NotNull Question<A> question) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(question, (String)"question");
        return new ComparableEnsure((Function1)new KnowableComparableAnswer<A>(question, description), null, description);
    }

    @NotNull
    public static final <A extends Comparable<? super A>> ComparableEnsure<A> thatTheAnswerTo(@NotNull Question<A> question) {
        Intrinsics.checkNotNullParameter(question, (String)"question");
        String string = question.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"question.subject");
        return Ensure.thatTheAnswerTo(string, question);
    }

    @NotNull
    public static final <A> CollectionEnsure<A> thatTheAnswersTo(@NotNull String description, @NotNull Question<Collection<A>> question) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(question, (String)"question");
        return new CollectionEnsure(new KnowableCollectionAnswer<A>(question, description), description, null, 4, null);
    }

    @NotNull
    public static final <A> CollectionEnsure<A> thatTheAnswersTo(@NotNull Question<Collection<A>> question) {
        Intrinsics.checkNotNullParameter(question, (String)"question");
        String string = question.getSubject();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"question.subject");
        return Ensure.thatTheAnswersTo(string, question);
    }

    @NotNull
    public static final PageObjectEnsure thatTheCurrentPage() {
        return new PageObjectEnsure();
    }

    @NotNull
    public static final TargetEnsure that(@NotNull Target value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new TargetEnsure(value, null, 2, null);
    }

    @NotNull
    public static final TargetEnsure that(@NotNull By value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new TargetEnsure(value);
    }

    @NotNull
    public static final CollectionEnsure<WebElementFacade> thatTheSetOf(@NotNull Target value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new CollectionEnsure<WebElementFacade>(new KnowableCollectionTarget(value, null, 2, null), "a collection of " + new KnowableCollectionTarget(value, null, 2, null), null, 4, null);
    }

    @NotNull
    public static final CollectionEnsure<WebElementFacade> thatTheSetOf(@NotNull By value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new CollectionEnsure<WebElementFacade>(new KnowableCollectionTarget(value), "a collection of " + new KnowableCollectionTarget(value), null, 4, null);
    }

    @NotNull
    public static final CollectionEnsure<WebElementFacade> thatAmongst(@NotNull Target value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new CollectionEnsure<WebElementFacade>(new KnowableCollectionTarget(value, null, 2, null), "a collection of " + new KnowableCollectionTarget(value, null, 2, null), null, 4, null);
    }

    @NotNull
    public static final CollectionEnsure<WebElementFacade> thatAmongst(@NotNull By value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new CollectionEnsure<WebElementFacade>(new KnowableCollectionTarget(value), "a collection of " + new KnowableCollectionTarget(value), null, 4, null);
    }
}

