/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u0001J$\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\r\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\u001c\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012J\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0012J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0016"}, d2={"Lnet/serenitybdd/screenplay/ensure/CommonPreconditions;", "", "()V", "ensureActualAndActorNotNull", "", "actual", "actor", "Lnet/serenitybdd/screenplay/Actor;", "ensureActualAndExpectedNotNull", "expected", "ensureActualAndRangeValues", "startRange", "endRange", "ensureActualNotNull", "ensureNoNullElementsIn", "message", "", "list", "", "ensureNotEmpty", "ensureNotNull", "value", "serenity-ensure"})
public final class CommonPreconditions {
    public static final CommonPreconditions INSTANCE;

    public final void ensureActualNotNull(@Nullable Object actual) {
        this.ensureNotNull("actual should not be null", actual);
    }

    public final void ensureActualAndExpectedNotNull(@Nullable Object actual, @Nullable Object expected) {
        this.ensureNotNull("actual should not be null", actual);
        this.ensureNotNull("expected should not be null", expected);
    }

    public final void ensureActualAndActorNotNull(@Nullable Object actual, @Nullable Actor actor) {
        this.ensureNotNull("actual should not be null", actual);
        this.ensureNotNull("actor should not be null", actor);
    }

    public final void ensureActualAndRangeValues(@Nullable Object actual, @Nullable Object startRange, @Nullable Object endRange) {
        this.ensureNotNull("actual should not be null", actual);
        this.ensureNotNull("start range should not be null", startRange);
        this.ensureNotNull("end range should not be null", endRange);
    }

    public final void ensureNotNull(@NotNull String message, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value == null) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }

    public final void ensureNotEmpty(@NotNull String message, @Nullable Collection<? extends Object> list) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (list == null || list.isEmpty()) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }

    public final void ensureNoNullElementsIn(@NotNull String message, @NotNull Collection<? extends Object> list) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
    }

    private CommonPreconditions() {
    }

    static {
        CommonPreconditions commonPreconditions;
        INSTANCE = commonPreconditions = new CommonPreconditions();
    }
}

