/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure.collections;

import java.util.Collection;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u001c\b\u0002\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fJ$\u0010\u000e\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J$\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0002J\u001b\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011R%\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0004j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lnet/serenitybdd/screenplay/ensure/collections/CollectionsComparison;", "A", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(Ljava/util/Comparator;)V", "getComparator", "()Ljava/util/Comparator;", "areEqual", "", "actual", "", "expected", "compareElementsOf", "elementsAreIdenticalUsingComparatorIn", "isSame", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "serenity-ensure"})
public final class CollectionsComparison<A> {
    @Nullable
    private final Comparator<A> comparator;

    public CollectionsComparison(@Nullable Comparator<A> comparator) {
        this.comparator = comparator;
    }

    public /* synthetic */ CollectionsComparison(Comparator comparator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            comparator = null;
        }
        this(comparator);
    }

    @Nullable
    public final Comparator<A> getComparator() {
        return this.comparator;
    }

    public final boolean areEqual(@Nullable Collection<? extends A> actual, @Nullable Collection<? extends A> expected) {
        if (actual == null && expected == null) {
            return true;
        }
        if (actual == null || expected == null) {
            return false;
        }
        return this.compareElementsOf(actual, expected);
    }

    private final boolean compareElementsOf(Collection<? extends A> actual, Collection<? extends A> expected) {
        return this.comparator == null ? Intrinsics.areEqual(actual, expected) : this.elementsAreIdenticalUsingComparatorIn(actual, expected);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean elementsAreIdenticalUsingComparatorIn(Collection<? extends A> actual, Collection<? extends A> expected) {
        if (actual.size() != expected.size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = actual;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv;
            int i = n;
            boolean bl = false;
            if (this.isSame(value, CollectionsKt.elementAt((Iterable)expected, (int)i))) continue;
            return false;
        }
        return true;
    }

    public final boolean isSame(A actual, A expected) {
        if (actual == null && expected == null) {
            return true;
        }
        if (actual == null || expected == null) {
            return false;
        }
        return this.comparator == null ? Intrinsics.areEqual(actual, expected) : this.comparator.compare(actual, expected) == 0;
    }

    public CollectionsComparison() {
        this(null, 1, null);
    }
}

