/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.PerformableExpectationsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\u0007\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\b\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ$\u0010\f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015J\u001c\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015\u00a8\u0006\u0017"}, d2={"Lnet/serenitybdd/screenplay/ensure/CommonPreconditions;", "", "<init>", "()V", "ensureActualNotNull", "", "actual", "ensureActualAndExpectedNotNull", "expected", "ensureActualAndActorNotNull", "actor", "Lnet/serenitybdd/screenplay/Actor;", "ensureActualAndRangeValues", "startRange", "endRange", "ensureNotNull", "message", "", "value", "ensureNotEmpty", "list", "", "ensureNoNullElementsIn", "serenity-ensure"})
@SourceDebugExtension(value={"SMAP\nCommonPreconditions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommonPreconditions.kt\nnet/serenitybdd/screenplay/ensure/CommonPreconditions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1755#2,3:50\n*S KotlinDebug\n*F\n+ 1 CommonPreconditions.kt\nnet/serenitybdd/screenplay/ensure/CommonPreconditions\n*L\n44#1:50,3\n*E\n"})
public final class CommonPreconditions {
    @NotNull
    public static final CommonPreconditions INSTANCE = new CommonPreconditions();

    private CommonPreconditions() {
    }

    public final void ensureActualNotNull(@Nullable Object actual) {
        this.ensureNotNull("actual should not be null", actual);
    }

    public final void ensureActualAndExpectedNotNull(@Nullable Object actual, @Nullable Object expected) {
        this.ensureNotNull("actual should not be null", actual);
        this.ensureNotNull("expected should not be null", expected);
    }

    public final void ensureActualAndActorNotNull(@Nullable Object actual, @Nullable Actor actor) {
        this.ensureNotNull("actual should not be null", actual);
        this.ensureNotNull("actor should not be null", actor);
    }

    public final void ensureActualAndRangeValues(@Nullable Object actual, @Nullable Object startRange, @Nullable Object endRange) {
        this.ensureNotNull("actual should not be null", actual);
        this.ensureNotNull("start range should not be null", startRange);
        this.ensureNotNull("end range should not be null", endRange);
    }

    public final void ensureNotNull(@NotNull String message, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (value == null) {
            PerformableExpectationsKt.takeScreenshot();
            throw new AssertionError((Object)message);
        }
    }

    public final void ensureNotEmpty(@NotNull String message, @Nullable Collection<? extends Object> list) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (list == null || list.isEmpty()) {
            PerformableExpectationsKt.takeScreenshot();
            throw new AssertionError((Object)message);
        }
    }

    public final void ensureNoNullElementsIn(@NotNull String message, @NotNull Collection<? extends Object> list) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(list, (String)"list");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            PerformableExpectationsKt.takeScreenshot();
            throw new AssertionError((Object)message);
        }
    }
}

