/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.BiPerformableExpectation;
import net.serenitybdd.screenplay.ensure.BlackBox;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.CommonPreconditions;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DescriptionOfKt;
import net.serenitybdd.screenplay.ensure.DoubleValueExpectation;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import net.serenitybdd.screenplay.ensure.PerformablePredicate;
import net.serenitybdd.screenplay.ensure.PredicateExpectation;
import net.thucydides.core.steps.StepEventBus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 B2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001BBK\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fB+\b\u0016\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u00a2\u0006\u0004\b\u000b\u0010\rB3\b\u0016\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\u000fB\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0010J&\u0010\u0013\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010\u0015\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010\u0016\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014JZ\u0010\u0017\u001a=\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001e\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001fJZ\u0010 \u001a=\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001e\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001fJZ\u0010!\u001a=\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u001e\"\u00020\u0002\u00a2\u0006\u0002\u0010\u001fJC\u0010\"\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJ&\u0010#\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010$\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010%\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010&\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014JC\u0010'\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJC\u0010(\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJC\u0010)\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJC\u0010*\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJC\u0010*\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020+J&\u0010,\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010-\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010.\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u0010/\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u00100\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014J&\u00101\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u00060\u0014JC\u00102\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u000203JC\u00104\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u000203JC\u00105\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u000203JC\u00106\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u000203JC\u00107\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u000203JK\u00108\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(:092\u0006\u0010:\u001a\u0002032\u0006\u0010;\u001a\u000203JC\u0010<\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u001103\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u000203JC\u0010=\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d0\u00182\u0006\u0010\u001d\u001a\u00020\u001aJ\b\u0010>\u001a\u00020\u0000H\u0016J\b\u0010?\u001a\u00020\u0000H\u0016J\b\u0010@\u001a\u00020\u0000H\u0016J \u0010A\u001a\u00020\u00002\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\tH\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006C"}, d2={"Lnet/serenitybdd/screenplay/ensure/StringEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "expectedDescription", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;Ljava/lang/String;)V", "(Lkotlin/jvm/functions/Function1;)V", "valueDescription", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isNullOrEmpty", "Lnet/serenitybdd/screenplay/ensure/PerformablePredicate;", "isEmpty", "isNotEmpty", "contains", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "", "", "Lkotlin/ParameterName;", "name", "expected", "", "([Ljava/lang/String;)Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "doesNotContain", "containsIgnoringCase", "isEqualToIgnoringCase", "isInUppercase", "isInLowercase", "isBlank", "isNotBlank", "isSubstringOf", "startsWith", "endsWith", "matches", "Ljava/util/regex/Pattern;", "containsWhitespaces", "containsOnlyWhitespaces", "doesNotContainAnyWhitespaces", "containsOnlyDigits", "containsOnlyLetters", "containsOnlyLettersOrDigits", "hasSize", "", "hasSizeLessThan", "hasSizeLessThanOrEqualTo", "hasSizeGreaterThan", "hasSizeGreaterThanOrEqualTo", "hasSizeBetween", "Lnet/serenitybdd/screenplay/ensure/BiPerformableExpectation;", "startRange", "endRange", "hasLineCount", "hasSameSizeAs", "hasValue", "not", "silently", "usingComparator", "Companion", "serenity-ensure"})
@SourceDebugExtension(value={"SMAP\nStringEnsure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringEnsure.kt\nnet/serenitybdd/screenplay/ensure/StringEnsure\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,517:1\n1734#2,3:518\n2632#2,3:521\n1734#2,3:524\n*S KotlinDebug\n*F\n+ 1 StringEnsure.kt\nnet/serenitybdd/screenplay/ensure/StringEnsure\n*L\n241#1:518,3\n256#1:521,3\n268#1:524,3\n*E\n"})
public final class StringEnsure
extends ComparableEnsure<String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Actor, String> value;
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> NULL_OR_EMPTY = ExpectationKt.expectThatActualIs("null or empty", StringEnsure::NULL_OR_EMPTY$lambda$0);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> IS_EMPTY = ExpectationKt.expectThatActualIs("empty", StringEnsure::IS_EMPTY$lambda$1);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> IS_NOT_EMPTY = ExpectationKt.expectThatActualIs("not empty", StringEnsure::IS_NOT_EMPTY$lambda$2);
    @NotNull
    private static final Expectation<Function1<Actor, String>, List<CharSequence>> CONTAINS = ExpectationKt.expectThatActualIs("contains", "does not contain", StringEnsure::CONTAINS$lambda$4);
    @NotNull
    private static final Expectation<Function1<Actor, String>, List<CharSequence>> DOES_NOT_CONTAINS = ExpectationKt.expectThatActualIs("does not contain", "contains", StringEnsure::DOES_NOT_CONTAINS$lambda$6);
    @NotNull
    private static final Expectation<Function1<Actor, String>, List<CharSequence>> CONTAINS_IGNORING_CASE = ExpectationKt.expectThatActualIs("contains (ignoring case)", "does not contain (ignoring case)", StringEnsure::CONTAINS_IGNORING_CASE$lambda$8);
    @NotNull
    private static final Expectation<Function1<Actor, String>, CharSequence> EQUALS_IGNORING_CASE = ExpectationKt.expectThatActualIs("equal to (ignoring case)", StringEnsure::EQUALS_IGNORING_CASE$lambda$9);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> IS_UPPER_CASE = ExpectationKt.expectThatActualIs("uppercase", StringEnsure::IS_UPPER_CASE$lambda$10);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> IS_LOWER_CASE = ExpectationKt.expectThatActualIs("lowercase", StringEnsure::IS_LOWER_CASE$lambda$11);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> BLANK = ExpectationKt.expectThatActualIs("blank", StringEnsure::BLANK$lambda$12);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> NOT_BLANK = ExpectationKt.expectThatActualIs("is not blank", "is blank", StringEnsure::NOT_BLANK$lambda$13);
    @NotNull
    private static final Expectation<Function1<Actor, String>, CharSequence> SUBSTRING_OF = ExpectationKt.expectThatActualIs("a substring of", StringEnsure::SUBSTRING_OF$lambda$14);
    @NotNull
    private static final Expectation<Function1<Actor, String>, CharSequence> STARTS_WITH = ExpectationKt.expectThatActualIs("starts with", "does not start with", StringEnsure::STARTS_WITH$lambda$15);
    @NotNull
    private static final Expectation<Function1<Actor, String>, CharSequence> ENDS_WITH = ExpectationKt.expectThatActualIs("ends with", "does not end with", StringEnsure::ENDS_WITH$lambda$16);
    @NotNull
    private static final Expectation<Function1<Actor, String>, CharSequence> MATCHES = ExpectationKt.expectThatActualIs("a match for", StringEnsure::MATCHES$lambda$17);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Pattern> MATCHES_PATTERN = ExpectationKt.expectThatActualIs("a match for", StringEnsure::MATCHES_PATTERN$lambda$18);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_WHITESPACES = ExpectationKt.expectThatActualIs("contains whitespaces", "contains no whitespaces", StringEnsure::CONTAINS_WHITESPACES$lambda$19);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_WHITESPACES = ExpectationKt.expectThatActualIs("contains only whitespaces", "does not contain only whitespaces", StringEnsure::CONTAINS_ONLY_WHITESPACES$lambda$20);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_NO_WHITESPACES = ExpectationKt.expectThatActualIs("contains no whitespace", " contains whitespace", StringEnsure::CONTAINS_NO_WHITESPACES$lambda$21);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_DIGITS = ExpectationKt.expectThatActualIs("contains only digits", "does not contain only digits", StringEnsure::CONTAINS_ONLY_DIGITS$lambda$22);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_LETTERS = ExpectationKt.expectThatActualIs("contains only letters", "does not contain only letters", StringEnsure::CONTAINS_ONLY_LETTERS$lambda$23);
    @NotNull
    private static final PredicateExpectation<Function1<Actor, String>> CONTAINS_ONLY_LETTERS_OR_DIGITS = ExpectationKt.expectThatActualIs("contains only letters or digits", "contains characters other than letters and digits", StringEnsure::CONTAINS_ONLY_LETTERS_OR_DIGITS$lambda$24);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE = ExpectationKt.expectThatActualIs("has size", "does not have size", StringEnsure::HAS_SIZE$lambda$25);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_LESS_THAN = ExpectationKt.expectThatActualIs("has size less than", "has size greater than or equal to", StringEnsure::HAS_SIZE_LESS_THAN$lambda$26);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_LESS_THAN_OR_EQUAL_TO = ExpectationKt.expectThatActualIs("has size less than or equal to", "has size greater than", StringEnsure::HAS_SIZE_LESS_THAN_OR_EQUAL_TO$lambda$27);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_GREATER_THAN = ExpectationKt.expectThatActualIs("has size greater than", "has size less than or equal to", StringEnsure::HAS_SIZE_GREATER_THAN$lambda$28);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Integer> HAS_SIZE_GREATER_THAN_OR_EQUAL_TO = ExpectationKt.expectThatActualIs("has size greater than or equal to", "has size less than", StringEnsure::HAS_SIZE_GREATER_THAN_OR_EQUAL_TO$lambda$29);
    @NotNull
    private static final DoubleValueExpectation<Function1<Actor, String>, Integer> HAS_SIZE_BETWEEN = ExpectationKt.expectThatActualIs("of size between", StringEnsure::HAS_SIZE_BETWEEN$lambda$30);
    @NotNull
    private static final Expectation<Function1<Actor, String>, Integer> HAS_LINE_COUNT = ExpectationKt.expectThatActualIs("has a line count of", "does not have a line count of", StringEnsure::HAS_LINE_COUNT$lambda$31);
    @NotNull
    private static final Expectation<Function1<Actor, String>, CharSequence> HAS_SAME_SIZE = ExpectationKt.expectThatActualIs("has the same size as", "does not have the same size as", StringEnsure::HAS_SAME_SIZE$lambda$32);

    public StringEnsure(@NotNull Function1<? super Actor, String> value, @NotNull Comparator<String> comparator, @NotNull String expectedDescription) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Intrinsics.checkNotNullParameter((Object)expectedDescription, (String)"expectedDescription");
        super(value, comparator, expectedDescription);
        this.value = value;
    }

    public /* synthetic */ StringEnsure(Function1 function1, Comparator comparator, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = DescriptionOfKt.descriptionOf(function1);
        }
        this((Function1<? super Actor, String>)function1, comparator, string);
    }

    @Override
    @NotNull
    public Function1<Actor, String> getValue() {
        return this.value;
    }

    public StringEnsure(@NotNull Function1<? super Actor, String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        this(value, comparator, null, 4, null);
    }

    public StringEnsure(@NotNull Function1<? super Actor, String> value, @NotNull String valueDescription) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)valueDescription, (String)"valueDescription");
        Comparator<String> comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        this(value, comparator, valueDescription);
    }

    public StringEnsure(@Nullable String value) {
        String string = value;
        Function1 function1 = new KnownValue<String>(value, (String)(string == null ? "<null>" : "\"" + string + "\""));
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        this(function1, comparator, null, 4, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isNullOrEmpty() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), NULL_OR_EMPTY, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isEmpty() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_EMPTY, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isNotEmpty() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_NOT_EMPTY, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, List<CharSequence>> contains(String ... expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, List<CharSequence>>(this.getValue(), CONTAINS, ArraysKt.toList((Object[])expected), this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, List<CharSequence>> doesNotContain(String ... expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, List<CharSequence>>(this.getValue(), DOES_NOT_CONTAINS, ArraysKt.toList((Object[])expected), this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, List<CharSequence>> containsIgnoringCase(String ... expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, List<CharSequence>>(this.getValue(), CONTAINS_IGNORING_CASE, ArraysKt.toList((Object[])expected), this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> isEqualToIgnoringCase(@NotNull CharSequence expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), EQUALS_IGNORING_CASE, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isInUppercase() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_UPPER_CASE, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isInLowercase() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), IS_LOWER_CASE, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isBlank() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), BLANK, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> isNotBlank() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), NOT_BLANK, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> isSubstringOf(@NotNull CharSequence expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), SUBSTRING_OF, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> startsWith(@NotNull CharSequence expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), STARTS_WITH, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> endsWith(@NotNull CharSequence expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), ENDS_WITH, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> matches(@NotNull CharSequence expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), MATCHES, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Pattern> matches(@NotNull Pattern expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, Pattern>(this.getValue(), MATCHES_PATTERN, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsWhitespaces() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_WHITESPACES, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyWhitespaces() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_WHITESPACES, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> doesNotContainAnyWhitespaces() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_NO_WHITESPACES, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyDigits() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_DIGITS, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyLetters() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_LETTERS, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, String>> containsOnlyLettersOrDigits() {
        return new PerformablePredicate<Function1<Actor, String>>(this.getValue(), CONTAINS_ONLY_LETTERS_OR_DIGITS, this.isNegated(), this.getExpectedDescription(), null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSize(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeLessThan(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_LESS_THAN, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeLessThanOrEqualTo(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_LESS_THAN_OR_EQUAL_TO, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeGreaterThan(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_GREATER_THAN, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasSizeGreaterThanOrEqualTo(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_GREATER_THAN_OR_EQUAL_TO, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final BiPerformableExpectation<Function1<Actor, String>, Integer> hasSizeBetween(int startRange, int endRange) {
        return new BiPerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_SIZE_BETWEEN, startRange, endRange, this.isNegated(), this.getExpectedDescription());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, Integer> hasLineCount(int expected) {
        return new PerformableExpectation<Function1<Actor, String>, Integer>(this.getValue(), HAS_LINE_COUNT, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, String>, CharSequence> hasSameSizeAs(@NotNull CharSequence expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, String>, CharSequence>(this.getValue(), HAS_SAME_SIZE, expected, this.isNegated(), this.getExpectedDescription(), null, 32, null);
    }

    @NotNull
    public StringEnsure hasValue() {
        return this;
    }

    @Override
    @NotNull
    public StringEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        Intrinsics.checkNotNull(commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.StringEnsure");
        return (StringEnsure)commonEnsure;
    }

    @Override
    @NotNull
    public StringEnsure silently() {
        CommonEnsure commonEnsure = super.silently();
        Intrinsics.checkNotNull((Object)commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.StringEnsure");
        return (StringEnsure)commonEnsure;
    }

    @NotNull
    public StringEnsure usingComparator(@NotNull Comparator<String> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        return new StringEnsure(this.getValue(), comparator, null, 4, null);
    }

    private static final boolean NULL_OR_EMPTY$lambda$0(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "a null or empty value");
        return actualValue == null || ((CharSequence)actualValue).length() == 0;
    }

    private static final boolean IS_EMPTY$lambda$1(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "an empty value");
        return actualValue != null && ((CharSequence)actualValue).length() == 0;
    }

    private static final boolean IS_NOT_EMPTY$lambda$2(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String string = (String)actual.invoke((Object)actor);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        BlackBox.INSTANCE.logAssertion(actualValue, "a non-empty value");
        return ((CharSequence)actualValue).length() > 0;
    }

    private static final boolean CONTAINS$lambda$4(Actor actor, Function1<? super Actor, String> actual, List<? extends CharSequence> expectedList) {
        boolean bl;
        block4: {
            CommonPreconditions.INSTANCE.ensureActualAndExpectedNotNull(actual, expectedList);
            CommonPreconditions.INSTANCE.ensureNotEmpty("expected should not be null", (Collection<? extends Object>)expectedList);
            CommonPreconditions.INSTANCE.ensureNoNullElementsIn("actual should not contain null elements", (Collection<? extends Object>)expectedList);
            String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expectedList);
            if (string == null) {
                return false;
            }
            String actualValue = string;
            Iterable $this$all$iv = expectedList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CharSequence expectedItem = (CharSequence)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.contains$default((CharSequence)actualValue, (CharSequence)expectedItem, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean DOES_NOT_CONTAINS$lambda$6(Actor actor, Function1<? super Actor, String> actual, List<? extends CharSequence> expectedList) {
        boolean bl;
        block4: {
            CommonPreconditions.INSTANCE.ensureActualAndExpectedNotNull(actual, expectedList);
            CommonPreconditions.INSTANCE.ensureNotEmpty("expected should not be null", (Collection<? extends Object>)expectedList);
            CommonPreconditions.INSTANCE.ensureNoNullElementsIn("actual should not contain null elements", (Collection<? extends Object>)expectedList);
            String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expectedList);
            if (string == null) {
                return true;
            }
            String actualValue = string;
            Iterable $this$none$iv = expectedList;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    CharSequence expectedItem = (CharSequence)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)actualValue, (CharSequence)expectedItem, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean CONTAINS_IGNORING_CASE$lambda$8(Actor actor, Function1<? super Actor, String> actual, List<? extends CharSequence> expectedList) {
        boolean bl;
        block4: {
            CommonPreconditions.INSTANCE.ensureActualAndExpectedNotNull(actual, expectedList);
            CommonPreconditions.INSTANCE.ensureNotEmpty("expected should not be null", (Collection<? extends Object>)expectedList);
            CommonPreconditions.INSTANCE.ensureNoNullElementsIn("actual should not contain null elements", (Collection<? extends Object>)expectedList);
            String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expectedList);
            if (string == null) {
                return false;
            }
            String actualValue = string;
            Iterable $this$all$iv = expectedList;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    CharSequence expectedItem = (CharSequence)element$iv;
                    boolean bl2 = false;
                    String string2 = actualValue.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    CharSequence charSequence = string2;
                    String string3 = ((Object)expectedItem).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string3, (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean EQUALS_IGNORING_CASE$lambda$9(Actor actor, Function1<? super Actor, String> actual, CharSequence expected) {
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return expected.length() == 0;
        }
        String actualValue = string;
        String string2 = actualValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = ((Object)expected).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return Intrinsics.areEqual((Object)string2, (Object)string3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean IS_UPPER_CASE$lambda$10(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null) return false;
        if (actual == null) {
            return false;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "an uppercase value");
        if (actualValue == null) {
            return false;
        }
        if (((CharSequence)actualValue).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        String string = actualValue.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)actualValue)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean IS_LOWER_CASE$lambda$11(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null) return true;
        if (actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "a lowercase value");
        if (actualValue == null) {
            return false;
        }
        if (((CharSequence)actualValue).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        String string = actualValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)string, (Object)actualValue)) return false;
        return true;
    }

    private static final boolean BLANK$lambda$12(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "a blank value");
        if (actualValue == null) {
            return false;
        }
        return StringsKt.isBlank((CharSequence)actualValue);
    }

    private static final boolean NOT_BLANK$lambda$13(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "a non-blank value");
        if (actualValue == null) {
            return false;
        }
        return !StringsKt.isBlank((CharSequence)actualValue);
    }

    private static final boolean SUBSTRING_OF$lambda$14(Actor actor, Function1<? super Actor, String> actual, CharSequence expected) {
        CommonPreconditions.INSTANCE.ensureActualNotNull(actual);
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return StringsKt.contains$default((CharSequence)expected, (CharSequence)actualValue, (boolean)false, (int)2, null);
    }

    private static final boolean STARTS_WITH$lambda$15(Actor actor, Function1<? super Actor, String> actual, CharSequence expected) {
        CommonPreconditions.INSTANCE.ensureActualAndExpectedNotNull(actual, expected);
        String actualValue = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        BlackBox.INSTANCE.logAssertion(actualValue, expected);
        if (actualValue == null) {
            return false;
        }
        return StringsKt.startsWith$default((CharSequence)actualValue, (CharSequence)expected, (boolean)false, (int)2, null);
    }

    private static final boolean ENDS_WITH$lambda$16(Actor actor, Function1<? super Actor, String> actual, CharSequence expected) {
        CommonPreconditions.INSTANCE.ensureActualAndExpectedNotNull(actual, expected);
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return StringsKt.endsWith$default((CharSequence)actualValue, (CharSequence)expected, (boolean)false, (int)2, null);
    }

    private static final boolean MATCHES$lambda$17(Actor actor, Function1<? super Actor, String> actual, CharSequence expected) {
        CommonPreconditions.INSTANCE.ensureActualAndExpectedNotNull(actual, expected);
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        CharSequence charSequence = actualValue;
        return new Regex(((Object)expected).toString()).matches(charSequence);
    }

    private static final boolean MATCHES_PATTERN$lambda$18(Actor actor, Function1<? super Actor, String> actual, Pattern expected) {
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return expected.matcher(actualValue).matches();
    }

    private static final boolean CONTAINS_WHITESPACES$lambda$19(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "containing whitespaces");
        if (actualValue == null) {
            return false;
        }
        return ((CharSequence)actualValue).length() > 0 && actualValue.chars().anyMatch(Character::isWhitespace);
    }

    private static final boolean CONTAINS_ONLY_WHITESPACES$lambda$20(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "contains only whitespaces");
        if (actualValue == null) {
            return false;
        }
        return ((CharSequence)actualValue).length() > 0 && actualValue.chars().allMatch(Character::isWhitespace);
    }

    private static final boolean CONTAINS_NO_WHITESPACES$lambda$21(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "contains no whitespace");
        if (actualValue == null) {
            return false;
        }
        return actualValue.chars().noneMatch(Character::isWhitespace);
    }

    private static final boolean CONTAINS_ONLY_DIGITS$lambda$22(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "contains only digits");
        if (actualValue == null) {
            return false;
        }
        return ((CharSequence)actualValue).length() > 0 && actualValue.chars().allMatch(Character::isDigit);
    }

    private static final boolean CONTAINS_ONLY_LETTERS$lambda$23(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "contains only letters");
        if (actualValue == null) {
            return false;
        }
        return ((CharSequence)actualValue).length() > 0 && actualValue.chars().allMatch(Character::isLetter);
    }

    private static final boolean CONTAINS_ONLY_LETTERS_OR_DIGITS$lambda$24(Actor actor, Function1<? super Actor, String> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        String actualValue = (String)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "contains only letters or digits");
        if (actualValue == null) {
            return false;
        }
        return ((CharSequence)actualValue).length() > 0 && actualValue.chars().allMatch(Character::isLetterOrDigit);
    }

    private static final boolean HAS_SIZE$lambda$25(Actor actor, Function1<? super Actor, String> actual, int expected) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return actualValue.length() == expected;
    }

    private static final boolean HAS_SIZE_LESS_THAN$lambda$26(Actor actor, Function1<? super Actor, String> actual, int expected) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return actualValue.length() < expected;
    }

    private static final boolean HAS_SIZE_LESS_THAN_OR_EQUAL_TO$lambda$27(Actor actor, Function1<? super Actor, String> actual, int expected) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return actualValue.length() <= expected;
    }

    private static final boolean HAS_SIZE_GREATER_THAN$lambda$28(Actor actor, Function1<? super Actor, String> actual, int expected) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return actualValue.length() > expected;
    }

    private static final boolean HAS_SIZE_GREATER_THAN_OR_EQUAL_TO$lambda$29(Actor actor, Function1<? super Actor, String> actual, int expected) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return actualValue.length() >= expected;
    }

    private static final boolean HAS_SIZE_BETWEEN$lambda$30(Actor actor, Function1<? super Actor, String> actual, int startRange, int endRange) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, "of size between " + startRange + " and " + endRange);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        int n = actualValue.length();
        return startRange <= n ? n <= endRange : false;
    }

    private static final boolean HAS_LINE_COUNT$lambda$31(Actor actor, Function1<? super Actor, String> actual, int expected) {
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        LineNumberReader reader = new LineNumberReader(new StringReader(actualValue));
        try {
            while (reader.readLine() != null) {
            }
        }
        catch (IOException e) {
            StepEventBus.getEventBus().takeScreenshot();
            throw new AssertionError("Unable to count lines in " + actual, e);
        }
        return reader.getLineNumber() == expected;
    }

    private static final boolean HAS_SAME_SIZE$lambda$32(Actor actor, Function1<? super Actor, String> actual, CharSequence expected) {
        if (actual == null) {
            return false;
        }
        String string = StringEnsure.Companion.resolveActual((Function1<? super Actor, String>)actual, actor, expected);
        if (string == null) {
            return false;
        }
        String actualValue = string;
        return actualValue.length() == expected.length();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0016\u001a\u0004\u0018\u00010\b2\"\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0001H\u0002R?\u0010\u0004\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\r\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u000e\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u000f\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0014\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0015\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u0019\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u001a\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u001b\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u001c\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u001d\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u001e\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\u001f\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010 \u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010!\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\"\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010$\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010%\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010&\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010'\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010(\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010)\u001a3\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010*\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010,\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010-\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010.\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010/\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u00100\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(201X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u00103\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110+\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u00104\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\n\u0012\u0004\u0012\u00020\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0012\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lnet/serenitybdd/screenplay/ensure/StringEnsure$Companion;", "", "<init>", "()V", "NULL_OR_EMPTY", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "", "Lkotlin/ParameterName;", "name", "actual", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "IS_EMPTY", "IS_NOT_EMPTY", "CONTAINS", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "", "", "expected", "DOES_NOT_CONTAINS", "CONTAINS_IGNORING_CASE", "resolveActual", "actor", "expectedList", "EQUALS_IGNORING_CASE", "IS_UPPER_CASE", "IS_LOWER_CASE", "BLANK", "NOT_BLANK", "SUBSTRING_OF", "STARTS_WITH", "ENDS_WITH", "MATCHES", "MATCHES_PATTERN", "Ljava/util/regex/Pattern;", "CONTAINS_WHITESPACES", "CONTAINS_ONLY_WHITESPACES", "CONTAINS_NO_WHITESPACES", "CONTAINS_ONLY_DIGITS", "CONTAINS_ONLY_LETTERS", "CONTAINS_ONLY_LETTERS_OR_DIGITS", "HAS_SIZE", "", "HAS_SIZE_LESS_THAN", "HAS_SIZE_LESS_THAN_OR_EQUAL_TO", "HAS_SIZE_GREATER_THAN", "HAS_SIZE_GREATER_THAN_OR_EQUAL_TO", "HAS_SIZE_BETWEEN", "Lnet/serenitybdd/screenplay/ensure/DoubleValueExpectation;", "startRange", "HAS_LINE_COUNT", "HAS_SAME_SIZE", "serenity-ensure"})
    public static final class Companion {
        private Companion() {
        }

        private final String resolveActual(Function1<? super Actor, String> actual, Actor actor, Object expectedList) {
            Function1<? super Actor, String> function1 = actual;
            Intrinsics.checkNotNull(function1);
            Actor actor2 = actor;
            Intrinsics.checkNotNull((Object)actor2);
            String actualValue = (String)function1.invoke((Object)actor2);
            BlackBox.INSTANCE.logAssertion(actualValue, expectedList);
            return actualValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

