/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.time.LocalTime;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.CommonPreconditions;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018BA\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\fJ7\u0010\u000f\u001a+\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0002J7\u0010\u0014\u001a+\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016J \u0010\u0017\u001a\u00020\u00002\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\tH\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lnet/serenitybdd/screenplay/ensure/TimeEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "Ljava/time/LocalTime;", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;)V", "(Ljava/time/LocalTime;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isBefore", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "Lkotlin/ParameterName;", "name", "expected", "isAfter", "not", "silently", "usingComparator", "Companion", "serenity-ensure"})
public final class TimeEnsure
extends ComparableEnsure<LocalTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Actor, LocalTime> value;
    @NotNull
    private static final Expectation<Function1<Actor, LocalTime>, LocalTime> BEFORE = ExpectationKt.expectThatActualIs("before", TimeEnsure::BEFORE$lambda$0);
    @NotNull
    private static final Expectation<Function1<Actor, LocalTime>, LocalTime> AFTER = ExpectationKt.expectThatActualIs("after", TimeEnsure::AFTER$lambda$1);

    public TimeEnsure(@NotNull Function1<? super Actor, LocalTime> value, @NotNull Comparator<LocalTime> comparator) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        super(value, comparator, null, 4, null);
        this.value = value;
    }

    @Override
    @NotNull
    public Function1<Actor, LocalTime> getValue() {
        return this.value;
    }

    public TimeEnsure(@Nullable LocalTime value) {
        this((Function1<? super Actor, LocalTime>)new KnownValue<LocalTime>(value, String.valueOf(value)), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalTime>, LocalTime> isBefore(@NotNull LocalTime expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalTime>, LocalTime>(this.getValue(), BEFORE, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalTime>, LocalTime> isAfter(@NotNull LocalTime expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalTime>, LocalTime>(this.getValue(), AFTER, expected, this.isNegated(), null, null, 48, null);
    }

    @Override
    @NotNull
    public TimeEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        Intrinsics.checkNotNull(commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.TimeEnsure");
        return (TimeEnsure)commonEnsure;
    }

    @Override
    @NotNull
    public TimeEnsure silently() {
        CommonEnsure commonEnsure = super.silently();
        Intrinsics.checkNotNull((Object)commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.TimeEnsure");
        return (TimeEnsure)commonEnsure;
    }

    @NotNull
    public TimeEnsure usingComparator(@NotNull Comparator<LocalTime> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        return new TimeEnsure(this.getValue(), comparator);
    }

    private static final boolean BEFORE$lambda$0(Actor actor, Function1<? super Actor, LocalTime> actual, LocalTime expected) {
        CommonPreconditions.INSTANCE.ensureActualAndActorNotNull(actual, actor);
        Function1<? super Actor, LocalTime> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalTime localTime = (LocalTime)function1.invoke((Object)actor2);
        if (localTime == null) {
            return false;
        }
        LocalTime actualValue = localTime;
        return actualValue.isBefore(expected);
    }

    private static final boolean AFTER$lambda$1(Actor actor, Function1<? super Actor, LocalTime> actual, LocalTime expected) {
        CommonPreconditions.INSTANCE.ensureActualAndActorNotNull(actual, actor);
        Function1<? super Actor, LocalTime> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalTime localTime = (LocalTime)function1.invoke((Object)actor2);
        if (localTime == null) {
            return false;
        }
        LocalTime actualValue = localTime;
        return actualValue.isAfter(expected);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003RY\u0010\u0004\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRY\u0010\u0010\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lnet/serenitybdd/screenplay/ensure/TimeEnsure$Companion;", "", "<init>", "()V", "BEFORE", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Ljava/time/LocalTime;", "Lkotlin/ParameterName;", "name", "actual", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "expected", "getBEFORE", "()Lnet/serenitybdd/screenplay/ensure/Expectation;", "AFTER", "getAFTER", "serenity-ensure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalTime>, LocalTime> getBEFORE() {
            return BEFORE;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalTime>, LocalTime> getAFTER() {
            return AFTER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

