/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.CommonPreconditions;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fBA\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\fJC\u0010\u000f\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0002JC\u0010\u0014\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0002JC\u0010\u0015\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0016JC\u0010\u0017\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0018JC\u0010\u0019\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u001aJC\u0010\u001b\u001a7\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\u0000H\u0016J\b\u0010\u001d\u001a\u00020\u0000H\u0016J \u0010\u001e\u001a\u00020\u00002\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\tH\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lnet/serenitybdd/screenplay/ensure/DateEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "Ljava/time/LocalDate;", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;)V", "(Ljava/time/LocalDate;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isBefore", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "Lkotlin/ParameterName;", "name", "expected", "isAfter", "isDayOfWeek", "Ljava/time/DayOfWeek;", "isDayOfMonth", "", "isInTheMonthOf", "Ljava/time/Month;", "isTheYear", "not", "silently", "usingComparator", "Companion", "serenity-ensure"})
public final class DateEnsure
extends ComparableEnsure<LocalDate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Actor, LocalDate> value;
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, LocalDate> BEFORE = ExpectationKt.expectThatActualIs("before", DateEnsure::BEFORE$lambda$0);
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, LocalDate> AFTER = ExpectationKt.expectThatActualIs("after", DateEnsure::AFTER$lambda$1);
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, DayOfWeek> DAY_OF_WEEK = ExpectationKt.expectThatActualIs("on a", DateEnsure::DAY_OF_WEEK$lambda$2);
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, Integer> DAY_OF_MONTH = ExpectationKt.expectThatActualIs("on day of month", DateEnsure::DAY_OF_MONTH$lambda$3);
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, Month> MONTH = ExpectationKt.expectThatActualIs("in month", DateEnsure::MONTH$lambda$4);
    @NotNull
    private static final Expectation<Function1<Actor, LocalDate>, Integer> YEAR = ExpectationKt.expectThatActualIs("in the year", DateEnsure::YEAR$lambda$5);

    public DateEnsure(@NotNull Function1<? super Actor, LocalDate> value, @NotNull Comparator<LocalDate> comparator) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        super(value, comparator, null, 4, null);
        this.value = value;
    }

    @Override
    @NotNull
    public Function1<Actor, LocalDate> getValue() {
        return this.value;
    }

    public DateEnsure(@Nullable LocalDate value) {
        this((Function1<? super Actor, LocalDate>)new KnownValue<LocalDate>(value, String.valueOf(value)), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, LocalDate> isBefore(@NotNull LocalDate expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, LocalDate>(this.getValue(), BEFORE, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, LocalDate> isAfter(@NotNull LocalDate expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, LocalDate>(this.getValue(), AFTER, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, DayOfWeek> isDayOfWeek(@NotNull DayOfWeek expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, DayOfWeek>(this.getValue(), DAY_OF_WEEK, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, Integer> isDayOfMonth(int expected) {
        return new PerformableExpectation<Function1<Actor, LocalDate>, Integer>(this.getValue(), DAY_OF_MONTH, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, Month> isInTheMonthOf(@NotNull Month expected) {
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, LocalDate>, Month>(this.getValue(), MONTH, expected, this.isNegated(), null, null, 48, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, LocalDate>, Integer> isTheYear(int expected) {
        return new PerformableExpectation<Function1<Actor, LocalDate>, Integer>(this.getValue(), YEAR, expected, this.isNegated(), null, null, 48, null);
    }

    @Override
    @NotNull
    public DateEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        Intrinsics.checkNotNull(commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.DateEnsure");
        return (DateEnsure)commonEnsure;
    }

    @Override
    @NotNull
    public DateEnsure silently() {
        CommonEnsure commonEnsure = super.silently();
        Intrinsics.checkNotNull((Object)commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.DateEnsure");
        return (DateEnsure)commonEnsure;
    }

    @NotNull
    public DateEnsure usingComparator(@NotNull Comparator<LocalDate> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        return new DateEnsure(this.getValue(), comparator);
    }

    private static final boolean BEFORE$lambda$0(Actor actor, Function1<? super Actor, LocalDate> actual, LocalDate expected) {
        CommonPreconditions.INSTANCE.ensureActualAndActorNotNull(actual, actor);
        Function1<? super Actor, LocalDate> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalDate localDate = (LocalDate)function1.invoke((Object)actor2);
        if (localDate == null) {
            return false;
        }
        LocalDate actualValue = localDate;
        return actualValue.isBefore(expected);
    }

    private static final boolean AFTER$lambda$1(Actor actor, Function1<? super Actor, LocalDate> actual, LocalDate expected) {
        CommonPreconditions.INSTANCE.ensureActualAndActorNotNull(actual, actor);
        Function1<? super Actor, LocalDate> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalDate localDate = (LocalDate)function1.invoke((Object)actor2);
        if (localDate == null) {
            return false;
        }
        LocalDate actualValue = localDate;
        return actualValue.isAfter(expected);
    }

    private static final boolean DAY_OF_WEEK$lambda$2(Actor actor, Function1<? super Actor, LocalDate> actual, DayOfWeek expected) {
        CommonPreconditions.INSTANCE.ensureActualAndActorNotNull(actual, actor);
        Function1<? super Actor, LocalDate> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalDate localDate = (LocalDate)function1.invoke((Object)actor2);
        if (localDate == null) {
            return false;
        }
        LocalDate actualValue = localDate;
        return expected == actualValue.getDayOfWeek();
    }

    private static final boolean DAY_OF_MONTH$lambda$3(Actor actor, Function1<? super Actor, LocalDate> actual, int expected) {
        CommonPreconditions.INSTANCE.ensureActualNotNull(actual);
        Function1<? super Actor, LocalDate> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalDate localDate = (LocalDate)function1.invoke((Object)actor2);
        if (localDate == null) {
            return false;
        }
        LocalDate actualValue = localDate;
        return expected == actualValue.getDayOfMonth();
    }

    private static final boolean MONTH$lambda$4(Actor actor, Function1<? super Actor, LocalDate> actual, Month expected) {
        CommonPreconditions.INSTANCE.ensureActualNotNull(actual);
        Function1<? super Actor, LocalDate> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalDate localDate = (LocalDate)function1.invoke((Object)actor2);
        if (localDate == null) {
            return false;
        }
        LocalDate actualValue = localDate;
        return expected == actualValue.getMonth();
    }

    private static final boolean YEAR$lambda$5(Actor actor, Function1<? super Actor, LocalDate> actual, int expected) {
        CommonPreconditions.INSTANCE.ensureActualNotNull(actual);
        Function1<? super Actor, LocalDate> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        LocalDate localDate = (LocalDate)function1.invoke((Object)actor2);
        if (localDate == null) {
            return false;
        }
        LocalDate actualValue = localDate;
        return expected == actualValue.getYear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003RY\u0010\u0004\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRY\u0010\u0010\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fRY\u0010\u0012\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fRY\u0010\u0015\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fRY\u0010\u0018\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000fRY\u0010\u001b\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006j\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u0001`\f\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\r0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lnet/serenitybdd/screenplay/ensure/DateEnsure$Companion;", "", "<init>", "()V", "BEFORE", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Ljava/time/LocalDate;", "Lkotlin/ParameterName;", "name", "actual", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "expected", "getBEFORE", "()Lnet/serenitybdd/screenplay/ensure/Expectation;", "AFTER", "getAFTER", "DAY_OF_WEEK", "Ljava/time/DayOfWeek;", "getDAY_OF_WEEK", "DAY_OF_MONTH", "", "getDAY_OF_MONTH", "MONTH", "Ljava/time/Month;", "getMONTH", "YEAR", "getYEAR", "serenity-ensure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, LocalDate> getBEFORE() {
            return BEFORE;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, LocalDate> getAFTER() {
            return AFTER;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, DayOfWeek> getDAY_OF_WEEK() {
            return DAY_OF_WEEK;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, Integer> getDAY_OF_MONTH() {
            return DAY_OF_MONTH;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, Month> getMONTH() {
            return MONTH;
        }

        @NotNull
        public final Expectation<Function1<Actor, LocalDate>, Integer> getYEAR() {
            return YEAR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

