/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.BlackBox;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DescriptionOfKt;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformablePredicate;
import net.serenitybdd.screenplay.ensure.PredicateExpectation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BK\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB+\b\u0016\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u00a2\u0006\u0004\b\f\u0010\u000eB3\b\u0016\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\u0010B\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\f\u0010\u0011J*\u0010\u0014\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u0001`\u00060\u0015J*\u0010\u0016\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u0001`\u00060\u0015J\b\u0010\u0017\u001a\u00020\u0000H\u0016R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013RD\u0010\u0018\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u0001`\u0006\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eRD\u0010\u001f\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u0001`\u0006\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001e\u00a8\u0006!"}, d2={"Lnet/serenitybdd/screenplay/ensure/BooleanEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "expectedDescription", "", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;Ljava/lang/String;)V", "(Lkotlin/jvm/functions/Function1;)V", "valueDescription", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "(Ljava/lang/Boolean;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isTrue", "Lnet/serenitybdd/screenplay/ensure/PerformablePredicate;", "isFalse", "not", "IS_TRUE", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "Lkotlin/ParameterName;", "name", "actual", "getIS_TRUE", "()Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "IS_FALSE", "getIS_FALSE", "serenity-ensure"})
public final class BooleanEnsure
extends ComparableEnsure<Boolean> {
    @NotNull
    private final Function1<Actor, Boolean> value;
    @NotNull
    private final PredicateExpectation<Function1<Actor, Boolean>> IS_TRUE;
    @NotNull
    private final PredicateExpectation<Function1<Actor, Boolean>> IS_FALSE;

    public BooleanEnsure(@NotNull Function1<? super Actor, Boolean> value, @NotNull Comparator<Boolean> comparator, @NotNull String expectedDescription) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        Intrinsics.checkNotNullParameter((Object)expectedDescription, (String)"expectedDescription");
        super(value, comparator, expectedDescription);
        this.value = value;
        this.IS_TRUE = ExpectationKt.expectThatActualIs("true", BooleanEnsure::IS_TRUE$lambda$0);
        this.IS_FALSE = ExpectationKt.expectThatActualIs("false", BooleanEnsure::IS_FALSE$lambda$0);
    }

    public /* synthetic */ BooleanEnsure(Function1 function1, Comparator comparator, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = DescriptionOfKt.descriptionOf(function1);
        }
        this((Function1<? super Actor, Boolean>)function1, comparator, string);
    }

    @Override
    @NotNull
    public Function1<Actor, Boolean> getValue() {
        return this.value;
    }

    public BooleanEnsure(@NotNull Function1<? super Actor, Boolean> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        this(value, comparator, null, 4, null);
    }

    public BooleanEnsure(@NotNull Function1<? super Actor, Boolean> value, @NotNull String valueDescription) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)valueDescription, (String)"valueDescription");
        Comparator<Boolean> comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        this(value, comparator, valueDescription);
    }

    public BooleanEnsure(@Nullable Boolean value) {
        Boolean bl = value;
        Function1 function1 = new KnownValue<Boolean>(value, (String)(bl == null ? "<null>" : "\"" + bl + "\""));
        Comparator comparator = Comparator.naturalOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"naturalOrder(...)");
        this(function1, comparator, null, 4, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, Boolean>> isTrue() {
        return new PerformablePredicate<Function1<Actor, Boolean>>(this.getValue(), this.IS_TRUE, this.isNegated(), DescriptionOfKt.descriptionOf(this.getValue()), null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, Boolean>> isFalse() {
        return new PerformablePredicate<Function1<Actor, Boolean>>(this.getValue(), this.IS_FALSE, this.isNegated(), DescriptionOfKt.descriptionOf(this.getValue()), null, 16, null);
    }

    @Override
    @NotNull
    public BooleanEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        Intrinsics.checkNotNull(commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.BooleanEnsure");
        return (BooleanEnsure)commonEnsure;
    }

    @NotNull
    public final PredicateExpectation<Function1<Actor, Boolean>> getIS_TRUE() {
        return this.IS_TRUE;
    }

    @NotNull
    public final PredicateExpectation<Function1<Actor, Boolean>> getIS_FALSE() {
        return this.IS_FALSE;
    }

    private static final boolean IS_TRUE$lambda$0(Actor actor, Function1<? super Actor, Boolean> actual) {
        if (actual == null || actor == null) {
            return false;
        }
        Boolean resolvedValue = (Boolean)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(resolvedValue, "true");
        Boolean bl = resolvedValue;
        return bl != null ? bl : false;
    }

    private static final boolean IS_FALSE$lambda$0(Actor actor, Function1<? super Actor, Boolean> actual) {
        if (actual == null || actor == null) {
            return true;
        }
        Boolean resolvedValue = (Boolean)actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(resolvedValue, "false");
        Boolean bl = resolvedValue;
        return bl == null ? true : bl == false;
    }
}

