/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.ensure.BlackBox;
import net.serenitybdd.screenplay.ensure.BooleanEnsure;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.DateEnsure;
import net.serenitybdd.screenplay.ensure.DescriptionOfKt;
import net.serenitybdd.screenplay.ensure.DoubleEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.FloatEnsure;
import net.serenitybdd.screenplay.ensure.KnowableBigDecimalValue;
import net.serenitybdd.screenplay.ensure.KnowableBooleanValue;
import net.serenitybdd.screenplay.ensure.KnowableDoubleValue;
import net.serenitybdd.screenplay.ensure.KnowableFloatValue;
import net.serenitybdd.screenplay.ensure.KnowableIntValue;
import net.serenitybdd.screenplay.ensure.KnowableLocalDateValue;
import net.serenitybdd.screenplay.ensure.KnowableLocalTimeValue;
import net.serenitybdd.screenplay.ensure.KnowableStringValue;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import net.serenitybdd.screenplay.ensure.PerformablePredicate;
import net.serenitybdd.screenplay.ensure.PredicateExpectation;
import net.serenitybdd.screenplay.ensure.StringEnsure;
import net.serenitybdd.screenplay.ensure.TimeEnsure;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B1\u0012\u001e\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\fJ>\u0010\u0011\u001a+\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150\u00122\u0006\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016J>\u0010\u0017\u001a+\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150\u00122\u0006\u0010\u0015\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00050\u0019H\u0016J\u001a\u0010\u001a\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00050\u0019JN\u0010\u001b\u001a1\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150\u00122\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001d\"\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJC\u0010\u001b\u001a1\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fJN\u0010 \u001a1\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150\u00122\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u001d\"\u00028\u0000\u00a2\u0006\u0002\u0010\u001eJC\u0010 \u001a1\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fJ$\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\t2\u0014\u0010\u0015\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020$0\u0005J\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000J\u0014\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\u0006\u0010(\u001a\u00020$J\b\u0010.\u001a\u00020$H\u0016J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\u0006\u00100\u001a\u000201J\f\u00102\u001a\b\u0012\u0004\u0012\u00020403J\u0006\u00105\u001a\u000206J\u0006\u00107\u001a\u000208J\u0014\u00109\u001a\u0010\u0012\f\u0012\n ;*\u0004\u0018\u00010:0:03J\u0006\u0010<\u001a\u00020=J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\tJ\u0006\u0010?\u001a\u00020@J\u000e\u0010?\u001a\u00020@2\u0006\u0010>\u001a\u00020\tJ\u0006\u0010A\u001a\u00020BJd\u0010L\u001aV\u0012/\u0012-\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E\u0012!\u0012\u001f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020$0\u0005\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150D2\u0006\u0010#\u001a\u00020\tH\u0002R,\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0005j\b\u0012\u0004\u0012\u00028\u0000`\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010%\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-RT\u0010C\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150DX\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010F\u001aH\u0012/\u0012-\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E\u0012\u0013\u0012\u00118\u0001\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150DX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010G\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010I\u001a5\u00121\u0012/\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010J\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150DX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010K\u001aN\u0012/\u0012-\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u0005j\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0007\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(E\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u00150DX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lnet/serenitybdd/screenplay/ensure/CommonEnsure;", "A", "E", "Lnet/serenitybdd/markers/CanBeSilent;", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "expectedDescription", "", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "(Ljava/lang/Object;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "getExpectedDescription", "()Ljava/lang/String;", "isEqualTo", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "Lkotlin/ParameterName;", "name", "expected", "(Ljava/lang/Object;)Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "isNotEqualTo", "isNull", "Lnet/serenitybdd/screenplay/ensure/PerformablePredicate;", "isNotNull", "isIn", "", "", "([Ljava/lang/Object;)Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "", "isNotIn", "matches", "Lnet/serenitybdd/screenplay/Performable;", "description", "", "negated", "negate", "not", "isNegated", "silent", "getSilent", "()Z", "setSilent", "(Z)V", "isSilent", "silently", "asAString", "Lnet/serenitybdd/screenplay/ensure/StringEnsure;", "asAnInteger", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "", "asADouble", "Lnet/serenitybdd/screenplay/ensure/DoubleEnsure;", "asAFloat", "Lnet/serenitybdd/screenplay/ensure/FloatEnsure;", "asABigDecimal", "Ljava/math/BigDecimal;", "kotlin.jvm.PlatformType", "asADate", "Lnet/serenitybdd/screenplay/ensure/DateEnsure;", "format", "asATime", "Lnet/serenitybdd/screenplay/ensure/TimeEnsure;", "asABoolean", "Lnet/serenitybdd/screenplay/ensure/BooleanEnsure;", "IS_EQUAL_TO", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "actual", "IS_NOT_EQUAL_TO", "IS_NULL", "Lnet/serenitybdd/screenplay/ensure/PredicateExpectation;", "IS_NOT_NULL", "IS_IN", "IS_NOT_IN", "matchesPredicate", "serenity-ensure"})
public class CommonEnsure<A, E>
implements CanBeSilent {
    @NotNull
    private final Function1<Actor, A> value;
    @NotNull
    private final String expectedDescription;
    private boolean negated;
    private boolean silent;
    @NotNull
    private final Expectation<Function1<Actor, A>, E> IS_EQUAL_TO;
    @NotNull
    private final Expectation<Function1<Actor, A>, E> IS_NOT_EQUAL_TO;
    @NotNull
    private final PredicateExpectation<Function1<Actor, A>> IS_NULL;
    @NotNull
    private final PredicateExpectation<Function1<Actor, A>> IS_NOT_NULL;
    @NotNull
    private final Expectation<Function1<Actor, A>, List<A>> IS_IN;
    @NotNull
    private final Expectation<Function1<Actor, A>, List<A>> IS_NOT_IN;

    public CommonEnsure(@NotNull Function1<? super Actor, ? extends A> value, @NotNull String expectedDescription) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)expectedDescription, (String)"expectedDescription");
        this.value = value;
        this.expectedDescription = expectedDescription;
        this.IS_EQUAL_TO = ExpectationKt.expectThatActualIs("equal to", CommonEnsure::IS_EQUAL_TO$lambda$0);
        this.IS_NOT_EQUAL_TO = ExpectationKt.expectThatActualIs("not equal to", CommonEnsure::IS_NOT_EQUAL_TO$lambda$0);
        this.IS_NULL = ExpectationKt.expectThatActualIs("null", CommonEnsure::IS_NULL$lambda$0);
        this.IS_NOT_NULL = ExpectationKt.expectThatActualIs("not null", CommonEnsure::IS_NOT_NULL$lambda$0);
        this.IS_IN = ExpectationKt.expectThatActualIs("in", CommonEnsure::IS_IN$lambda$0);
        this.IS_NOT_IN = ExpectationKt.expectThatActualIs("not in", CommonEnsure::IS_NOT_IN$lambda$0);
    }

    public /* synthetic */ CommonEnsure(Function1 function1, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = DescriptionOfKt.descriptionOf(arg_0 -> CommonEnsure._init_$lambda$0(function1, arg_0));
        }
        this(function1, string);
    }

    @NotNull
    public Function1<Actor, A> getValue() {
        return this.value;
    }

    @NotNull
    public final String getExpectedDescription() {
        return this.expectedDescription;
    }

    public CommonEnsure(A value) {
        this(new KnownValue<A>(value, String.valueOf(value)), null, 2, null);
    }

    @NotNull
    public PerformableExpectation<Function1<Actor, A>, E> isEqualTo(E expected) {
        return new PerformableExpectation(this.getValue(), this.IS_EQUAL_TO, expected, this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public PerformableExpectation<Function1<Actor, A>, E> isNotEqualTo(E expected) {
        return new PerformableExpectation(this.getValue(), this.IS_NOT_EQUAL_TO, expected, this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public PerformablePredicate<Function1<Actor, A>> isNull() {
        return new PerformablePredicate<Function1<Actor, A>>(this.getValue(), this.IS_NULL, this.isNegated(), this.expectedDescription, null, 16, null);
    }

    @NotNull
    public final PerformablePredicate<Function1<Actor, A>> isNotNull() {
        return new PerformablePredicate<Function1<Actor, A>>(this.getValue(), this.IS_NOT_NULL, this.isNegated(), this.expectedDescription, null, 16, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isIn(A ... expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_IN, ArraysKt.toList((Object[])expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isIn(@NotNull Collection<? extends A> expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_IN, CollectionsKt.toList((Iterable)expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isNotIn(A ... expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_NOT_IN, ArraysKt.toList((Object[])expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, A>, List<A>> isNotIn(@NotNull Collection<? extends A> expected) {
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation<Function1<Actor, A>, List<A>>(this.getValue(), this.IS_NOT_IN, CollectionsKt.toList((Iterable)expected), this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final Performable matches(@NotNull String description, @NotNull Function1<? super A, Boolean> expected) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        return new PerformableExpectation(this.getValue(), this.matchesPredicate(description), expected, this.isNegated(), this.expectedDescription, null, 32, null);
    }

    @NotNull
    public final CommonEnsure<A, E> negate() {
        this.negated = !this.negated;
        return this;
    }

    @NotNull
    public CommonEnsure<A, E> not() {
        return this.negate();
    }

    public final boolean isNegated() {
        return this.negated;
    }

    public final boolean getSilent() {
        return this.silent;
    }

    public final void setSilent(boolean bl) {
        this.silent = bl;
    }

    public boolean isSilent() {
        return this.silent;
    }

    @NotNull
    public CommonEnsure<A, E> silently() {
        this.silent = true;
        return this;
    }

    @NotNull
    public final StringEnsure asAString() {
        return new StringEnsure((Function1<? super Actor, String>)new KnowableStringValue<A>(this.getValue(), this.expectedDescription), this.expectedDescription);
    }

    @NotNull
    public final ComparableEnsure<Integer> asAnInteger() {
        return new ComparableEnsure<Integer>((Function1)new KnowableIntValue<A>(this.getValue(), this.expectedDescription), null, this.expectedDescription);
    }

    @NotNull
    public final DoubleEnsure asADouble() {
        return DoubleEnsure.Companion.fromKnowable((Function1<? super Actor, Double>)new KnowableDoubleValue<A>(this.getValue(), this.expectedDescription));
    }

    @NotNull
    public final FloatEnsure asAFloat() {
        return FloatEnsure.Companion.fromKnowable((Function1<? super Actor, Float>)new KnowableFloatValue<A>(this.getValue(), this.expectedDescription));
    }

    @NotNull
    public final ComparableEnsure<BigDecimal> asABigDecimal() {
        return new ComparableEnsure<BigDecimal>((Function1)new KnowableBigDecimalValue<A>(this.getValue(), this.expectedDescription), null, this.expectedDescription);
    }

    @NotNull
    public final DateEnsure asADate() {
        return new DateEnsure(new KnowableLocalDateValue(this.getValue(), this.expectedDescription, null, 4, null), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final DateEnsure asADate(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new DateEnsure((Function1<? super Actor, LocalDate>)new KnowableLocalDateValue<A>(this.getValue(), this.expectedDescription, format), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final TimeEnsure asATime() {
        return new TimeEnsure(new KnowableLocalTimeValue(this.getValue(), this.expectedDescription, null, 4, null), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final TimeEnsure asATime(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return new TimeEnsure((Function1<? super Actor, LocalTime>)new KnowableLocalTimeValue<A>(this.getValue(), this.expectedDescription, format), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final BooleanEnsure asABoolean() {
        return new BooleanEnsure((Function1<? super Actor, Boolean>)new KnowableBooleanValue<A>(this.getValue(), this.expectedDescription));
    }

    private final Expectation<Function1<Actor, A>, Function1<A, Boolean>> matchesPredicate(String description) {
        return ExpectationKt.expectThatActualIs("a match for", CommonEnsure::matchesPredicate$lambda$0, description);
    }

    private static final Function1 _init_$lambda$0(Function1 $value, Actor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $value;
    }

    private static final <A, E> boolean IS_EQUAL_TO$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual, E expected) {
        if (actor == null || actual == null) {
            return false;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, expected);
        return Intrinsics.areEqual((Object)actual.invoke((Object)actor), expected);
    }

    private static final <A, E> boolean IS_NOT_EQUAL_TO$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual, E expected) {
        if (actor == null || actual == null) {
            return false;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, expected);
        return !Intrinsics.areEqual((Object)actual.invoke((Object)actor), expected);
    }

    private static final <A> boolean IS_NULL$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual) {
        if (actor == null || actual == null) {
            return true;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, null);
        return actualValue == null;
    }

    private static final <A> boolean IS_NOT_NULL$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual) {
        if (actor == null || actual == null) {
            return false;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, "not null");
        return actualValue != null;
    }

    private static final <A> boolean IS_IN$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual, List<? extends A> expected) {
        if (actor == null || actual == null) {
            return false;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, expected);
        return CollectionsKt.contains((Iterable)expected, (Object)actualValue);
    }

    private static final <A> boolean IS_NOT_IN$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual, List<? extends A> expected) {
        if (actor == null || actual == null) {
            return false;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, expected);
        return !CollectionsKt.contains((Iterable)expected, (Object)actualValue);
    }

    private static final <A> boolean matchesPredicate$lambda$0(Actor actor, Function1<? super Actor, ? extends A> actual, Function1<? super A, Boolean> expected) {
        if (actor == null || actual == null) {
            return false;
        }
        Object actualValue = actual.invoke((Object)actor);
        BlackBox.INSTANCE.logAssertion(actualValue, null);
        return (Boolean)expected.invoke(actualValue);
    }
}

