/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ensure;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.ensure.CommonEnsure;
import net.serenitybdd.screenplay.ensure.CommonPreconditions;
import net.serenitybdd.screenplay.ensure.ComparableEnsure;
import net.serenitybdd.screenplay.ensure.Expectation;
import net.serenitybdd.screenplay.ensure.ExpectationKt;
import net.serenitybdd.screenplay.ensure.KnownValue;
import net.serenitybdd.screenplay.ensure.PerformableExpectation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aBA\u0012 \u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00020\bj\b\u0012\u0004\u0012\u00020\u0002`\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0013\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\fJ?\u0010\u000f\u001a+\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00102\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\b\u0010\u0016\u001a\u00020\u0000H\u0016JX\u0010\u0017\u001aJ\u00121\u0012/\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004j\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u0001`\u0006\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u00130\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0002R.\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lnet/serenitybdd/screenplay/ensure/FloatEnsure;", "Lnet/serenitybdd/screenplay/ensure/ComparableEnsure;", "", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;)V", "(Ljava/lang/Float;)V", "getValue", "()Lkotlin/jvm/functions/Function1;", "isCloseTo", "Lnet/serenitybdd/screenplay/ensure/PerformableExpectation;", "Lkotlin/ParameterName;", "name", "expected", "margin", "not", "silently", "within", "Lnet/serenitybdd/screenplay/ensure/Expectation;", "actual", "Companion", "serenity-ensure"})
public final class FloatEnsure
extends ComparableEnsure<Float> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<Actor, Float> value;

    public FloatEnsure(@NotNull Function1<? super Actor, Float> value, @NotNull Comparator<Float> comparator) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        super(value, comparator, null, 4, null);
        this.value = value;
    }

    @Override
    @NotNull
    public Function1<Actor, Float> getValue() {
        return this.value;
    }

    public FloatEnsure(@Nullable Float value) {
        this((Function1<? super Actor, Float>)new KnownValue<Float>(value, String.valueOf(value)), ComparisonsKt.naturalOrder());
    }

    @NotNull
    public final PerformableExpectation<Function1<Actor, Float>, Float> isCloseTo(float expected, float margin) {
        return new PerformableExpectation<Function1<Actor, Float>, Float>(this.getValue(), this.within(margin), Float.valueOf(expected), this.isNegated(), null, null, 48, null);
    }

    @Override
    @NotNull
    public FloatEnsure not() {
        CommonEnsure commonEnsure = this.negate();
        Intrinsics.checkNotNull(commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.FloatEnsure");
        return (FloatEnsure)commonEnsure;
    }

    @Override
    @NotNull
    public FloatEnsure silently() {
        CommonEnsure commonEnsure = super.silently();
        Intrinsics.checkNotNull((Object)commonEnsure, (String)"null cannot be cast to non-null type net.serenitybdd.screenplay.ensure.FloatEnsure");
        return (FloatEnsure)commonEnsure;
    }

    private final Expectation<Function1<Actor, Float>, Float> within(float margin) {
        return ExpectationKt.expectThatActualIs("close to (within a margin of " + margin + ")", (arg_0, arg_1, arg_2) -> FloatEnsure.within$lambda$0(margin, arg_0, arg_1, arg_2));
    }

    private static final boolean within$lambda$0(float $margin, Actor actor, Function1<? super Actor, Float> actual, float expected) {
        CommonPreconditions.INSTANCE.ensureActualNotNull(actual);
        Function1<? super Actor, Float> function1 = actual;
        Intrinsics.checkNotNull(function1);
        Actor actor2 = actor;
        Intrinsics.checkNotNull((Object)actor2);
        Float f = (Float)function1.invoke((Object)actor2);
        if (f == null) {
            return false;
        }
        float actualValue = f.floatValue();
        return actualValue >= expected - $margin && actualValue <= expected + $margin;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052 \u0010\u0006\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007j\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\n\u00a8\u0006\u000b"}, d2={"Lnet/serenitybdd/screenplay/ensure/FloatEnsure$Companion;", "", "<init>", "()V", "fromKnowable", "Lnet/serenitybdd/screenplay/ensure/FloatEnsure;", "value", "Lkotlin/Function1;", "Lnet/serenitybdd/screenplay/Actor;", "", "Lnet/serenitybdd/screenplay/ensure/KnowableValue;", "serenity-ensure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FloatEnsure fromKnowable(@NotNull Function1<? super Actor, Float> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return new FloatEnsure(value, ComparisonsKt.naturalOrder());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

