/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.embedders.monitors;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import net.serenitybdd.jbehave.SerenityReporter;
import net.serenitybdd.jbehave.embedders.ExtendedEmbedder;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportingEmbedderMonitor
implements EmbedderMonitor {
    private static final Logger logger = LoggerFactory.getLogger(ReportingEmbedderMonitor.class);
    private SerenityReporter reporter;
    private ExtendedEmbedder embedder;
    private final Configuration configuration;
    private final Set<String> processedStories = Collections.newSetFromMap(new ConcurrentHashMap());

    public ReportingEmbedderMonitor(ExtendedEmbedder embedder) {
        this(ReportingEmbedderMonitor.configuration(), embedder);
    }

    public ReportingEmbedderMonitor(Configuration configuration, ExtendedEmbedder embedder) {
        this.configuration = configuration;
        this.embedder = embedder;
    }

    public void runningEmbeddable(String name) {
    }

    public void embeddableFailed(String name, Throwable cause) {
    }

    public void embeddableNotConfigurable(String name) {
    }

    public void embeddablesSkipped(List<String> classNames) {
    }

    public void metaNotAllowed(Meta meta, MetaFilter filter) {
    }

    public void storyFailed(String path, Throwable cause) {
    }

    public void storiesSkipped(List<String> storyPaths) {
    }

    public void scenarioNotAllowed(Scenario scenario, MetaFilter filter) {
    }

    public void batchFailed(BatchFailures failures) {
    }

    public void beforeOrAfterStoriesFailed() {
    }

    public void generatingReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
    }

    public void reportsViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
    }

    public void reportsViewGenerated(ReportsCount count) {
    }

    public void reportsViewFailures(ReportsCount count) {
    }

    public void reportsViewNotGenerated() {
    }

    public void runningWithAnnotatedEmbedderRunner(String className) {
    }

    public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
    }

    public void mappingStory(String storyPath, List<String> metaFilters) {
    }

    public void generatingMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
    }

    public void mapsViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewProperties, Throwable cause) {
    }

    public void generatingNavigatorView(File outputDirectory, Properties viewResources) {
    }

    public void navigatorViewGenerationFailed(File outputDirectory, Properties viewResources, Throwable cause) {
    }

    public void navigatorViewNotGenerated() {
    }

    public void processingSystemProperties(Properties properties) {
    }

    public void systemPropertySet(String name, String value) {
    }

    public void storyTimeout(Story story, StoryDuration storyDuration) {
    }

    public void usingThreads(int threads) {
    }

    public void usingExecutorService(ExecutorService executorService) {
    }

    public void usingControls(EmbedderControls embedderControls) {
    }

    public void invalidTimeoutFormat(String path) {
    }

    public void usingTimeout(String path, long timeout) {
    }

    public void runningStory(String path) {
        logger.info(this.hashCode() + "story running with path " + path);
        Story story = this.embedder.findStory(path);
        if (story == null) {
            logger.error("can not find any story by path " + path);
        } else {
            this.includeInReportSkippedAndIgnoredAndWip(story);
        }
    }

    public void storiesNotAllowed(List<Story> notAllowed, MetaFilter filter) {
        logger.debug("processing stories Not Allowed " + notAllowed);
        for (Story story : notAllowed) {
            this.includeInReportSkippedAndIgnoredAndWip(story);
        }
    }

    public void storiesNotAllowed(List<Story> notAllowed, MetaFilter filter, boolean verbose) {
        logger.debug("processing stories Not Allowed " + notAllowed);
        for (Story story : notAllowed) {
            this.includeInReportSkippedAndIgnoredAndWip(story);
        }
    }

    private void includeInReportSkippedAndIgnoredAndWip(Story story) {
        SerenityReporter reporter = this.reporter();
        this.processedStories.addAll(reporter.processExcludedByFilter(story, this.processedStories));
    }

    public synchronized SerenityReporter reporter() {
        if (this.reporter == null) {
            this.reporter = new SerenityReporter(this.configuration);
        }
        return this.reporter;
    }

    private static Configuration configuration() {
        Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        EnvironmentVariables variables = ((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()).copy();
        if (variables != null) {
            configuration = configuration.withEnvironmentVariables(variables);
        }
        return configuration;
    }
}

