/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.di.DependencyInjector;
import net.serenitybdd.jbehave.ClassFinder;
import net.serenitybdd.jbehave.SerenityCandidateSteps;
import net.serenitybdd.jbehave.SerenityStepContext;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.di.DependencyInjectorService;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityStepFactory
extends AbstractStepsFactory {
    private static final ThreadLocal<SerenityStepContext> context = new ThreadLocal();
    private static final Logger logger = LoggerFactory.getLogger(SerenityStepFactory.class);
    private final String rootPackage;
    private ClassLoader classLoader;
    private DependencyInjectorService dependencyInjectorService;

    public SerenityStepFactory(Configuration configuration, String rootPackage, ClassLoader classLoader) {
        super(configuration);
        this.rootPackage = rootPackage;
        this.classLoader = classLoader;
        this.dependencyInjectorService = (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    private StepFactory getStepFactory() {
        return ThucydidesWebDriverSupport.getStepFactory();
    }

    public List<CandidateSteps> createCandidateSteps() {
        return super.createCandidateSteps().stream().map(SerenityCandidateSteps::new).collect(Collectors.toList());
    }

    protected List<Class<?>> stepsTypes() {
        ArrayList types = new ArrayList();
        for (Class candidateClass : this.getCandidateClasses()) {
            if (!this.hasAnnotatedMethods(candidateClass)) continue;
            types.add(candidateClass);
        }
        return types;
    }

    private List<Class> getCandidateClasses() {
        List<Class<?>> allClassesUnderRootPackage = ClassFinder.loadClasses().withClassLoader(this.classLoader).fromPackage(this.rootPackage);
        ArrayList candidateClasses = Lists.newArrayList();
        for (Class<?> classUnderRootPackage : allClassesUnderRootPackage) {
            if (!this.hasAnnotatedMethods(classUnderRootPackage)) continue;
            candidateClasses.add(classUnderRootPackage);
        }
        return candidateClasses;
    }

    public Object createInstanceOfType(Class<?> type) {
        Object stepsInstance = this.getContext().newInstanceOf(type);
        StepAnnotations.injectScenarioStepsInto((Object)stepsInstance, (StepFactory)this.getStepFactory());
        ThucydidesWebDriverSupport.initializeFieldsIn((Object)stepsInstance);
        this.injectDependencies(stepsInstance);
        return stepsInstance;
    }

    private void injectDependencies(Object stepInstance) {
        List dependencyInjectors = this.dependencyInjectorService.findDependencyInjectors();
        dependencyInjectors.add(new PageObjectDependencyInjector(ThucydidesWebDriverSupport.getPages()));
        for (DependencyInjector injector : dependencyInjectors) {
            injector.injectDependenciesInto(stepInstance);
        }
    }

    public SerenityStepContext getContext() {
        if (context.get() == null) {
            context.set(new SerenityStepContext());
        }
        return context.get();
    }

    public static void resetContext() {
        context.remove();
    }

    public static SerenityStepFactory withStepsFromPackage(String rootPackage, Configuration configuration) {
        return new SerenityStepFactory(configuration, rootPackage, SerenityStepFactory.defaultClassLoader());
    }

    private static ClassLoader defaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public SerenityStepFactory andConfiguration(Configuration configuration) {
        return new SerenityStepFactory(configuration, this.rootPackage, this.classLoader);
    }

    public InjectableStepsFactory andClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }
}

