/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class ClassFinder {
    private final ClassLoader classLoader;
    private List<Class<? extends Annotation>> expectedAnnotations;

    public ClassFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public static ClassFinder loadClasses() {
        return new ClassFinder(ClassFinder.getDefaultClassLoader());
    }

    public ClassFinder withClassLoader(ClassLoader classLoader) {
        return new ClassFinder(classLoader);
    }

    public List<Class<?>> fromPackage(String packageName) {
        if (this.expectedAnnotations == null) {
            return this.allClassesInPackage(packageName);
        }
        return this.annotatedClassesInPackage(packageName);
    }

    private List<Class<?>> allClassesInPackage(String packageName) {
        try {
            String path = packageName.replace('.', '/');
            if (packageName.isEmpty()) {
                packageName = "/";
            }
            Enumeration<URL> resources = this.classResourcesOn(path);
            ArrayList<URI> dirs = new ArrayList<URI>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(resource.toURI());
            }
            ArrayList classes = Lists.newArrayList();
            for (URI directory : dirs) {
                classes.addAll(this.findClasses(directory, packageName));
            }
            return classes;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to find all classes in package [" + packageName + "]", e);
        }
    }

    public ClassFinder annotatedWith(Class<? extends Annotation> ... someAnnotations) {
        this.expectedAnnotations = ImmutableList.copyOf((Object[])someAnnotations);
        return this;
    }

    public List<Class<?>> annotatedClassesInPackage(String packageName) {
        Reflections reflections = new Reflections(new Object[]{packageName, new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new ResourcesScanner(), this.getClassLoader()});
        HashSet matchingClasses = Sets.newHashSet();
        for (Class<? extends Annotation> expectedAnnotation : this.expectedAnnotations) {
            matchingClasses.addAll(reflections.getTypesAnnotatedWith(expectedAnnotation));
            matchingClasses.addAll(this.classesFrom(reflections.getMethodsAnnotatedWith(expectedAnnotation)));
        }
        return ImmutableList.copyOf((Collection)matchingClasses);
    }

    private Collection<Class<?>> classesFrom(Set<Method> annotatedMethods) {
        return annotatedMethods.stream().map(Method::getDeclaringClass).collect(Collectors.toList());
    }

    private Enumeration<URL> classResourcesOn(String path) {
        try {
            return this.getClassLoader().getResources(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not access class path at " + path, e);
        }
    }

    private List<Class<?>> findClasses(URI directory, String packageName) {
        try {
            String scheme = directory.getScheme();
            String schemeSpecificPart = directory.getSchemeSpecificPart();
            if (scheme.equals("jar") && schemeSpecificPart.contains("!")) {
                return this.findClassesInJar(directory, packageName);
            }
            if (scheme.equals("file")) {
                return this.findClassesInFileSystemDirectory(directory, packageName);
            }
            throw new IllegalArgumentException("cannot handle URI with scheme [" + scheme + "]");
        }
        catch (Exception e) {
            throw new RuntimeException("failed to find classesin directory=[" + directory + "], with packageName=[" + packageName + "]", e);
        }
    }

    private List<Class<?>> findClassesInJar(URI jarDirectory, String packageName) throws IOException {
        String schemeSpecificPart = jarDirectory.getSchemeSpecificPart();
        ArrayList classes = Lists.newArrayList();
        String[] split = schemeSpecificPart.split("!");
        URL jar = new URL(split[0]);
        try (ZipInputStream zip = new ZipInputStream(jar.openStream());){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                String className;
                if (!entry.getName().endsWith(".class") || !(className = ClassFinder.classNameFor(entry)).startsWith(packageName) || !this.isNotAnInnerClass(className)) continue;
                classes.addAll(this.loadClassWithName(className).asSet());
            }
        }
        return classes;
    }

    private List<Class<?>> findClassesInFileSystemDirectory(URI jarDirectory, String packageName) {
        ArrayList classes = Lists.newArrayList();
        File directory = new File(jarDirectory);
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    classes.addAll(this.findClasses(file.toURI(), packageName + "." + file.getName()));
                    continue;
                }
                if (!file.getName().endsWith(".class") || !this.isNotAnInnerClass(file.getName())) continue;
                classes.addAll(this.correspondingClass(packageName, file).asSet());
            }
        }
        return classes;
    }

    private static String classNameFor(ZipEntry entry) {
        return entry.getName().replaceAll("[$].*", "").replaceAll("[.]class", "").replace('/', '.');
    }

    private Optional<? extends Class<?>> loadClassWithName(String className) {
        try {
            return Optional.of(this.getClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.absent();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return Optional.absent();
        }
    }

    private Optional<? extends Class<?>> correspondingClass(String packageName, File file) {
        String fullyQualifiedClassName = this.packagePrefixFor(packageName) + this.simpleClassNameOf(file);
        return this.loadClassWithName(fullyQualifiedClassName);
    }

    private String packagePrefixFor(String packageName) {
        return packageName.isEmpty() || packageName.equals("/") ? "" : packageName + '.';
    }

    private static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private String simpleClassNameOf(File file) {
        return file.getName().substring(0, file.getName().length() - 6);
    }

    private boolean isNotAnInnerClass(String className) {
        return !className.contains("$");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

