/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SerenityListeners;
import net.serenitybdd.core.SerenityReports;
import net.serenitybdd.jbehave.GivenStoryMonitor;
import net.serenitybdd.jbehave.SerenityJBehaveSystemProperties;
import net.serenitybdd.jbehave.SerenityStepFactory;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.model.ExamplesTable;
import org.jbehave.core.model.GivenStories;
import org.jbehave.core.model.GivenStory;
import org.jbehave.core.model.Lifecycle;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Narrative;
import org.jbehave.core.model.OutcomesTable;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.reporters.StoryReporter;
import org.junit.internal.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReporter
implements StoryReporter {
    private static final Logger logger = LoggerFactory.getLogger(SerenityReporter.class);
    private ThreadLocal<SerenityListeners> serenityListenersThreadLocal;
    private ThreadLocal<ReportService> reportServiceThreadLocal;
    private final List<BaseStepListener> baseStepListeners;
    private final Configuration systemConfiguration;
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private static final String PENDING = "pending";
    private static final String MANUAL = "manual";
    private static final String SKIP = "skip";
    private static final String WIP = "wip";
    private static final String IGNORE = "ignore";
    private static final String BEFORE_STORIES = "BeforeStories";
    private static final String AFTER_STORIES = "AfterStories";
    private GivenStoryMonitor givenStoryMonitor;
    private Stack<org.jbehave.core.model.Story> storyStack = new Stack();
    private Stack<String> activeScenarios = new Stack();
    private List<String> givenStories = Lists.newArrayList();
    private Map<String, Meta> scenarioMeta = new ConcurrentHashMap<String, Meta>();
    private Set<String> scenarioMetaProcessed = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, String> storyMetadata;
    private boolean nestScenarios = false;
    List<String> scenarioTags;
    int exampleCount = 0;

    public SerenityReporter(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.serenityListenersThreadLocal = new ThreadLocal();
        this.reportServiceThreadLocal = new ThreadLocal();
        this.baseStepListeners = Lists.newArrayList();
        this.givenStoryMonitor = new GivenStoryMonitor();
    }

    protected void clearListeners() {
        this.serenityListenersThreadLocal.remove();
        this.reportServiceThreadLocal.remove();
        this.givenStoryMonitor.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerenityListeners getSerenityListeners() {
        if (this.serenityListenersThreadLocal.get() == null) {
            SerenityListeners listeners = SerenityReports.setupListeners((Configuration)this.systemConfiguration);
            this.serenityListenersThreadLocal.set(listeners);
            List<BaseStepListener> list = this.baseStepListeners;
            synchronized (list) {
                this.baseStepListeners.add(listeners.getBaseStepListener());
            }
        }
        return this.serenityListenersThreadLocal.get();
    }

    protected ReportService getReportService() {
        return SerenityReports.getReportService((Configuration)this.systemConfiguration);
    }

    public void storyNotAllowed(org.jbehave.core.model.Story story, String filter) {
        logger.debug("not allowed story ".concat(story.getName()));
    }

    public void storyCancelled(org.jbehave.core.model.Story story, StoryDuration storyDuration) {
        logger.debug("cancelled story ".concat(story.getName()));
    }

    private org.jbehave.core.model.Story currentStory() {
        return this.storyStack.peek();
    }

    private void currentStoryIs(org.jbehave.core.model.Story story) {
        this.storyStack.push(story);
    }

    private void clearActiveScenariosData() {
        this.activeScenarios.clear();
        this.scenarioMeta.clear();
        this.scenarioMetaProcessed.clear();
    }

    private void registerScenariosMeta(org.jbehave.core.model.Story story) {
        List scenarios = story.getScenarios();
        for (Scenario scenario : scenarios) {
            this.scenarioMeta.put(scenario.getTitle(), scenario.getMeta());
        }
    }

    public void beforeStory(org.jbehave.core.model.Story story, boolean givenStory) {
        logger.debug("before story ".concat(story.getName()));
        this.prepareSerenityListeners();
        this.currentStoryIs(story);
        this.noteAnyGivenStoriesFor(story);
        this.storyMetadata = this.getMetadataFrom(story.getMeta());
        if (!this.isFixture(story) && !givenStory) {
            this.clearActiveScenariosData();
            this.registerScenariosMeta(story);
            this.configureDriver(story);
            SerenityStepFactory.resetContext();
            if (!this.isAStoryLevelGiven(story)) {
                this.startTestSuiteForStory(story);
                if (this.givenStoriesPresentFor(story)) {
                    this.startTestForFirstScenarioIn(story);
                }
            }
        } else if (givenStory) {
            this.shouldNestScenarios(true);
        }
        this.registerStoryMeta(story.getMeta());
    }

    private void prepareSerenityListeners() {
        this.getSerenityListeners().withDriver(ThucydidesWebDriverSupport.getDriver());
    }

    private boolean shouldNestScenarios() {
        return this.nestScenarios;
    }

    private void shouldNestScenarios(boolean nestScenarios) {
        this.nestScenarios = nestScenarios;
    }

    private void startTestForFirstScenarioIn(org.jbehave.core.model.Story story) {
        Scenario firstScenario = (Scenario)story.getScenarios().get(0);
        this.startScenarioCalled(firstScenario.getTitle(), story.getPath() + ";" + firstScenario.getTitle());
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)"Preconditions"));
        this.shouldNestScenarios(true);
    }

    public void beforeScenario(String scenarioTitle) {
        logger.debug("before scenario started ".concat(scenarioTitle));
        if (this.shouldResetStepsBeforeEachScenario()) {
            SerenityStepFactory.resetContext();
        }
        this.resetDriverIfNecessary();
        if (this.isCurrentScenario(scenarioTitle)) {
            return;
        }
        if (this.shouldNestScenarios()) {
            this.startNewStep(scenarioTitle);
        } else {
            this.startScenarioCalled(scenarioTitle, this.currentStory().getPath() + ";" + scenarioTitle);
            this.scenarioMeta(this.scenarioMeta.get(scenarioTitle));
            this.scenarioMetaProcessed.add(scenarioTitle);
        }
    }

    private void resetDriverIfNecessary() {
        if (Serenity.currentDriverIsDisabled()) {
            Serenity.getWebdriverManager().resetDriver();
        }
    }

    private boolean isCurrentScenario(String scenarioTitle) {
        return !this.activeScenarios.empty() && scenarioTitle.equals(this.activeScenarios.peek());
    }

    private String currentScenarioTitle() {
        return this.activeScenarios.isEmpty() ? "" : this.activeScenarios.peek();
    }

    private com.google.common.base.Optional<Scenario> currentScenario() {
        for (Scenario scenario : this.currentStory().getScenarios()) {
            if (!scenario.getTitle().equals(this.currentScenarioTitle())) continue;
            return com.google.common.base.Optional.of((Object)scenario);
        }
        return com.google.common.base.Optional.absent();
    }

    private void startNewStep(String scenarioTitle) {
        if (this.givenStoryMonitor.isInGivenStory() && StepEventBus.getEventBus().areStepsRunning()) {
            StepEventBus.getEventBus().updateCurrentStepTitleAsPrecondition(scenarioTitle);
        } else {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)scenarioTitle), this.givenStoryMonitor.isInGivenStory());
        }
    }

    private boolean givenStoriesPresentFor(org.jbehave.core.model.Story story) {
        return !story.getGivenStories().getStories().isEmpty();
    }

    private void startTestSuiteForStory(org.jbehave.core.model.Story story) {
        String storyName = this.removeSuffixFrom(story.getName());
        String storyTitle = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)story.getDescription().asString()) ? story.getDescription().asString() : NameConverter.humanize((String)storyName);
        Story userStory = Story.withIdAndPath((String)storyName, (String)storyTitle, (String)story.getPath()).withNarrative(this.getNarrativeFrom(story));
        StepEventBus.getEventBus().testSuiteStarted(userStory);
        this.registerTags(story);
    }

    private String getNarrativeFrom(org.jbehave.core.model.Story story) {
        return !story.getNarrative().isEmpty() ? story.getNarrative().asString(new Keywords()).trim() : "";
    }

    private void noteAnyGivenStoriesFor(org.jbehave.core.model.Story story) {
        for (GivenStory given : story.getGivenStories().getStories()) {
            String givenStoryName = new File(given.getPath()).getName();
            this.givenStories.add(givenStoryName);
        }
    }

    private boolean isAStoryLevelGiven(org.jbehave.core.model.Story story) {
        for (String givenStoryName : this.givenStories) {
            if (!this.hasSameName(story, givenStoryName)) continue;
            return true;
        }
        return false;
    }

    private void givenStoryDone(org.jbehave.core.model.Story story) {
        this.givenStories.remove(story.getName());
    }

    private boolean hasSameName(org.jbehave.core.model.Story story, String givenStoryName) {
        return story.getName().equalsIgnoreCase(givenStoryName);
    }

    private void configureDriver(org.jbehave.core.model.Story story) {
        StepEventBus.getEventBus().setUniqueSession(this.systemConfiguration.shouldUseAUniqueBrowser());
        String requestedDriver = this.getRequestedDriver(story.getMeta());
        if (this.isEmphatic(requestedDriver)) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)this.unemphasised(requestedDriver));
        } else if (StringUtils.isNotEmpty((String)requestedDriver) && !this.driverIsProvidedInTheEnvironmentVariables()) {
            ThucydidesWebDriverSupport.useDefaultDriver((String)requestedDriver);
        }
    }

    private String unemphasised(String requestedDriver) {
        return requestedDriver.replace("!", "");
    }

    private boolean isEmphatic(String requestedDriver) {
        return requestedDriver != null && requestedDriver.endsWith("!");
    }

    private boolean driverIsProvidedInTheEnvironmentVariables() {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)this.systemConfiguration.getEnvironmentVariables().getProperty((Enum)ThucydidesSystemProperty.WEBDRIVER_DRIVER));
    }

    private void registerTags(org.jbehave.core.model.Story story) {
        this.registerStoryIssues(story.getMeta());
        this.registerStoryFeaturesAndEpics(story.getMeta());
        this.registerStoryTags(story.getMeta());
        this.registerStoryMeta(story.getMeta());
    }

    private boolean isFixture(org.jbehave.core.model.Story story) {
        return story.getName().equals(BEFORE_STORIES) || story.getName().equals(AFTER_STORIES);
    }

    private String getRequestedDriver(Meta metaData) {
        if (metaData == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)metaData.getProperty("driver"))) {
            return metaData.getProperty("driver");
        }
        if (this.systemConfiguration.getDriverType() != null) {
            return this.systemConfiguration.getDriverType().toString();
        }
        return null;
    }

    private List<String> getIssueOrIssuesPropertyValues(Meta metaData) {
        return this.getTagPropertyValues(metaData, "issue");
    }

    private List<TestTag> getFeatureOrFeaturesPropertyValues(Meta metaData) {
        List<String> features = this.getTagPropertyValues(metaData, "feature");
        return features.stream().map(featureName -> TestTag.withName((String)featureName).andType("feature")).collect(Collectors.toList());
    }

    private List<TestTag> getEpicOrEpicsPropertyValues(Meta metaData) {
        List<String> epics = this.getTagPropertyValues(metaData, "epic");
        return epics.stream().map(epicName -> TestTag.withName((String)epicName).andType("epic")).collect(Collectors.toList());
    }

    private List<TestTag> getTagOrTagsPropertyValues(Meta metaData) {
        List<String> tags = this.getTagPropertyValues(metaData, "tag");
        return tags.stream().map(this::toTag).collect(Collectors.toList());
    }

    public TestTag toTag(String tag) {
        ArrayList tagParts = Lists.newArrayList((Iterable)Splitter.on((String)":").trimResults().split((CharSequence)tag));
        if (tagParts.size() == 2) {
            return TestTag.withName((String)((String)tagParts.get(1))).andType((String)tagParts.get(0));
        }
        return TestTag.withName((String)"true").andType((String)tagParts.get(0));
    }

    private List<String> getTagPropertyValues(Meta metaData, String tagType) {
        if (metaData == null) {
            return new ArrayList<String>();
        }
        String singularTag = metaData.getProperty(tagType);
        String pluralTagType = Inflector.getInstance().pluralize((Object)tagType);
        String multipleTags = metaData.getProperty(pluralTagType);
        String allTags = Joiner.on((char)',').skipNulls().join((Object)singularTag, (Object)multipleTags, new Object[0]);
        return Lists.newArrayList((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)allTags));
    }

    private void registerIssues(Meta metaData) {
        List<String> issues = this.getIssueOrIssuesPropertyValues(metaData);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentTest(issues);
        }
    }

    private void registerStoryIssues(Meta metaData) {
        List<String> issues = this.getIssueOrIssuesPropertyValues(metaData);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentStory(issues);
        }
    }

    private void registerFeaturesAndEpics(Meta metaData) {
        List<TestTag> featuresAndEpics = this.featureAndEpicTags(metaData);
        if (!featuresAndEpics.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentTest(featuresAndEpics);
        }
    }

    private List<TestTag> featureAndEpicTags(Meta metaData) {
        ArrayList featuresAndEpics = Lists.newArrayList();
        featuresAndEpics.addAll(this.getFeatureOrFeaturesPropertyValues(metaData));
        featuresAndEpics.addAll(this.getEpicOrEpicsPropertyValues(metaData));
        return featuresAndEpics;
    }

    private void registerStoryFeaturesAndEpics(Meta metaData) {
        List<TestTag> featuresAndEpics = this.featureAndEpicTags(metaData);
        if (!featuresAndEpics.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentStory(featuresAndEpics);
        }
    }

    private void registerTags(Meta metaData) {
        List<TestTag> tags = this.getTagOrTagsPropertyValues(metaData);
        if (!tags.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentTest(tags);
        }
    }

    private Map<String, String> getMetadataFrom(Meta metaData) {
        HashMap metadataValues = Maps.newHashMap();
        if (metaData == null) {
            return metadataValues;
        }
        for (String propertyName : metaData.getPropertyNames()) {
            metadataValues.put(propertyName, metaData.getProperty(propertyName));
        }
        return metadataValues;
    }

    private void registerMetadata(Meta metaData) {
        Serenity.getCurrentSession().clearMetaData();
        Map<String, String> scenarioMetadata = this.getMetadataFrom(metaData);
        scenarioMetadata.putAll(this.storyMetadata);
        for (String key : scenarioMetadata.keySet()) {
            Serenity.getCurrentSession().addMetaData(key, scenarioMetadata.get(key));
        }
    }

    private void registerStoryTags(Meta metaData) {
        List<TestTag> tags = this.getTagOrTagsPropertyValues(metaData);
        if (!tags.isEmpty()) {
            StepEventBus.getEventBus().addTagsToCurrentStory(tags);
        }
    }

    private void registerStoryMeta(Meta metaData) {
        if (this.isPending(metaData)) {
            StepEventBus.getEventBus().suspendTest();
        } else if (this.isSkipped(metaData)) {
            StepEventBus.getEventBus().suspendTest();
        } else if (this.isIgnored(metaData)) {
            StepEventBus.getEventBus().suspendTest();
        } else if (this.isManual(metaData)) {
            StepEventBus.getEventBus().suspendTest();
        }
    }

    private boolean isStoryManual() {
        return this.isManual(this.currentStory().getMeta());
    }

    private void registerScenarioMeta(Meta metaData) {
        if (this.isManual(metaData) || this.isStoryManual()) {
            StepEventBus.getEventBus().testIsManual();
        }
    }

    private String removeSuffixFrom(String name) {
        return name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
    }

    public void afterStory(boolean given) {
        logger.debug("afterStory " + given);
        this.shouldNestScenarios(false);
        if (given) {
            this.givenStoryMonitor.exitingGivenStory();
            this.givenStoryDone(this.currentStory());
        } else if (this.isAfterStory(this.currentStory())) {
            this.generateReports();
        } else if (!this.isFixture(this.currentStory()) && !this.isAStoryLevelGiven(this.currentStory())) {
            StepEventBus.getEventBus().testSuiteFinished();
            this.clearListeners();
        }
        this.storyStack.pop();
    }

    private boolean isAfterStory(org.jbehave.core.model.Story currentStory) {
        return currentStory.getName().equals(AFTER_STORIES);
    }

    private synchronized void generateReports() {
        this.getReportService().generateReportsFor(this.getAllTestOutcomes());
    }

    public List<TestOutcome> getAllTestOutcomes() {
        return this.baseStepListeners.stream().map(BaseStepListener::getTestOutcomes).flatMap(outcomes -> outcomes.stream()).collect(Collectors.toList());
    }

    public void narrative(Narrative narrative) {
        logger.debug("narrative ".concat(narrative.toString()));
    }

    public void lifecyle(Lifecycle lifecycle) {
        logger.debug("lifecyle ".concat(lifecycle.toString()));
    }

    public void scenarioNotAllowed(Scenario scenario, String s) {
        logger.debug("scenarioNotAllowed ".concat(scenario.getTitle()));
        StepEventBus.getEventBus().testIgnored();
    }

    private void startScenarioCalled(String scenarioTitle, String scenarioId) {
        StepEventBus.getEventBus().setTestSource("JBehave");
        StepEventBus.getEventBus().testStarted(scenarioTitle, scenarioId);
        this.activeScenarios.add(scenarioTitle);
    }

    private boolean shouldResetStepsBeforeEachScenario() {
        return this.systemConfiguration.getEnvironmentVariables().getPropertyAsBoolean(SerenityJBehaveSystemProperties.RESET_STEPS_EACH_SCENARIO.getName(), true);
    }

    public void scenarioMeta(Meta meta) {
        this.scenarioTags = new ArrayList<String>(meta.getPropertyNames());
        this.scenarioTags.addAll(this.currentStory().getMeta().getPropertyNames());
        String title = this.activeScenarios.peek();
        logger.debug("scenario:\"" + (StringUtils.isEmpty((String)title) ? " don't know name " : title) + "\" registering metadata for" + meta);
        this.registerIssues(meta);
        this.registerFeaturesAndEpics(meta);
        this.registerTags(meta);
        this.registerMetadata(meta);
        this.registerScenarioMeta(meta);
        this.markAsSkippedOrPendingIfAnnotatedAsSuchIn(this.scenarioTags);
    }

    private void markAsSkippedOrPendingIfAnnotatedAsSuchIn(List<String> tags) {
        if (this.isManual(tags)) {
            StepEventBus.getEventBus().testIsManual();
        }
        if (this.isSkipped(tags)) {
            StepEventBus.getEventBus().testSkipped();
            StepEventBus.getEventBus().getBaseStepListener().overrideResultTo(TestResult.SKIPPED);
        }
        if (this.isPending(tags)) {
            StepEventBus.getEventBus().testPending();
            StepEventBus.getEventBus().getBaseStepListener().overrideResultTo(TestResult.PENDING);
        }
        if (this.isIgnored(tags)) {
            StepEventBus.getEventBus().testIgnored();
            StepEventBus.getEventBus().getBaseStepListener().overrideResultTo(TestResult.IGNORED);
        }
    }

    private boolean isSkipped(List<String> tags) {
        return tags.contains(SKIP) || tags.contains(WIP);
    }

    private boolean isPending(List<String> tags) {
        return tags.contains(PENDING);
    }

    private boolean isIgnored(List<String> tags) {
        return tags.contains(IGNORE);
    }

    private boolean isManual(List<String> tags) {
        return tags.contains(MANUAL);
    }

    private boolean isPending(Meta metaData) {
        if (metaData == null) {
            return false;
        }
        return metaData.hasProperty(PENDING);
    }

    private boolean isManual(Meta metaData) {
        if (metaData == null) {
            return false;
        }
        return metaData.hasProperty(MANUAL);
    }

    private boolean isSkipped(Meta metaData) {
        if (metaData == null) {
            return false;
        }
        return metaData.hasProperty(WIP) || metaData.hasProperty(SKIP);
    }

    private boolean isCandidateToBeExecuted(Meta metaData) {
        return !this.isIgnored(metaData) && !this.isPending(metaData) && !this.isSkipped(metaData);
    }

    private boolean isIgnored(Meta metaData) {
        if (metaData == null) {
            return false;
        }
        return metaData.hasProperty(IGNORE);
    }

    public void afterScenario() {
        String scenarioTitle = this.activeScenarios.peek();
        logger.debug("afterScenario : " + this.activeScenarios.peek());
        this.scenarioMeta(this.scenarioMeta.get(scenarioTitle));
        this.scenarioMetaProcessed.add(scenarioTitle);
        if (this.givenStoryMonitor.isInGivenStory() || this.shouldNestScenarios()) {
            StepEventBus.getEventBus().stepFinished();
        } else {
            if (!(this.isPending(this.scenarioTags) || this.isSkipped(this.scenarioTags) || this.isIgnored(this.scenarioTags))) {
                StepEventBus.getEventBus().testFinished();
            }
            this.activeScenarios.pop();
        }
    }

    public void givenStories(GivenStories givenStories) {
        logger.debug("givenStories " + givenStories);
        this.givenStoryMonitor.enteringGivenStory();
    }

    public void givenStories(List<String> strings) {
        logger.debug("givenStories " + strings);
    }

    public void beforeExamples(List<String> steps, ExamplesTable table) {
        logger.debug("beforeExamples " + steps + " " + table);
        if (this.givenStoryMonitor.isInGivenStory()) {
            return;
        }
        this.exampleCount = 0;
        StepEventBus.getEventBus().useExamplesFrom(this.serenityTableFrom(table));
    }

    private DataTable serenityTableFrom(ExamplesTable table) {
        String scenarioOutline = this.scenarioOutlineFrom(this.currentScenario());
        return DataTable.withHeaders((List)table.getHeaders()).andScenarioOutline(scenarioOutline).andMappedRows(table.getRows()).build();
    }

    private String scenarioOutlineFrom(com.google.common.base.Optional<Scenario> scenario) {
        if (!scenario.isPresent()) {
            return null;
        }
        StringBuilder outline = new StringBuilder();
        for (String step : ((Scenario)scenario.get()).getSteps()) {
            outline.append(step.trim()).append(System.lineSeparator());
        }
        return outline.toString();
    }

    public void example(Map<String, String> tableRow) {
        StepEventBus.getEventBus().clearStepFailures();
        if (this.givenStoryMonitor.isInGivenStory()) {
            return;
        }
        if (this.executingExamples()) {
            this.finishExample();
        }
        ++this.exampleCount;
        this.startExample(tableRow);
    }

    private void startExample(Map<String, String> data) {
        StepEventBus.getEventBus().exampleStarted(data);
    }

    private void finishExample() {
        StepEventBus.getEventBus().exampleFinished();
    }

    private boolean executingExamples() {
        return this.exampleCount > 0;
    }

    public void afterExamples() {
        if (this.givenStoryMonitor.isInGivenStory()) {
            return;
        }
        this.finishExample();
    }

    public void beforeStep(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
    }

    public void successful(String title) {
        if (this.annotatedResultTakesPriority()) {
            this.processAnnotatedResult();
        } else {
            StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
            StepEventBus.getEventBus().stepFinished();
        }
    }

    private void processAnnotatedResult() {
        TestResult forcedResult = (TestResult)StepEventBus.getEventBus().getForcedResult().get();
        switch (forcedResult) {
            case PENDING: {
                StepEventBus.getEventBus().stepPending();
                break;
            }
            case IGNORED: {
                StepEventBus.getEventBus().stepIgnored();
                break;
            }
            case SKIPPED: {
                StepEventBus.getEventBus().stepIgnored();
                break;
            }
            default: {
                StepEventBus.getEventBus().stepIgnored();
            }
        }
    }

    private boolean annotatedResultTakesPriority() {
        return StepEventBus.getEventBus().getForcedResult().isPresent();
    }

    public void ignorable(String title) {
        StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(title));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void comment(String step) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)step));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void pending(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepPending();
    }

    public void notPerformed(String stepTitle) {
        StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)));
        StepEventBus.getEventBus().stepIgnored();
    }

    public void failed(String stepTitle, Throwable cause) {
        if (!StepEventBus.getEventBus().testSuiteHasStarted()) {
            this.declareOutOfSuiteFailure();
        }
        if (!this.errorOrFailureRecordedForStep(cause.getCause())) {
            StepEventBus.getEventBus().updateCurrentStepTitle(stepTitle);
            Throwable rootCause = new RootCauseAnalyzer(cause.getCause()).getRootCause().toException();
            if (this.isAssumptionFailure(rootCause)) {
                StepEventBus.getEventBus().assumptionViolated(rootCause.getMessage());
            } else {
                StepEventBus.getEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)), rootCause));
            }
        }
    }

    private void declareOutOfSuiteFailure() {
        String storyName = !this.storyStack.isEmpty() ? this.storyStack.peek().getName() : "Before or After Story";
        String storyId = !this.storyStack.isEmpty() ? this.storyStack.peek().getPath() : null;
        StepEventBus.getEventBus().testStarted(storyName, storyId);
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    public List<String> processExcludedByFilter(org.jbehave.core.model.Story story, Set<String> exclude) {
        Meta storyMeta = story.getMeta();
        LinkedList<Scenario> processing = new LinkedList<Scenario>();
        LinkedList<String> processed = new LinkedList<String>();
        if (this.isSkipped(storyMeta) || this.isIgnored(storyMeta)) {
            processing.addAll(story.getScenarios());
        } else {
            for (Scenario scenario : story.getScenarios()) {
                Meta scenarioMeta = scenario.getMeta();
                if (!this.isSkipped(scenarioMeta) && !this.isIgnored(scenarioMeta)) continue;
                processing.add(scenario);
            }
        }
        if (processing.size() > 0) {
            org.jbehave.core.model.Story beforeStory = new org.jbehave.core.model.Story();
            beforeStory.namedAs(BEFORE_STORIES);
            org.jbehave.core.model.Story afterStory = new org.jbehave.core.model.Story();
            afterStory.namedAs(AFTER_STORIES);
            Narrative narrative = story.getNarrative();
            this.beforeStory(beforeStory, false);
            this.afterStory(false);
            this.beforeStory(story, false);
            this.narrative(narrative);
            for (Scenario filtered : processing) {
                String scenarioKey = this.scenarioKey(story, filtered);
                if (exclude.contains(scenarioKey)) continue;
                this.beforeScenario(filtered.getTitle());
                this.scenarioMeta(filtered.getMeta());
                List steps = filtered.getSteps();
                if (ExamplesTable.EMPTY == filtered.getExamplesTable() || filtered.getExamplesTable().getRows().size() == 0) {
                    for (String step : steps) {
                        this.beforeStep(step);
                        this.successful(step);
                    }
                } else {
                    ExamplesTable examples = filtered.getExamplesTable();
                    this.beforeExamples(steps, examples);
                    for (Map row : examples.getRows()) {
                        this.example(row);
                        for (String step : steps) {
                            this.beforeStep(step);
                            this.successful(step);
                        }
                    }
                    this.afterExamples();
                }
                this.afterScenario();
                processed.add(this.scenarioKey(story, filtered));
            }
            this.afterStory(false);
            this.beforeStory(afterStory, false);
            this.afterStory(false);
        }
        return processed;
    }

    private String scenarioKey(org.jbehave.core.model.Story story, Scenario scenario) {
        return story.getPath().concat(scenario.getTitle());
    }

    public void failedOutcomes(String s, OutcomesTable outcomesTable) {
        logger.debug("failedOutcomes");
    }

    public void restarted(String s, Throwable throwable) {
        logger.debug("restarted");
    }

    public void restartedStory(org.jbehave.core.model.Story story, Throwable cause) {
        logger.debug("restartedStory");
    }

    public void dryRun() {
        logger.debug("dryRun");
    }

    public void pendingMethods(List<String> strings) {
        logger.debug("pendingMethods");
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }

    private boolean errorOrFailureRecordedForStep(Throwable cause) {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        for (TestStep step : this.latestTestOutcome().get().getFlattenedTestSteps()) {
            if (step.getException() == null || step.getException().getOriginalCause() != cause) continue;
            return true;
        }
        return false;
    }

    private Optional<TestOutcome> latestTestOutcome() {
        List recordedOutcomes = StepEventBus.getEventBus().getBaseStepListener().getTestOutcomes();
        return recordedOutcomes.isEmpty() ? Optional.empty() : Optional.of(recordedOutcomes.get(recordedOutcomes.size() - 1));
    }
}

