/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.converters;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.lang.reflect.Type;
import java.util.List;
import org.jbehave.core.steps.ParameterConverters;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConverter
implements ParameterConverters.ParameterConverter {
    public static final DateTimeFormatter CONVENTIONAL_FORMAT = DateTimeFormat.forPattern((String)"ddMMyyyy");
    public static final DateTimeFormatter ISO_FORMAT = DateTimeFormat.forPattern((String)"yyyyMMdd");
    private DateTimeFormatter dateFormat;

    public DateTimeConverter() {
        this(null);
    }

    public DateTimeConverter(DateTimeFormatter dateFormat) {
        this.dateFormat = dateFormat;
    }

    private DateTimeFormatter getBestFormatterFor(String value) {
        if (this.dateFormat == null) {
            if (this.startsWithYear(value)) {
                return ISO_FORMAT;
            }
            return CONVENTIONAL_FORMAT;
        }
        return this.dateFormat;
    }

    private boolean startsWithYear(String value) {
        return this.getDateElementsFrom(value).get(0).length() == 4;
    }

    private List<String> getDateElementsFrom(String value) {
        return Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"-/")).splitToList((CharSequence)value);
    }

    public boolean accept(Type type) {
        return type instanceof Class && DateTime.class.isAssignableFrom((Class)type);
    }

    public Object convertValue(String value, Type type) {
        DateTimeFormatter formatter = this.getBestFormatterFor(value);
        return DateTime.parse((String)this.normalized(value), (DateTimeFormatter)formatter);
    }

    private String normalized(String value) {
        return value.replaceAll("/", "").replaceAll("-", "");
    }
}

