/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.runners;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jbehave.core.annotations.ScenarioType;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.Keywords;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.steps.BeforeOrAfterStep;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.StepCandidate;
import org.jbehave.core.steps.StepCollector;
import org.jbehave.core.steps.StepType;
import org.junit.runner.Description;

public class JUnitDescriptionGenerator {
    public static final String BEFORE_STORY_STEP_NAME = "@BeforeStory";
    public static final String AFTER_STORY_STEP_NAME = "@AfterStory";
    public static final String BEFORE_SCENARIO_STEP_NAME = "@BeforeScenario";
    public static final String AFTER_SCENARIO_STEP_NAME = "@AfterScenario";
    private int testCases;
    private List<StepCandidate> allCandidates = new ArrayList<StepCandidate>();
    private Map<ScenarioType, List<BeforeOrAfterStep>> beforeOrAfterScenario = new HashMap<ScenarioType, List<BeforeOrAfterStep>>();
    private List<BeforeOrAfterStep> beforeOrAfterStory;
    private final Configuration configuration;
    private String previousNonAndStep;

    public JUnitDescriptionGenerator(List<CandidateSteps> candidateSteps, Configuration configuration) {
        for (ScenarioType scenarioType : ScenarioType.values()) {
            this.beforeOrAfterScenario.put(scenarioType, new ArrayList());
        }
        this.beforeOrAfterStory = new ArrayList<BeforeOrAfterStep>();
        this.configuration = configuration;
        for (CandidateSteps candidateStep : candidateSteps) {
            this.allCandidates.addAll(candidateStep.listCandidates());
            for (ScenarioType scenarioType : ScenarioType.values()) {
                this.beforeOrAfterScenario.get(scenarioType).addAll(candidateStep.listBeforeOrAfterScenario(scenarioType));
            }
            this.beforeOrAfterStory.addAll(candidateStep.listBeforeOrAfterStory(false));
        }
    }

    public List<Description> createDescriptionFrom(PerformableTree performableTree) {
        return performableTree.getRoot().getStories().parallelStream().filter(PerformableTree.PerformableStory::isAllowed).flatMap(performableStory -> JUnitDescriptionGenerator.streamOf(this.descriptionFor((PerformableTree.PerformableStory)performableStory))).collect(Collectors.toList());
    }

    private static <T> Stream<T> streamOf(Optional<T> opt) {
        return opt.map(Stream::of).orElseGet(Stream::empty);
    }

    private Optional<Description> descriptionFor(PerformableTree.PerformableStory performableStory) {
        List<Description> scenarioDescriptions = this.getScenarioDescriptions(performableStory.getScenarios());
        if (!scenarioDescriptions.isEmpty()) {
            Description storyDescription = this.createDescriptionForStory(performableStory.getStory());
            this.addBeforeOrAfterStep(StepCollector.Stage.BEFORE, this.beforeOrAfterStory, storyDescription, BEFORE_STORY_STEP_NAME);
            for (Description scenarioDescription : scenarioDescriptions) {
                storyDescription.addChild(scenarioDescription);
            }
            this.addBeforeOrAfterStep(StepCollector.Stage.AFTER, this.beforeOrAfterStory, storyDescription, AFTER_STORY_STEP_NAME);
            return Optional.of(storyDescription);
        }
        return Optional.empty();
    }

    public Description createDescriptionFrom(PerformableTree.PerformableScenario performableScenario) {
        Scenario scenario = performableScenario.getScenario();
        Description scenarioDescription = this.createDescriptionForScenario(scenario);
        if (performableScenario.hasExamples() && !scenario.getGivenStories().requireParameters()) {
            this.insertDescriptionForExamples(performableScenario, scenarioDescription);
        } else {
            if (this.hasGivenStories(scenario)) {
                this.insertGivenStories(scenario, scenarioDescription);
            }
            this.addScenarioSteps(ScenarioType.NORMAL, scenario, scenarioDescription);
        }
        return scenarioDescription;
    }

    private void addScenarioSteps(ScenarioType scenarioType, Scenario scenario, Description scenarioDescription) {
        this.addBeforeOrAfterScenarioStep(scenarioType, StepCollector.Stage.BEFORE, scenarioDescription, BEFORE_SCENARIO_STEP_NAME);
        this.addStepsToExample(scenario, scenarioDescription);
        this.addBeforeOrAfterScenarioStep(scenarioType, StepCollector.Stage.AFTER, scenarioDescription, AFTER_SCENARIO_STEP_NAME);
    }

    private void addBeforeOrAfterScenarioStep(ScenarioType scenarioType, StepCollector.Stage stage, Description description, String stepName) {
        ArrayList<BeforeOrAfterStep> beforeOrAfterSteps = new ArrayList<BeforeOrAfterStep>();
        beforeOrAfterSteps.addAll((Collection)this.beforeOrAfterScenario.get(scenarioType));
        beforeOrAfterSteps.addAll((Collection)this.beforeOrAfterScenario.get(ScenarioType.ANY));
        this.addBeforeOrAfterStep(stage, beforeOrAfterSteps, description, stepName);
    }

    private void addBeforeOrAfterStep(StepCollector.Stage stage, List<BeforeOrAfterStep> beforeOrAfterSteps, Description description, String stepName) {
        for (BeforeOrAfterStep beforeOrAfterStep : beforeOrAfterSteps) {
            if (beforeOrAfterStep.getStage() != stage) continue;
            ++this.testCases;
            this.addBeforeOrAfterStep(beforeOrAfterStep, description, stepName);
            break;
        }
    }

    private void addBeforeOrAfterStep(BeforeOrAfterStep beforeOrAfterStep, Description description, String stepName) {
        Method method = beforeOrAfterStep.getMethod();
        Description testDescription = Description.createTestDescription(method.getDeclaringClass(), (String)this.getJunitSafeString(stepName), (Annotation[])method.getAnnotations());
        description.addChild(testDescription);
    }

    public String getJunitSafeString(String string) {
        return string;
    }

    public int getTestCases() {
        return this.testCases;
    }

    private boolean hasGivenStories(Scenario scenario) {
        return !scenario.getGivenStories().getPaths().isEmpty();
    }

    private void insertGivenStories(Scenario scenario, Description scenarioDescription) {
        for (String path : scenario.getGivenStories().getPaths()) {
            this.addGivenStoryToScenario(scenarioDescription, path);
        }
    }

    private void addGivenStoryToScenario(Description scenarioDescription, String path) {
        scenarioDescription.addChild(Description.createSuiteDescription((String)this.getJunitSafeString(this.getFilename(path)), (Annotation[])new Annotation[0]));
        ++this.testCases;
    }

    private String getFilename(String path) {
        return path.substring(path.lastIndexOf("/") + 1, path.length()).split("#")[0];
    }

    private void insertDescriptionForExamples(PerformableTree.PerformableScenario performableScenario, Description scenarioDescription) {
        Scenario scenario = performableScenario.getScenario();
        for (PerformableTree.ExamplePerformableScenario examplePerformableScenario : performableScenario.getExamples()) {
            Description exampleRowDescription = Description.createSuiteDescription((String)(this.configuration.keywords().examplesTableRow() + " " + examplePerformableScenario.getParameters()), (Annotation[])new Annotation[0]);
            scenarioDescription.addChild(exampleRowDescription);
            if (this.hasGivenStories(scenario)) {
                this.insertGivenStories(scenario, exampleRowDescription);
            }
            this.addScenarioSteps(ScenarioType.EXAMPLE, scenario, exampleRowDescription);
        }
    }

    private void addStepsToExample(Scenario scenario, Description description) {
        this.addSteps(description, scenario.getSteps());
    }

    private void addSteps(Description description, List<String> steps) {
        this.previousNonAndStep = null;
        for (String stringStep : steps) {
            String stringStepOneLine = this.stripLinebreaks(stringStep);
            StepCandidate matchingStep = this.findMatchingStep(stringStep);
            if (matchingStep == null) {
                this.addNonExistingStep(description, stringStepOneLine, stringStep);
                continue;
            }
            this.addExistingStep(description, stringStepOneLine, matchingStep);
        }
    }

    private void addExistingStep(Description description, String stringStepOneLine, StepCandidate matchingStep) {
        if (matchingStep.isComposite()) {
            this.addCompositeSteps(description, stringStepOneLine, matchingStep);
        } else {
            this.addRegularStep(description, stringStepOneLine, matchingStep);
        }
    }

    private void addNonExistingStep(Description description, String stringStepOneLine, String stringStep) {
        try {
            if (this.configuration.keywords().stepTypeFor(stringStep) == StepType.IGNORABLE) {
                this.addIgnorableStep(description, stringStepOneLine);
            } else {
                this.addPendingStep(description, stringStepOneLine);
            }
        }
        catch (Keywords.StartingWordNotFound startingWordNotFound) {
            // empty catch block
        }
    }

    private void addIgnorableStep(Description description, String stringStep) {
        ++this.testCases;
        description.addChild(Description.createSuiteDescription((String)stringStep, (Annotation[])new Annotation[0]));
    }

    private void addPendingStep(Description description, String stringStep) {
        ++this.testCases;
        description.addChild(Description.createSuiteDescription((String)this.getJunitSafeString("[PENDING] " + stringStep), (Annotation[])new Annotation[0]));
    }

    private void addRegularStep(Description description, String stringStep, StepCandidate step) {
        ++this.testCases;
        description.addChild(Description.createTestDescription((Class)step.getStepsType(), (String)this.getJunitSafeString(stringStep)));
    }

    private void addCompositeSteps(Description description, String stringStep, StepCandidate step) {
        Description testDescription = Description.createSuiteDescription((String)this.getJunitSafeString(stringStep), (Annotation[])new Annotation[0]);
        this.addSteps(testDescription, Arrays.asList(step.composedSteps()));
        description.addChild(testDescription);
    }

    private List<Description> getScenarioDescriptions(List<PerformableTree.PerformableScenario> performableScenarios) {
        ArrayList<Description> scenarioDescriptions = new ArrayList<Description>();
        for (PerformableTree.PerformableScenario scenario : performableScenarios) {
            if (!scenario.isAllowed()) continue;
            scenarioDescriptions.add(this.createDescriptionFrom(scenario));
        }
        return scenarioDescriptions;
    }

    private StepCandidate findMatchingStep(String stringStep) {
        for (StepCandidate step : this.allCandidates) {
            if (!step.matches(stringStep, this.previousNonAndStep)) continue;
            if (step.getStepType() != StepType.AND) {
                this.previousNonAndStep = step.getStartingWord() + " ";
            }
            return step;
        }
        return null;
    }

    private String stripLinebreaks(String stringStep) {
        if (stringStep.indexOf(10) != -1) {
            return stringStep.substring(0, stringStep.indexOf(10));
        }
        return stringStep;
    }

    private Description createDescriptionForStory(Story story) {
        return Description.createSuiteDescription((String)this.getJunitSafeString(story.getName()), (Annotation[])new Annotation[0]);
    }

    private Description createDescriptionForScenario(Scenario scenario) {
        return Description.createSuiteDescription((String)(this.configuration.keywords().scenario() + " " + this.getJunitSafeString(scenario.getTitle())), (Annotation[])new Annotation[0]);
    }
}

