/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.converters;

import java.lang.reflect.Type;
import org.jbehave.core.steps.ParameterConverters;
import org.joda.time.YearMonth;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class YearMonthConverter
extends ParameterConverters.AbstractParameterConverter<YearMonth> {
    public static final DateTimeFormatter MONTH_YEAR_FORMAT_WITH_DASH = DateTimeFormat.forPattern((String)"MM-yyyy");
    public static final DateTimeFormatter MONTH_YEAR_FORMAT_WITH_SLASH = DateTimeFormat.forPattern((String)"MM/yyyy");
    public static final DateTimeFormatter YEAR_MONTH_FORMAT_WITH_DASH = DateTimeFormat.forPattern((String)"yyyy-MM");
    public static final DateTimeFormatter YEAR_MONTH_FORMAT_WITH_SLASH = DateTimeFormat.forPattern((String)"yyyy/MM");

    public YearMonth convertValue(String value, Type type) {
        DateTimeFormatter formatter = this.hasDash(value) ? this.getFormatterWithDash(value) : this.getFormatterWithSlash(value);
        return YearMonth.parse((String)value, (DateTimeFormatter)formatter);
    }

    private DateTimeFormatter getFormatterWithSlash(String value) {
        return value.trim().charAt(2) == '/' ? MONTH_YEAR_FORMAT_WITH_SLASH : YEAR_MONTH_FORMAT_WITH_SLASH;
    }

    private DateTimeFormatter getFormatterWithDash(String value) {
        return value.trim().charAt(2) == '-' ? MONTH_YEAR_FORMAT_WITH_DASH : YEAR_MONTH_FORMAT_WITH_DASH;
    }

    private boolean hasDash(String value) {
        return value.indexOf(45) > -1;
    }
}

