/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.runners;

import com.github.valfirst.jbehave.junit.monitoring.JUnitDescriptionGenerator;
import com.github.valfirst.jbehave.junit.monitoring.JUnitReportingRunner;
import com.github.valfirst.jbehave.junit.monitoring.JUnitScenarioReporter;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.jbehave.SerenityJBehaveSystemProperties;
import net.serenitybdd.jbehave.SerenityStories;
import net.serenitybdd.jbehave.annotations.Metafilter;
import net.serenitybdd.jbehave.embedders.ExtendedEmbedder;
import net.serenitybdd.jbehave.embedders.monitors.ReportingEmbedderMonitor;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.ConfigurableEmbedder;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.embedder.Embedder;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.PerformableTree;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.io.StoryPathResolver;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.junit.JUnitStory;
import org.jbehave.core.model.Story;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.jbehave.core.steps.NullStepMonitor;
import org.jbehave.core.steps.StepMonitor;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReportingRunner
extends Runner {
    private List<Description> storyDescriptions;
    private ExtendedEmbedder configuredEmbedder;
    private List<String> storyPaths;
    private Configuration configuration;
    private Description description;
    List<CandidateSteps> candidateSteps;
    private final ConfigurableEmbedder configurableEmbedder;
    private final Class<? extends ConfigurableEmbedder> testClass;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityReportingRunner.class);
    private boolean runningInMaven;
    private int testCount = 0;

    public SerenityReportingRunner(Class<? extends ConfigurableEmbedder> testClass) throws Throwable {
        this(testClass, testClass.newInstance());
    }

    public SerenityReportingRunner(Class<? extends ConfigurableEmbedder> testClass, ConfigurableEmbedder embedder) {
        this.configurableEmbedder = embedder;
        ExtendedEmbedder extendedEmbedder = new ExtendedEmbedder(this.configurableEmbedder.configuredEmbedder());
        extendedEmbedder.getEmbedderMonitor().subscribe(new ReportingEmbedderMonitor(((SerenityStories)embedder).getSystemConfiguration(), extendedEmbedder), new EmbedderMonitor[0]);
        this.configurableEmbedder.useEmbedder((Embedder)extendedEmbedder);
        this.testClass = testClass;
        this.environmentVariables = this.environmentVariablesFrom(this.configurableEmbedder);
    }

    protected List<Description> getDescriptions() {
        if (this.storyDescriptions == null) {
            this.storyDescriptions = this.buildDescriptionFromStories();
        }
        return this.storyDescriptions;
    }

    protected Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getConfiguredEmbedder().configuration();
        }
        return this.configuration;
    }

    public ExtendedEmbedder getConfiguredEmbedder() {
        if (this.configuredEmbedder == null) {
            this.configuredEmbedder = (ExtendedEmbedder)this.configurableEmbedder.configuredEmbedder();
        }
        return this.configuredEmbedder;
    }

    List<String> getStoryPaths() {
        if (this.storyPaths == null || this.storyPaths.isEmpty()) {
            this.storyPaths = this.storyPathsFromRunnerClass();
        }
        return this.storyPaths;
    }

    private List<String> storyPathsFromRunnerClass() {
        try {
            List<Object> storyPaths = new ArrayList();
            if (this.configurableEmbedder instanceof JUnitStory) {
                storyPaths = this.getStoryPathsFromJUnitStory();
            } else if (this.configurableEmbedder instanceof JUnitStories) {
                storyPaths = this.getStoryPathsFromJUnitStories(this.testClass);
            }
            String storyFilter = this.getStoryFilterFrom(this.configurableEmbedder);
            return storyPaths.stream().filter(story -> story.matches(storyFilter)).collect(Collectors.toList());
        }
        catch (Throwable e) {
            LOGGER.error("Could not load story paths", e);
            return Collections.EMPTY_LIST;
        }
    }

    private String getStoryFilterFrom(ConfigurableEmbedder embedder) {
        String defaultStoryFilter = this.environmentVariables.getProperty(SerenityJBehaveSystemProperties.STORY_FILTER.getName(), ".*");
        Optional<Method> getStoryFilter = Arrays.stream(embedder.getClass().getMethods()).filter(method -> method.getName().equals("getStoryFilter")).findFirst();
        if (getStoryFilter.isPresent()) {
            try {
                Optional<Object> storyFilterValue = Optional.ofNullable(getStoryFilter.get().invoke((Object)embedder, new Object[0]));
                return storyFilterValue.orElse(defaultStoryFilter).toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOGGER.warn("Could not invoke getStoryFilter() method on {}", (Object)embedder, (Object)e);
            }
        }
        return defaultStoryFilter;
    }

    private EnvironmentVariables environmentVariablesFrom(ConfigurableEmbedder configurableEmbedder) {
        if (configurableEmbedder instanceof SerenityStories) {
            return ((SerenityStories)configurableEmbedder).getEnvironmentVariables();
        }
        return (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription(this.configurableEmbedder.getClass());
            for (Description childDescription : this.getDescriptions()) {
                this.description.addChild(childDescription);
            }
        }
        return this.description;
    }

    public int testCount() {
        if (this.testCount == 0) {
            this.testCount = this.countStories();
        }
        return this.testCount;
    }

    public void run(RunNotifier notifier) {
        this.beforeStoriesRun(this.getConfiguredEmbedder());
        this.getConfiguredEmbedder().embedderControls().doIgnoreFailureInView(this.getIgnoreFailuresInView());
        this.getConfiguredEmbedder().embedderControls().doIgnoreFailureInStories(this.getIgnoreFailuresInStories());
        this.getConfiguredEmbedder().embedderControls().useStoryTimeoutInSecs((long)this.getStoryTimeoutInSecs());
        this.getConfiguredEmbedder().embedderControls().useStoryTimeouts(this.getStoryTimeout());
        this.getConfiguredEmbedder().embedderControls().useThreads(this.getThreadCount());
        if (this.metaFiltersAreDefined()) {
            this.getConfiguredEmbedder().useMetaFilters(this.getMetaFilters());
        }
        JUnitScenarioReporter junitReporter = new JUnitScenarioReporter(notifier, this.testCount(), this.getDescription(), this.getConfiguredEmbedder().configuration().keywords());
        junitReporter.usePendingStepStrategy(this.getConfiguration().pendingStepStrategy());
        JUnitReportingRunner.recommendedControls((Embedder)this.getConfiguredEmbedder());
        this.addToStoryReporterFormats(junitReporter);
        try {
            this.getConfiguredEmbedder().runStoriesAsPaths(this.getStoryPaths());
        }
        catch (Throwable e) {
            throw new SerenityManagedException(e);
        }
        finally {
            this.getConfiguredEmbedder().generateCrossReference();
        }
        this.shutdownTestSuite();
    }

    private boolean isRunningInGradle() {
        return Stream.of(new Exception().getStackTrace()).anyMatch(elt -> elt.getClassName().startsWith("org.gradle"));
    }

    public void beforeStoriesRun(ExtendedEmbedder configuredEmbedder) {
    }

    private void shutdownTestSuite() {
        StepEventBus.getEventBus().testSuiteFinished();
    }

    List<CandidateSteps> getCandidateSteps() {
        if (this.candidateSteps == null) {
            StepMonitor originalStepMonitor = this.createCandidateStepsWithNoMonitor();
            this.createCandidateStepsWith(originalStepMonitor);
        }
        return this.candidateSteps;
    }

    private void createCandidateStepsWith(StepMonitor stepMonitor) {
        this.getConfiguration().useStepMonitor(stepMonitor);
        this.candidateSteps = this.buildCandidateSteps();
        this.candidateSteps.forEach(step -> step.configuration().useStepMonitor(stepMonitor));
    }

    private StepMonitor createCandidateStepsWithNoMonitor() {
        StepMonitor usedStepMonitor = this.getConfiguration().stepMonitor();
        this.createCandidateStepsWith((StepMonitor)new NullStepMonitor());
        return usedStepMonitor;
    }

    private List<String> getStoryPathsFromJUnitStory() {
        StoryPathResolver resolver = this.getConfiguredEmbedder().configuration().storyPathResolver();
        return Arrays.asList(resolver.resolve(this.configurableEmbedder.getClass()));
    }

    private List<String> getStoryPathsFromJUnitStories(Class<? extends ConfigurableEmbedder> testClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.makeStoryPathsMethodPublic(testClass);
        return (List)method.invoke((Object)this.configurableEmbedder, (Object[])null);
    }

    private Method makeStoryPathsMethodPublic(Class<? extends ConfigurableEmbedder> testClass) throws NoSuchMethodException {
        Method method;
        try {
            method = testClass.getDeclaredMethod("storyPaths", null);
        }
        catch (NoSuchMethodException e) {
            method = testClass.getMethod("storyPaths", null);
        }
        method.setAccessible(true);
        return method;
    }

    private List<CandidateSteps> buildCandidateSteps() {
        List candidateSteps;
        InjectableStepsFactory stepsFactory = this.configurableEmbedder.stepsFactory();
        if (stepsFactory != null) {
            candidateSteps = stepsFactory.createCandidateSteps();
        } else {
            ExtendedEmbedder embedder = this.getConfiguredEmbedder();
            candidateSteps = embedder.candidateSteps();
            if (candidateSteps == null || candidateSteps.isEmpty()) {
                candidateSteps = embedder.stepsFactory().createCandidateSteps();
            }
        }
        return candidateSteps;
    }

    private void addToStoryReporterFormats(JUnitScenarioReporter junitReporter) {
        StoryReporterBuilder storyReporterBuilder = this.getConfiguration().storyReporterBuilder();
        StoryReporterBuilder.ProvidedFormat junitReportFormat = new StoryReporterBuilder.ProvidedFormat((StoryReporter)junitReporter);
        storyReporterBuilder.withFormats(new Format[]{junitReportFormat});
    }

    private List<Description> buildDescriptionFromStories() {
        JUnitDescriptionGenerator descriptionGenerator = new JUnitDescriptionGenerator(this.getCandidateSteps(), this.getConfiguration());
        ArrayList<Description> storyDescriptions = new ArrayList<Description>();
        this.addSuite(storyDescriptions, "BeforeStories");
        storyDescriptions.addAll(descriptionGenerator.createDescriptionFrom(this.createPerformableTree(this.getStoryPaths())));
        this.addSuite(storyDescriptions, "AfterStories");
        return storyDescriptions;
    }

    private int countStories() {
        JUnitDescriptionGenerator descriptionGenerator = new JUnitDescriptionGenerator(this.getCandidateSteps(), this.getConfiguration());
        return descriptionGenerator.getTestCases() + this.beforeAndAfterStorySteps();
    }

    private int beforeAndAfterStorySteps() {
        return 2;
    }

    private PerformableTree createPerformableTree(List<String> storyPaths) {
        ExtendedEmbedder configuredEmbedder = this.getConfiguredEmbedder();
        configuredEmbedder.useMetaFilters(this.getMetaFilters());
        BatchFailures failures = new BatchFailures(configuredEmbedder.embedderControls().verboseFailures());
        PerformableTree performableTree = new PerformableTree();
        PerformableTree.RunContext context = performableTree.newRunContext(this.getConfiguration(), configuredEmbedder.stepsFactory(), configuredEmbedder.embedderMonitor(), configuredEmbedder.metaFilter(), failures);
        performableTree.addStories(context, this.storiesOf(performableTree, storyPaths));
        return performableTree;
    }

    private List<Story> storiesOf(PerformableTree performableTree, List<String> storyPaths) {
        Configuration configuration = this.getConfiguration();
        return storyPaths.parallelStream().map(storyPath -> performableTree.storyOfPath(configuration, storyPath)).collect(Collectors.toList());
    }

    private void addSuite(List<Description> storyDescriptions, String name) {
        storyDescriptions.add(Description.createTestDescription(Object.class, (String)name));
    }

    private boolean metaFiltersAreDefined() {
        String metaFilters = this.getMetafilterSetting();
        return !StringUtils.isEmpty((String)metaFilters);
    }

    private String getMetafilterSetting() {
        Optional<String> environmentMetafilters = this.getEnvironmentMetafilters();
        Optional<String> annotatedMetafilters = this.getAnnotatedMetafilters(this.testClass);
        Optional<String> thucAnnotatedMetafilters = this.getThucAnnotatedMetafilters(this.testClass);
        return environmentMetafilters.orElse(annotatedMetafilters.orElse(thucAnnotatedMetafilters.orElse("")));
    }

    private Optional<String> getEnvironmentMetafilters() {
        return Optional.ofNullable(this.environmentVariables.getProperty(SerenityJBehaveSystemProperties.METAFILTER.getName()));
    }

    @Deprecated
    private Optional<String> getThucAnnotatedMetafilters(Class<? extends ConfigurableEmbedder> testClass) {
        return testClass.getAnnotation(net.thucydides.jbehave.annotations.Metafilter.class) != null ? Optional.of(testClass.getAnnotation(net.thucydides.jbehave.annotations.Metafilter.class).value()) : Optional.empty();
    }

    private Optional<String> getAnnotatedMetafilters(Class<? extends ConfigurableEmbedder> testClass) {
        return testClass.getAnnotation(Metafilter.class) != null ? Optional.of(testClass.getAnnotation(Metafilter.class).value()) : Optional.empty();
    }

    protected boolean getIgnoreFailuresInStories() {
        return this.environmentVariables.getPropertyAsBoolean(SerenityJBehaveSystemProperties.IGNORE_FAILURES_IN_STORIES.getName(), false);
    }

    protected int getStoryTimeoutInSecs() {
        return this.environmentVariables.getPropertyAsInteger(SerenityJBehaveSystemProperties.STORY_TIMEOUT_IN_SECS.getName(), Integer.valueOf((int)this.getConfiguredEmbedder().embedderControls().storyTimeoutInSecs()));
    }

    protected int getThreadCount() {
        return this.environmentVariables.getPropertyAsInteger(SerenityJBehaveSystemProperties.JBEHAVE_THREADS.getName(), Integer.valueOf(1));
    }

    protected String getStoryTimeout() {
        return this.environmentVariables.getProperty(SerenityJBehaveSystemProperties.STORY_TIMEOUT.getName(), this.getConfiguredEmbedder().embedderControls().storyTimeouts());
    }

    protected List<String> getMetaFilters() {
        String metaFilters = this.getMetafilterSetting();
        return Lists.newArrayList((Iterable)Splitter.on((Pattern)Pattern.compile(",")).trimResults().omitEmptyStrings().split((CharSequence)metaFilters));
    }

    protected boolean getIgnoreFailuresInView() {
        return this.environmentVariables.getPropertyAsBoolean(SerenityJBehaveSystemProperties.IGNORE_FAILURES_IN_VIEW.getName(), true);
    }

    public boolean isRunningInMaven() {
        return Stream.of(new Exception().getStackTrace()).anyMatch(elt -> elt.getClassName().contains("maven"));
    }
}

