/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.converters;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.jbehave.core.steps.ParameterConverters;

public class DateListConverter
implements ParameterConverters.ParameterConverter {
    public static final String DEFAULT_LIST_SEPARATOR = ",";
    private final ParameterConverters.DateConverter dateConverter = new ParameterConverters.DateConverter();
    private final String valueSeparator;

    public DateListConverter() {
        this(DEFAULT_LIST_SEPARATOR);
    }

    public DateListConverter(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public boolean accept(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = this.rawType(type);
            Type argumentType = this.argumentType(type);
            return List.class.isAssignableFrom((Class)rawType) && this.dateConverter.accept(argumentType);
        }
        return false;
    }

    public Object convertValue(String value, Type type) {
        Type argumentType = this.argumentType(type);
        List values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
        ArrayList<Date> dates = new ArrayList<Date>();
        for (String string : values) {
            dates.add((Date)this.dateConverter.convertValue(string, argumentType));
        }
        return dates;
    }

    private Type rawType(Type type) {
        return ((ParameterizedType)type).getRawType();
    }

    private Type argumentType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }
}

