/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.converters;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.serenitybdd.jbehave.converters.DateTimeConverter;
import org.jbehave.core.steps.ParameterConverters;
import org.joda.time.DateTime;

public class DateTimeListConverter
implements ParameterConverters.ParameterConverter {
    public static final String DEFAULT_LIST_SEPARATOR = ",";
    private final DateTimeConverter datetimeConverter = new DateTimeConverter();
    private final String valueSeparator;

    public DateTimeListConverter() {
        this(DEFAULT_LIST_SEPARATOR);
    }

    public DateTimeListConverter(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public boolean accept(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = this.rawType(type);
            Type argumentType = this.argumentType(type);
            return List.class.isAssignableFrom((Class)rawType) && this.datetimeConverter.accept(argumentType);
        }
        return false;
    }

    public Object convertValue(String value, Type type) {
        Type argumentType = this.argumentType(type);
        List values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
        ArrayList<DateTime> times = new ArrayList<DateTime>();
        for (String string : values) {
            times.add((DateTime)this.datetimeConverter.convertValue(string, argumentType));
        }
        return times;
    }

    private Type rawType(Type type) {
        return ((ParameterizedType)type).getRawType();
    }

    private Type argumentType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }
}

