/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave.embedders.monitors;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.jbehave.core.embedder.EmbedderControls;
import org.jbehave.core.embedder.EmbedderMonitor;
import org.jbehave.core.embedder.MetaFilter;
import org.jbehave.core.failures.BatchFailures;
import org.jbehave.core.model.Meta;
import org.jbehave.core.model.Scenario;
import org.jbehave.core.model.Story;
import org.jbehave.core.model.StoryDuration;
import org.jbehave.core.model.StoryMaps;
import org.jbehave.core.reporters.ReportsCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeEmbedderMonitor
implements EmbedderMonitor {
    private static final Logger logger = LoggerFactory.getLogger(CompositeEmbedderMonitor.class);
    private Set<EmbedderMonitor> monitors = Collections.newSetFromMap(new ConcurrentHashMap());

    public CompositeEmbedderMonitor(EmbedderMonitor monitor, EmbedderMonitor ... monitors) {
        this.monitors.add(monitor);
        this.monitors.addAll(Arrays.asList(monitors));
    }

    public void subscribe(EmbedderMonitor monitor, EmbedderMonitor ... monitors) {
        this.monitors.add(monitor);
        this.monitors.addAll(Arrays.asList(monitors));
    }

    public void unsubscribe(EmbedderMonitor monitor, EmbedderMonitor ... monitors) {
        this.monitors.remove(monitor);
        this.monitors.removeAll(Arrays.asList(monitors));
    }

    public void runningEmbeddable(String name) {
        logger.debug("runningEmbeddable" + name);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.runningEmbeddable(name);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#runningEmbeddable", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void embeddableFailed(String name, Throwable cause) {
        logger.debug("embeddableFailed" + name);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.embeddableFailed(name, cause);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#embeddableFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void embeddableNotConfigurable(String name) {
        logger.debug("embeddableNotConfigurable" + name);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.embeddableNotConfigurable(name);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#embeddableNotConfigurable", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void embeddablesSkipped(List<String> classNames) {
        logger.debug("embeddablesSkipped" + classNames.size());
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.embeddablesSkipped(classNames);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#embeddablesSkipped", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void metaNotAllowed(Meta meta, MetaFilter filter) {
        logger.debug("metaNotAllowed" + meta + filter);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.metaNotAllowed(meta, filter);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#metaNotAllowed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void runningStory(String path) {
        logger.debug("runningStory" + path);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.runningStory(path);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#runningStory", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void storyFailed(String path, Throwable cause) {
        logger.debug("storyFailed" + path);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.storyFailed(path, cause);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#storyFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void storiesSkipped(List<String> storyPaths) {
        logger.debug("storiesSkipped" + storyPaths);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.storiesSkipped(storyPaths);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#storiesSkipped", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    @Deprecated
    public void storiesNotAllowed(List<Story> notAllowed, MetaFilter filter) {
        logger.debug("storiesNotAllowed" + notAllowed + filter);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.storiesNotAllowed(notAllowed, filter);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#storiesNotAllowed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    @Deprecated
    public void storiesNotAllowed(List<Story> notAllowed, MetaFilter filter, boolean verbose) {
        logger.debug("storiesNotAllowed" + notAllowed + filter + verbose);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.storiesNotAllowed(notAllowed, filter, verbose);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#storiesNotAllowed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void scenarioNotAllowed(Scenario scenario, MetaFilter filter) {
        logger.debug("scenarioNotAllowed" + scenario + filter + filter);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.scenarioNotAllowed(scenario, filter);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#scenarioNotAllowed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void batchFailed(BatchFailures failures) {
        logger.debug("batchFailed" + failures);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.batchFailed(failures);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#batchFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void beforeOrAfterStoriesFailed() {
        logger.debug("beforeOrAfterStoriesFailed");
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.beforeOrAfterStoriesFailed();
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#beforeOrAfterStoriesFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void generatingReportsView(File outputDirectory, List<String> formats, Properties viewProperties) {
        logger.debug("generatingReportsView" + outputDirectory + formats + viewProperties);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.generatingReportsView(outputDirectory, formats, viewProperties);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#generatingReportsView", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void reportsViewGenerationFailed(File outputDirectory, List<String> formats, Properties viewProperties, Throwable cause) {
        logger.debug("reportsViewGenerationFailed" + outputDirectory + formats + viewProperties + cause);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.reportsViewGenerationFailed(outputDirectory, formats, viewProperties, cause);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#reportsViewGenerationFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void reportsViewGenerated(ReportsCount count) {
        logger.debug("reportsViewGenerated" + count);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.reportsViewGenerated(count);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#reportsViewGenerated", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void reportsViewFailures(ReportsCount count) {
        logger.debug("reportsViewFailures" + count);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.reportsViewFailures(count);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#reportsViewFailures", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void reportsViewNotGenerated() {
        logger.debug("reportsViewNotGenerated");
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.reportsViewNotGenerated();
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#reportsViewNotGenerated", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void runningWithAnnotatedEmbedderRunner(String className) {
        logger.debug("runningWithAnnotatedEmbedderRunner" + className);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.runningWithAnnotatedEmbedderRunner(className);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#runningWithAnnotatedEmbedderRunner", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void annotatedInstanceNotOfType(Object annotatedInstance, Class<?> type) {
        logger.debug("annotatedInstanceNotOfType" + annotatedInstance + type);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.annotatedInstanceNotOfType(annotatedInstance, type);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#annotatedInstanceNotOfType", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void mappingStory(String storyPath, List<String> metaFilters) {
        logger.debug("mappingStory" + storyPath + metaFilters);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.mappingStory(storyPath, metaFilters);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#mappingStory", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void generatingMapsView(File outputDirectory, StoryMaps storyMaps, Properties viewProperties) {
        logger.debug("generatingMapsView" + outputDirectory + storyMaps);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.generatingMapsView(outputDirectory, storyMaps, viewProperties);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#generatingMapsView", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void mapsViewGenerationFailed(File outputDirectory, StoryMaps storyMaps, Properties viewProperties, Throwable cause) {
        logger.debug("mapsViewGenerationFailed" + outputDirectory + storyMaps + viewProperties + cause);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.mapsViewGenerationFailed(outputDirectory, storyMaps, viewProperties, cause);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#mapsViewGenerationFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void generatingNavigatorView(File outputDirectory, Properties viewResources) {
        logger.debug("generatingNavigatorView" + outputDirectory + viewResources);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.generatingNavigatorView(outputDirectory, viewResources);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#generatingNavigatorView", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void navigatorViewGenerationFailed(File outputDirectory, Properties viewResources, Throwable cause) {
        logger.debug("navigatorViewGenerationFailed" + outputDirectory + viewResources + cause);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.navigatorViewGenerationFailed(outputDirectory, viewResources, cause);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#navigatorViewGenerationFailed", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void navigatorViewNotGenerated() {
        logger.debug("navigatorViewNotGenerated");
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.navigatorViewNotGenerated();
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#navigatorViewNotGenerated", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void processingSystemProperties(Properties properties) {
        logger.debug("processingSystemProperties" + properties);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.processingSystemProperties(properties);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#processingSystemProperties", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void systemPropertySet(String name, String value) {
        logger.debug("systemPropertySet" + name + value);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.systemPropertySet(name, value);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#systemPropertySet", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void storyTimeout(Story story, StoryDuration storyDuration) {
        logger.debug("storyTimeout" + story + storyDuration);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.storyTimeout(story, storyDuration);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#storyTimeout", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void usingThreads(int threads) {
        logger.debug("usingThreads" + threads);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.usingThreads(threads);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#usingThreads", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void usingExecutorService(ExecutorService executorService) {
        logger.debug("usingExecutorService" + executorService);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.usingExecutorService(executorService);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#usingExecutorService", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void usingControls(EmbedderControls embedderControls) {
        logger.debug("usingControls" + embedderControls);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.usingControls(embedderControls);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#usingControls", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void invalidTimeoutFormat(String path) {
        logger.debug("invalidTimeoutFormat" + path);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.invalidTimeoutFormat(path);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#invalidTimeoutFormat", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    public void usingTimeout(String path, long timeout) {
        logger.debug("usingTimeout" + path + timeout);
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (EmbedderMonitor monitor : this.monitors) {
            try {
                monitor.usingTimeout(path, timeout);
            }
            catch (Exception suppressed) {
                logger.error("exception during calling " + monitor.getClass() + "#usingTimeout", (Throwable)suppressed);
                exceptions.add(suppressed);
            }
        }
        this.processSuppressed(exceptions);
    }

    private void processSuppressed(List<Exception> exceptions) {
        if (exceptions.size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (Exception suppressed : exceptions) {
                builder.append("\"").append(suppressed.getMessage()).append("\" ; ");
            }
            RuntimeException chained = new RuntimeException("Exceptions thrown with messages:" + builder.toString());
            for (Exception suppressed : exceptions) {
                chained.addSuppressed(suppressed);
            }
            throw chained;
        }
    }
}

