/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.serenitybdd.plugins.jira.TestResultTally;
import net.serenitybdd.plugins.jira.domain.IssueComment;
import net.serenitybdd.plugins.jira.guice.Injectors;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.model.NamedTestResult;
import net.serenitybdd.plugins.jira.model.TestResultComment;
import net.serenitybdd.plugins.jira.service.JIRAConfiguration;
import net.serenitybdd.plugins.jira.service.NoSuchIssueException;
import net.serenitybdd.plugins.jira.workflow.Workflow;
import net.serenitybdd.plugins.jira.workflow.WorkflowLoader;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcomeSummary;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraUpdater {
    private static final String BUILD_ID_PROPERTY = "build.id";
    public static final String SKIP_JIRA_UPDATES = "serenity.skip.jira.updates";
    public static final String ADD_NEW_JIRA_COMMENT = "serenity.jira.alwaysnewcomment";
    static int DEFAULT_MAX_THREADS = 4;
    private final IssueTracker issueTracker;
    private final ListeningExecutorService executorService;
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraUpdater.class);
    private final String projectPrefix;
    private Workflow workflow;
    private WorkflowLoader loader;
    private final JIRAConfiguration configuration;

    public JiraUpdater(IssueTracker issueTracker, EnvironmentVariables environmentVariables, WorkflowLoader loader) {
        this.issueTracker = issueTracker;
        this.environmentVariables = environmentVariables;
        this.loader = loader;
        this.configuration = (JIRAConfiguration)Injectors.getInjector().getInstance(JIRAConfiguration.class);
        this.workflow = loader.load();
        this.projectPrefix = environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_PROJECT.getPropertyName());
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.getMaxJobs()));
        this.logStatus(environmentVariables);
    }

    private void logStatus(EnvironmentVariables environmentVariables) {
        String jiraUrl = environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName());
        String reportUrl = ThucydidesSystemProperty.THUCYDIDES_PUBLIC_URL.from(environmentVariables, "");
        LOGGER.debug("JIRA LISTENER STATUS");
        LOGGER.debug("JIRA URL: {} ", (Object)jiraUrl);
        LOGGER.debug("REPORT URL: {} ", (Object)reportUrl);
        LOGGER.debug("WORKFLOW ACTIVE: {} ", (Object)this.workflow.isActive());
    }

    public void updateIssueStatus(Set<String> issues, final TestResultTally<TestOutcomeSummary> resultTally) {
        this.queueSize.set(issues.size());
        for (final String issue : issues) {
            ListenableFuture future = this.executorService.submit((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return issue;
                }
            });
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    JiraUpdater.this.logIssueTracking(issue);
                    if (!JiraUpdater.this.dryRun()) {
                        JiraUpdater.this.updateIssue(issue, resultTally.getTestOutcomesForIssue(issue));
                        JiraUpdater.this.queueSize.decrementAndGet();
                    }
                }
            }, (Executor)MoreExecutors.newDirectExecutorService());
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    JiraUpdater.this.queueSize.decrementAndGet();
                }
            }, (Executor)this.executorService);
        }
        this.waitTillUpdatesDone(this.queueSize);
    }

    private void waitTillUpdatesDone(AtomicInteger counter) {
        while (counter.get() > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean shouldUpdateIssues() {
        String jiraUrl = this.environmentVariables.getProperty(ThucydidesSystemProperty.JIRA_URL.getPropertyName());
        String reportUrl = ThucydidesSystemProperty.THUCYDIDES_PUBLIC_URL.from(this.environmentVariables, "");
        if (this.workflow.isActive()) {
            LOGGER.debug("WORKFLOW TRANSITIONS: {}", (Object)this.workflow.getTransitions());
        }
        return !StringUtils.isEmpty((CharSequence)jiraUrl) && !StringUtils.isEmpty((CharSequence)reportUrl);
    }

    private void updateIssue(String issueId, List<TestOutcomeSummary> testOutcomes) {
        try {
            TestResultComment testResultComment = this.newOrUpdatedCommentFor(issueId, testOutcomes);
            if (this.getWorkflow().isActive() && this.shouldUpdateWorkflow()) {
                this.updateIssueStatusFor(issueId, testResultComment.getOverallResult());
            }
        }
        catch (NoSuchIssueException e) {
            LOGGER.error("No JIRA issue found with ID {}", (Object)issueId);
        }
    }

    private void updateIssueStatusFor(String issueId, TestResult testResult) {
        LOGGER.info("Updating status for issue {} with test result {}", (Object)issueId, (Object)testResult);
        String currentStatus = this.issueTracker.getStatusFor(issueId);
        LOGGER.info("Issue {} currently has status '{}'", (Object)issueId, (Object)currentStatus);
        List<String> transitions = this.getWorkflow().getTransitions().forTestResult(testResult).whenIssueIs(currentStatus);
        LOGGER.info("Found transitions {} for issue {}", transitions, (Object)issueId);
        for (String transition : transitions) {
            this.issueTracker.doTransition(issueId, transition);
        }
    }

    private List<NamedTestResult> namedTestResultsFrom(List<TestOutcomeSummary> testOutcomes) {
        return Lambda.convert(testOutcomes, this.toNamedTestResults());
    }

    private Converter<TestOutcomeSummary, NamedTestResult> toNamedTestResults() {
        return new Converter<TestOutcomeSummary, NamedTestResult>(){

            public NamedTestResult convert(TestOutcomeSummary from) {
                return new NamedTestResult(from.getTitle(), from.getTestResult());
            }
        };
    }

    private TestResultComment newOrUpdatedCommentFor(String issueId, List<TestOutcomeSummary> testOutcomes) {
        TestResultComment testResultComment;
        LOGGER.info("Updating comments for issue {}", (Object)issueId);
        LOGGER.info("WIKI Rendering activated: {}", (Object)this.isWikiRenderedActive());
        List<IssueComment> comments = this.issueTracker.getCommentsFor(issueId);
        IssueComment existingComment = this.findExistingSerenityCommentIn(comments);
        String testRunNumber = this.environmentVariables.getProperty(BUILD_ID_PROPERTY);
        List<NamedTestResult> newTestResults = this.namedTestResultsFrom(testOutcomes);
        if (Boolean.valueOf(this.environmentVariables.getProperty(ADD_NEW_JIRA_COMMENT)).booleanValue()) {
            testResultComment = TestResultComment.comment(this.isWikiRenderedActive()).withResults(this.namedTestResultsFrom(testOutcomes)).withReportUrl(this.linkToReport(testOutcomes)).withTestRun(testRunNumber).asComment();
            this.issueTracker.addComment(issueId, testResultComment.asText());
        } else if (existingComment == null) {
            testResultComment = TestResultComment.comment(this.isWikiRenderedActive()).withResults(this.namedTestResultsFrom(testOutcomes)).withReportUrl(this.linkToReport(testOutcomes)).withTestRun(testRunNumber).asComment();
            this.issueTracker.addComment(issueId, testResultComment.asText());
        } else {
            testResultComment = TestResultComment.fromText(existingComment.getBody()).withWikiRendering(this.isWikiRenderedActive()).withUpdatedTestResults(newTestResults).withUpdatedReportUrl(this.linkToReport(testOutcomes)).withUpdatedTestRunNumber(testRunNumber);
            IssueComment updatedComment = existingComment.withText(testResultComment.asText());
            this.issueTracker.updateComment(issueId, updatedComment);
        }
        return testResultComment;
    }

    private IssueComment findExistingSerenityCommentIn(List<IssueComment> comments) {
        for (IssueComment comment : comments) {
            if (!comment.getBody().contains("Thucydides Test Results")) continue;
            return comment;
        }
        return null;
    }

    private void logIssueTracking(String issueId) {
        if (this.dryRun()) {
            LOGGER.info("--- DRY RUN ONLY: JIRA WILL NOT BE UPDATED ---");
        }
        LOGGER.info("Updating JIRA issue: " + issueId);
        LOGGER.info("JIRA server: " + this.issueTracker.toString());
    }

    private boolean dryRun() {
        return Boolean.valueOf(this.environmentVariables.getProperty(SKIP_JIRA_UPDATES));
    }

    private String linkToReport(List<TestOutcomeSummary> testOutcomes) {
        TestOutcomeSummary firstTestOutcome = testOutcomes.get(0);
        String reportUrl = ThucydidesSystemProperty.THUCYDIDES_PUBLIC_URL.from(this.environmentVariables, "");
        String reportName = firstTestOutcome.getReportName() + ".html";
        return this.formatTestResultsLink(reportUrl, reportName);
    }

    private String formatTestResultsLink(String reportUrl, String reportName) {
        return reportUrl + "/" + reportName;
    }

    private boolean isWikiRenderedActive() {
        return this.configuration.isWikiRenderedActive();
    }

    public List<String> getPrefixedIssuesWithoutHashes(TestOutcomeSummary result) {
        return this.addPrefixesIfRequired(this.stripInitialHashesFrom(this.issueReferencesIn(result)));
    }

    private List<String> addPrefixesIfRequired(List<String> issueNumbers) {
        return Lambda.convert(issueNumbers, this.toIssueNumbersWithPrefixes());
    }

    private List<String> issueReferencesIn(TestOutcomeSummary result) {
        return result.getIssues();
    }

    private Converter<String, String> toIssueNumbersWithPrefixes() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                if (StringUtils.isEmpty((CharSequence)JiraUpdater.this.projectPrefix)) {
                    return issueNumber;
                }
                if (issueNumber.startsWith(JiraUpdater.this.projectPrefix)) {
                    return issueNumber;
                }
                return JiraUpdater.this.projectPrefix + "-" + issueNumber;
            }
        };
    }

    private List<String> stripInitialHashesFrom(List<String> issueNumbers) {
        return Lambda.convert(issueNumbers, this.toIssueNumbersWithoutHashes());
    }

    public int hashCode() {
        return super.hashCode();
    }

    private Converter<String, String> toIssueNumbersWithoutHashes() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                if (issueNumber.startsWith("#")) {
                    return issueNumber.substring(1);
                }
                return issueNumber;
            }
        };
    }

    private int getMaxJobs() {
        return this.environmentVariables.getPropertyAsInteger("jira.max.threads", Integer.valueOf(DEFAULT_MAX_THREADS));
    }

    protected Workflow getWorkflow() {
        return this.workflow;
    }

    protected boolean shouldUpdateWorkflow() {
        return Boolean.valueOf(this.environmentVariables.getProperty("serenity.jira.workflow.active"));
    }

    public IssueTracker getIssueTracker() {
        return this.issueTracker;
    }
}

