/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentMap;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;

public class TestResultTally<T> {
    private final ConcurrentMap<String, List<T>> testOutcomesTally = Maps.newConcurrentMap();

    public synchronized void recordResult(String issueNumber, T outcome) {
        this.getTestOutcomeListForIssue(issueNumber).add(outcome);
    }

    public List<T> getTestOutcomesForIssue(String issueNumber) {
        return ImmutableList.copyOf(this.getTestOutcomeListForIssue(issueNumber));
    }

    protected List<T> getTestOutcomeListForIssue(String issueNumber) {
        List resultTallyForIssue = (List)this.testOutcomesTally.get(issueNumber);
        if (resultTallyForIssue == null) {
            this.testOutcomesTally.putIfAbsent(issueNumber, new Vector());
        }
        return (List)this.testOutcomesTally.get(issueNumber);
    }

    public TestResult getResultForIssue(String issueNumber) {
        List testOutcomesForThisIssue = (List)this.testOutcomesTally.get(issueNumber);
        return TestResultList.overallResultFrom((List)Lambda.convert((Object)testOutcomesForThisIssue, this.toTestResults()));
    }

    private Converter<TestOutcome, TestResult> toTestResults() {
        return new Converter<TestOutcome, TestResult>(){

            public TestResult convert(TestOutcome from) {
                return from.getResult();
            }
        };
    }

    public Set<String> getIssues() {
        return this.testOutcomesTally.keySet();
    }
}

