/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.zephyr.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;

public class HttpClient {
    private static final boolean USE_PROXY = false;
    private static final String PROXY_IP = "xxx.xxx.xxx.xxx";
    private static final int PROXY_PORT = 8080;
    private static final Proxy PROXY = new Proxy(Proxy.Type.HTTP, new InetSocketAddress("xxx.xxx.xxx.xxx", 8080));

    private HttpClient() {
    }

    public static JsonObject httpGetJSONObject(String url, String creds) throws IOException {
        return new JsonParser().parse(HttpClient.httpGetJSONString(url, creds)).getAsJsonObject();
    }

    public static JsonArray httpGetJSONArray(String url, String creds) throws IOException {
        return new JsonParser().parse(HttpClient.httpGetJSONString(url, creds)).getAsJsonArray();
    }

    public static String httpGetJSONString(String url, String creds) throws IOException {
        String line;
        HttpURLConnection httpCon = HttpClient.createHttpCon(url, creds, "GET");
        BufferedReader br = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
        StringBuilder httpResponse = new StringBuilder();
        while (null != (line = br.readLine())) {
            httpResponse.append(line);
        }
        return httpResponse.toString();
    }

    private static JsonObject sendRequest(String url, String creds, JsonObject obj, String method) throws IOException {
        String line;
        HttpURLConnection httpCon = HttpClient.createHttpCon(url, creds, method);
        if (null != obj && !"{}".equalsIgnoreCase(obj.toString())) {
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());
            out.write(obj.toString());
            out.close();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
        StringBuilder result = new StringBuilder();
        while (null != (line = rd.readLine())) {
            result.append(line);
        }
        return new JsonParser().parse(result.toString()).getAsJsonObject();
    }

    private static JsonObject sendRequest(String url, String creds, String jsonObj, String method) throws IOException {
        String line;
        HttpURLConnection httpCon = HttpClient.createHttpCon(url, creds, method);
        if (null != jsonObj) {
            OutputStreamWriter out = new OutputStreamWriter(httpCon.getOutputStream());
            out.write(jsonObj);
            out.close();
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
        StringBuilder result = new StringBuilder();
        while (null != (line = rd.readLine())) {
            result.append(line);
        }
        return new JsonParser().parse(result.toString()).getAsJsonObject();
    }

    public static JsonObject put(String url, String creds, JsonObject obj) throws IOException {
        return HttpClient.sendRequest(url, creds, obj, "PUT");
    }

    public static JsonObject put(String url, String creds, String jsonObj) throws IOException {
        return HttpClient.sendRequest(url, creds, jsonObj, "PUT");
    }

    public static JsonObject post(String url, String creds, JsonObject obj) throws IOException {
        return HttpClient.sendRequest(url, creds, obj, "POST");
    }

    public static JsonObject post(String url, String creds, String jsonObj) throws IOException {
        return HttpClient.sendRequest(url, creds, jsonObj, "POST");
    }

    public static JsonObject delete(String url, String creds) throws IOException {
        return HttpClient.sendRequest(url, creds, new JsonObject(), "DELETE");
    }

    public static JsonObject delete(String url, String creds, String jsonObj) throws IOException {
        return HttpClient.sendRequest(url, creds, jsonObj, "DELETE");
    }

    private static HttpURLConnection createHttpCon(String url, String creds, String method) throws IOException {
        HttpURLConnection httpCon = (HttpURLConnection)new URL(url).openConnection();
        httpCon.setDoOutput(true);
        httpCon.setRequestMethod(method);
        if (!creds.isEmpty()) {
            String encoding = new Base64().encodeToString(creds.getBytes());
            httpCon.setRequestProperty("Authorization", "Basic " + encoding);
        }
        httpCon.setRequestProperty("Content-type", "application/json");
        return httpCon;
    }
}

