/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.plugins.jira.JiraUpdater;
import net.serenitybdd.plugins.jira.TestResultTally;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.service.JIRAInfrastructure;
import net.serenitybdd.plugins.jira.workflow.WorkflowLoader;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestOutcomeSummary;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;
import net.thucydides.model.steps.StepListener;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraStepListener
implements StepListener {
    private final TestResultTally<TestOutcomeSummary> resultTally = new TestResultTally();
    private final Set<String> testSuiteIssues = new CopyOnWriteArraySet<String>();
    private final JiraUpdater jiraUpdater;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraStepListener.class);

    public JiraStepListener(IssueTracker issueTracker, EnvironmentVariables environmentVariables, WorkflowLoader loader) {
        this.jiraUpdater = new JiraUpdater(issueTracker, environmentVariables, loader);
    }

    public JiraStepListener() {
        this(JIRAInfrastructure.getIssueTracker(), ModelInfrastructure.getEnvironmentVariables(), JIRAInfrastructure.getWorkflowLoader());
    }

    public void testSuiteStarted(Class<?> testCase) {
        this.testSuiteIssues.clear();
    }

    public void testSuiteStarted(Story story) {
        this.testSuiteIssues.clear();
    }

    public void testStarted(String testName) {
    }

    public void testStarted(String description, String id) {
    }

    public void testStarted(String description, String id, ZonedDateTime startTime) {
    }

    public void testFinished(TestOutcome result) {
        boolean shouldUpdateIssues = this.jiraUpdater.shouldUpdateIssues();
        LOGGER.info("TestFinished updateIssues=" + shouldUpdateIssues);
        if (shouldUpdateIssues) {
            List<String> issues = this.jiraUpdater.getPrefixedIssuesWithoutHashes(new TestOutcomeSummary(result));
            this.tallyResults(new TestOutcomeSummary(result), issues);
            this.testSuiteIssues.addAll(issues);
        }
    }

    public void testFinished(TestOutcome result, boolean isInDataDrivenTest, ZonedDateTime finishTime) {
        this.testFinished(result);
    }

    public void testFinished(TestOutcome result, boolean isInDataDrivenTest) {
        this.testFinished(result);
    }

    private void tallyResults(TestOutcomeSummary result, List<String> issues) {
        for (String issue : issues) {
            this.resultTally.recordResult(issue, result);
        }
    }

    public void testSuiteFinished() {
        if (this.jiraUpdater.shouldUpdateIssues()) {
            this.jiraUpdater.updateIssueStatus(this.testSuiteIssues, this.resultTally);
        }
    }

    public void testRetried() {
    }

    public void stepStarted(ExecutedStepDescription executedStepDescription) {
    }

    public void skippedStepStarted(ExecutedStepDescription description) {
    }

    public void stepFailed(StepFailure stepFailure) {
    }

    public void stepFailed(StepFailure failure, List<ScreenshotAndHtmlSource> screenshotList) {
    }

    public void lastStepFailed(StepFailure stepFailure) {
    }

    public void stepIgnored() {
    }

    public void stepIgnored(String s) {
    }

    public void stepPending() {
    }

    public void stepPending(String s) {
    }

    public void assumptionViolated(String s) {
    }

    public void testRunFinished() {
    }

    public void takeScreenshots(List<ScreenshotAndHtmlSource> screenshots) {
    }

    public void takeScreenshots(TestResult testResult, List<ScreenshotAndHtmlSource> screenshots) {
    }

    public void stepFinished() {
    }

    public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList) {
    }

    public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList, ZonedDateTime time) {
    }

    public void testFailed(TestOutcome testOutcome, Throwable cause) {
    }

    public void testIgnored() {
    }

    public void testSkipped() {
    }

    public void testPending() {
    }

    public void testIsManual() {
    }

    public void notifyScreenChange() {
    }

    public void useExamplesFrom(DataTable dataTable) {
    }

    public void addNewExamplesFrom(DataTable dataTable) {
    }

    public void exampleStarted(Map<String, String> stringStringMap) {
    }

    public void exampleStarted() {
    }

    public void exampleFinished() {
    }

    public TestResultTally getTestResultTally() {
        return this.resultTally;
    }

    public Set<String> getTestSuiteIssues() {
        return this.testSuiteIssues;
    }

    public JiraUpdater getJiraUpdater() {
        return this.jiraUpdater;
    }
}

