/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.domain;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import net.serenitybdd.plugins.jira.domain.Author;

public class IssueComment {
    public static final String BODY_KEY = "body";
    public static final String SELF_KEY = "self";
    public static final String AUTHOR_KEY = "author";
    public static final String UPDATE_AUTHOR_KEY = "author";
    public static final String CREATED_KEY = "created";
    public static final String UPDATED_KEY = "updated";
    private String author;
    private String body;
    private Calendar created;
    private String groupLevel;
    private Long id;
    private String roleLevel;
    private String updateAuthor;
    private String self;
    private Calendar updated;

    public IssueComment() {
    }

    public IssueComment(String body) {
        this.body = body;
    }

    public IssueComment(String self, Long id, String body, String author) {
        this.self = self;
        this.id = id;
        this.body = body;
        this.author = author;
    }

    public IssueComment(String self, String author, String body, Calendar created, String groupLevel, Long id, String roleLevel, String updateAuthor, Calendar updated) {
        this.self = self;
        this.author = author;
        this.body = body;
        this.created = created;
        this.groupLevel = groupLevel;
        this.id = id;
        this.roleLevel = roleLevel;
        this.updateAuthor = updateAuthor;
        this.updated = updated;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Calendar getCreated() {
        return this.created;
    }

    public void setCreated(Calendar created) {
        this.created = created;
    }

    public String getGroupLevel() {
        return this.groupLevel;
    }

    public void setGroupLevel(String groupLevel) {
        this.groupLevel = groupLevel;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getRoleLevel() {
        return this.roleLevel;
    }

    public void setRoleLevel(String roleLevel) {
        this.roleLevel = roleLevel;
    }

    public String getUpdateAuthor() {
        return this.updateAuthor;
    }

    public void setUpdateAuthor(String updateAuthor) {
        this.updateAuthor = updateAuthor;
    }

    public Calendar getUpdated() {
        return this.updated;
    }

    public String getSelf() {
        return this.self;
    }

    public IssueComment withText(String text) {
        return new IssueComment(this.self, this.id, text, this.author);
    }

    public IssueComment withAuthor(String author) {
        return new IssueComment(this.self, this.id, this.body, author);
    }

    public static IssueComment fromJsonString(String jsonCommentRepresentation) throws ParseException {
        JsonParser parser = new JsonParser();
        JsonObject currentComment = parser.parse(jsonCommentRepresentation).getAsJsonObject();
        JsonObject authorJsonObject = currentComment.getAsJsonObject("author");
        Author author = Author.fromJsonString(authorJsonObject.toString());
        String self = currentComment.getAsJsonPrimitive(SELF_KEY).getAsString();
        String body = currentComment.getAsJsonPrimitive(BODY_KEY).getAsString();
        JsonObject updateAuthorJsonObject = currentComment.getAsJsonObject("author");
        Author updateAuthor = Author.fromJsonString(updateAuthorJsonObject.toString());
        String createdDate = currentComment.getAsJsonPrimitive(CREATED_KEY).getAsString();
        String updatedDate = currentComment.getAsJsonPrimitive(UPDATED_KEY).getAsString();
        Calendar createdCalendar = GregorianCalendar.getInstance();
        createdCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(createdDate));
        Calendar updatedCalendar = GregorianCalendar.getInstance();
        updatedCalendar.setTime(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(updatedDate));
        return new IssueComment(self, author.getAccountId(), body, createdCalendar, "", 0L, "", updateAuthor.getAccountId(), updatedCalendar);
    }
}

