/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.plugins.jira.JiraUpdater;
import net.serenitybdd.plugins.jira.TestResultTally;
import net.serenitybdd.plugins.jira.model.IssueTracker;
import net.serenitybdd.plugins.jira.service.JIRAInfrastructure;
import net.serenitybdd.plugins.jira.workflow.WorkflowLoader;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestOutcomeSummary;
import net.thucydides.model.steps.StepListenerAdapter;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraStepListener
extends StepListenerAdapter {
    private final TestResultTally<TestOutcomeSummary> resultTally = new TestResultTally();
    private final Set<String> testSuiteIssues = new CopyOnWriteArraySet<String>();
    private final JiraUpdater jiraUpdater;
    private static final Logger LOGGER = LoggerFactory.getLogger(JiraStepListener.class);

    public JiraStepListener(IssueTracker issueTracker, EnvironmentVariables environmentVariables, WorkflowLoader loader) {
        this.jiraUpdater = new JiraUpdater(issueTracker, environmentVariables, loader);
    }

    public JiraStepListener() {
        this(JIRAInfrastructure.getIssueTracker(), ModelInfrastructure.getEnvironmentVariables(), JIRAInfrastructure.getWorkflowLoader());
    }

    public void testSuiteStarted(Class<?> testCase) {
        this.testSuiteIssues.clear();
    }

    public void testSuiteStarted(Story story) {
        this.testSuiteIssues.clear();
    }

    public void testFinished(TestOutcome result) {
        boolean shouldUpdateIssues = this.jiraUpdater.shouldUpdateIssues();
        LOGGER.info("TestFinished updateIssues=" + shouldUpdateIssues);
        if (shouldUpdateIssues) {
            List<String> issues = this.jiraUpdater.getPrefixedIssuesWithoutHashes(new TestOutcomeSummary(result));
            this.tallyResults(new TestOutcomeSummary(result), issues);
            this.testSuiteIssues.addAll(issues);
        }
    }

    public void testFinished(TestOutcome result, boolean isInDataDrivenTest, ZonedDateTime finishTime) {
        this.testFinished(result);
    }

    public void testFinished(TestOutcome result, boolean isInDataDrivenTest) {
        this.testFinished(result);
    }

    private void tallyResults(TestOutcomeSummary result, List<String> issues) {
        for (String issue : issues) {
            this.resultTally.recordResult(issue, result);
        }
    }

    public void testSuiteFinished() {
        if (this.jiraUpdater.shouldUpdateIssues()) {
            this.jiraUpdater.updateIssueStatus(this.testSuiteIssues, this.resultTally);
        }
    }

    public TestResultTally getTestResultTally() {
        return this.resultTally;
    }

    public Set<String> getTestSuiteIssues() {
        return this.testSuiteIssues;
    }

    public JiraUpdater getJiraUpdater() {
        return this.jiraUpdater;
    }
}

