/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.plugins.jira.client;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import net.serenitybdd.plugins.jira.client.FindByJQLLoader;
import net.serenitybdd.plugins.jira.client.FindByJQLLoaderUsingBatches;
import net.serenitybdd.plugins.jira.client.FindByKeyLoader;
import net.serenitybdd.plugins.jira.client.JIRAAuthenticationError;
import net.serenitybdd.plugins.jira.client.JIRAConfigurationError;
import net.serenitybdd.plugins.jira.client.LoadingStrategy;
import net.serenitybdd.plugins.jira.client.Redirector;
import net.serenitybdd.plugins.jira.domain.IssueComment;
import net.serenitybdd.plugins.jira.domain.IssueSummary;
import net.serenitybdd.plugins.jira.domain.IssueTransition;
import net.serenitybdd.plugins.jira.domain.Project;
import net.serenitybdd.plugins.jira.domain.Version;
import net.serenitybdd.plugins.jira.model.CascadingSelectOption;
import net.serenitybdd.plugins.jira.model.CustomField;
import net.serenitybdd.plugins.jira.model.JQLException;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyJiraClient {
    private static final String ADD_COMMENT = "rest/api/latest/issue/%s/comment";
    private static final String UPDATE_COMMENT = "rest/api/latest/issue/%s/comment/%s";
    private static final String REST_SEARCH = "rest/api/latest/search";
    private static final String VERSIONS_SEARCH = "rest/api/latest/project/%s/versions";
    private static final String ISSUE = "rest/api/latest/issue/";
    private static final String PROJECT = "rest/api/latest/project";
    private static final String GET_TRANSITIONS = "rest/api/latest/issue/%s/transitions";
    private static final int REDIRECT_REQUEST = 302;
    private static final String DEFAULT_ISSUE_TYPE = "Bug";
    private static final int WITH_NO_BATCHES = 0;
    private final String url;
    private final String username;
    private final String password;
    private final int batchSize;
    private final String project;
    private final List<String> customFields;
    private Map<String, CustomField> customFieldsIndex;
    private Map<String, String> customFieldNameIndex;
    private String metadataIssueType;
    private LoadingCache<String, Optional<IssueSummary>> issueSummaryCache;
    private Map<LoadingStrategy, LoadingCache<String, List<IssueSummary>>> issueQueryCachePerStrategy;
    private final Logger logger = LoggerFactory.getLogger(JerseyJiraClient.class);
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int OK = 200;
    private static final int CREATE_ISSUE_OK = 201;
    private static final int DELETE_ISSUE_OK = 204;

    public JerseyJiraClient(String url, String username, String password, String project) {
        this(url, username, password, 100, project);
    }

    public JerseyJiraClient(String url, String username, String password, String project, List<String> customFields) {
        this(url, username, password, 100, project, DEFAULT_ISSUE_TYPE, customFields);
    }

    public JerseyJiraClient(String url, String username, String password, int batchSize, String project, String metadataIssueType, List<String> customFields) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.batchSize = batchSize;
        this.project = project;
        this.metadataIssueType = metadataIssueType;
        this.customFields = ImmutableList.copyOf(customFields);
        this.issueSummaryCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new FindByKeyLoader(this));
        LoadingCache issueQueryCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new FindByJQLLoader(this));
        LoadingCache batchedIssueQueryCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new FindByJQLLoaderUsingBatches(this));
        this.issueQueryCachePerStrategy = ImmutableMap.of((Object)((Object)LoadingStrategy.LOAD_IN_SINGLE_QUERY), (Object)issueQueryCache, (Object)((Object)LoadingStrategy.LOAD_IN_BATCHES), (Object)batchedIssueQueryCache);
    }

    public JerseyJiraClient(String url, String username, String password, int batchSize, String project) {
        this(url, username, password, batchSize, project, DEFAULT_ISSUE_TYPE, Collections.EMPTY_LIST);
    }

    public JerseyJiraClient usingCustomFields(List<String> customFields) {
        return new JerseyJiraClient(this.url, this.username, this.password, this.batchSize, this.project, this.metadataIssueType, customFields);
    }

    public JerseyJiraClient usingMetadataIssueType(String metadataIssueType) {
        return new JerseyJiraClient(this.url, this.username, this.password, this.batchSize, this.project, metadataIssueType, this.customFields);
    }

    public List<IssueSummary> findByJQL(String query, LoadingStrategy loadingStrategy) throws JQLException {
        try {
            Preconditions.checkNotNull((Object)query, (Object)"JIRA key cannot be null");
            return (List)this.issueQueryCachePerStrategy.get((Object)loadingStrategy).get((Object)query);
        }
        catch (ExecutionException e) {
            throw new JQLException(e.getCause());
        }
        catch (RuntimeException runtimeException) {
            throw new JQLException(runtimeException.getCause());
        }
    }

    public List<IssueSummary> findByJQL(String query) throws JQLException {
        return this.findByJQL(query, LoadingStrategy.LOAD_IN_SINGLE_QUERY);
    }

    protected List<IssueSummary> loadByJQLBatches(String query) {
        int total = this.countByJQL(query);
        ArrayList<IssueSummary> issues = new ArrayList<IssueSummary>();
        int startAt = 0;
        while (issues.size() < total) {
            String jsonResponse = this.getJSONResponse(query, startAt, this.batchSize);
            JsonObject responseObject = new JsonParser().parse(jsonResponse).getAsJsonObject();
            JsonArray issueEntries = (JsonArray)responseObject.get("issues");
            for (int i = 0; i < issueEntries.size(); ++i) {
                JsonObject issueObject = issueEntries.get(i).getAsJsonObject();
                issues.add(this.convertToIssueSummary(issueObject));
            }
            startAt += this.getBatchSize();
        }
        return issues;
    }

    protected List<IssueSummary> loadByJQL(String query) {
        ArrayList<IssueSummary> issues = new ArrayList<IssueSummary>();
        String jsonResponse = this.getJSONResponse(query, 0, 0);
        JsonObject responseObject = new JsonParser().parse(jsonResponse).getAsJsonObject();
        JsonArray issueEntries = (JsonArray)responseObject.get("issues");
        if (issueEntries != null) {
            for (int i = 0; i < issueEntries.size(); ++i) {
                JsonObject issueObject = issueEntries.get(i).getAsJsonObject();
                issues.add(this.convertToIssueSummary(issueObject));
            }
        }
        return issues;
    }

    public List<Version> findVersionsForProject(String projectName) {
        String versionData = this.getJSONProjectVersions(projectName);
        return this.convertJSONVersions(versionData);
    }

    private List<Version> convertJSONVersions(String versionData) {
        ArrayList<Version> versions = new ArrayList<Version>();
        JsonArray versionEntries = new JsonParser().parse(versionData).getAsJsonArray();
        for (int i = 0; i < versionEntries.size(); ++i) {
            JsonObject issueObject = versionEntries.get(i).getAsJsonObject();
            versions.add(this.convertToVersion(issueObject));
        }
        return versions;
    }

    public WebTarget buildWebTargetFor(String path) {
        return this.restClient().target(this.url).path(path);
    }

    private String getJSONResponse(String query, int startAt, int batchSize) {
        String fields = "key,status,summary,description,comment,issuetype,labels,fixVersions";
        fields = this.addCustomFieldsTo(fields);
        WebTarget target = this.buildWebTargetFor(REST_SEARCH).queryParam("jql", new Object[]{query}).queryParam("startAt", new Object[]{startAt}).queryParam("expand", new Object[]{"renderedFields"}).queryParam("fields", new Object[]{fields});
        if (batchSize > 0) {
            target = target.queryParam("maxResults", new Object[]{batchSize});
        }
        Response response = target.request().get();
        this.checkValid(response);
        return (String)response.readEntity(String.class);
    }

    private String addCustomFieldsTo(String fields) {
        for (String customField : this.customFields) {
            if (!this.getCustomFieldsIndex().containsKey(customField)) continue;
            fields = (String)fields + "," + this.getCustomFieldsIndex().get(customField).getId();
        }
        return fields;
    }

    private String getJSONProjectVersions(String projectName) {
        String url = String.format(VERSIONS_SEARCH, projectName);
        WebTarget target = this.buildWebTargetFor(url);
        Response response = target.request().get();
        this.checkValid(response);
        return (String)response.readEntity(String.class);
    }

    public Optional<IssueSummary> findByKey(String key) throws JQLException {
        try {
            Preconditions.checkNotNull((Object)key, (Object)"JIRA key cannot be null");
            return (Optional)this.issueSummaryCache.get((Object)key);
        }
        catch (ExecutionException e) {
            throw new JQLException(e.getCause());
        }
        catch (RuntimeException runtimeException) {
            throw new JQLException(runtimeException.getCause());
        }
    }

    public Optional<IssueSummary> loadByKey(String key) {
        Optional<String> jsonResponse = this.readFieldValues(this.url, ISSUE + key);
        if (jsonResponse.isPresent()) {
            JsonObject responseObject = new JsonParser().parse(jsonResponse.get()).getAsJsonObject();
            return Optional.of(this.convertToIssueSummary(responseObject));
        }
        return Optional.empty();
    }

    private Version convertToVersion(JsonObject issueObject) {
        return new Version(this.uriFrom(issueObject), issueObject.getAsJsonPrimitive("id").getAsLong(), this.stringValueOf(issueObject.get("name")), this.booleanValueOf(issueObject.get("archived")), this.booleanValueOf(issueObject.get("released")));
    }

    private IssueSummary convertToIssueSummary(JsonObject issueObject) {
        JsonObject fields = (JsonObject)issueObject.get("fields");
        JsonObject renderedFields = (JsonObject)issueObject.get("renderedFields");
        JsonObject issueType = (JsonObject)fields.get("issuetype");
        JsonObject issueStatus = (JsonObject)fields.get("status");
        JsonObject comments = (JsonObject)fields.get("comment");
        Map<String, String> renderedFieldValues = this.renderedFieldValuesFrom(renderedFields);
        return new IssueSummary(this.uriFrom(issueObject), issueObject.getAsJsonPrimitive("id").getAsLong(), this.stringValueOf(issueObject.get("key")), this.stringValueOf(fields.get("summary")), this.stringValueOf(this.optional(fields, "description")), renderedFieldValues, this.stringValueOf(issueType.get("name")), this.stringValueOf(issueStatus.get("name")), this.toList((JsonArray)fields.get("labels")), this.toListOfVersions((JsonArray)fields.get("fixVersions")), this.customFieldValuesIn(fields, renderedFields), this.commentsIn(comments));
    }

    private List<IssueComment> commentsIn(JsonObject comments) {
        ArrayList issueComments = Lists.newArrayList();
        JsonArray commentList = comments.getAsJsonArray("comments");
        for (int i = 0; i < commentList.size(); ++i) {
            JsonObject fieldObject = commentList.get(i).getAsJsonObject();
            issueComments.add(this.convertToComment(fieldObject));
        }
        return issueComments;
    }

    private IssueComment convertToComment(JsonObject fieldObject) {
        return new IssueComment(fieldObject.getAsJsonPrimitive("self").getAsString(), fieldObject.getAsJsonPrimitive("id").getAsLong(), fieldObject.getAsJsonPrimitive("body").getAsString(), fieldObject.getAsJsonObject("author").getAsJsonPrimitive("accountId").getAsString());
    }

    private Map<String, String> renderedFieldValuesFrom(JsonObject renderedFields) {
        HashMap<String, String> renderedFieldMap = new HashMap<String, String>();
        Set entries = renderedFields.entrySet();
        for (Map.Entry currentEntry : entries) {
            String fieldName = (String)currentEntry.getKey();
            JsonElement element = (JsonElement)currentEntry.getValue();
            if (element.isJsonNull()) continue;
            String renderedValue = "";
            if (element.isJsonPrimitive()) {
                renderedValue = element.getAsJsonPrimitive().getAsString();
            } else if (element.isJsonObject()) {
                renderedValue = element.toString();
            }
            if (this.getCustomFieldNameIndex().containsKey(fieldName)) {
                fieldName = this.getCustomFieldNameIndex().get(currentEntry.getKey());
            }
            renderedFieldMap.put(fieldName, renderedValue);
        }
        return renderedFieldMap;
    }

    private Map<String, Object> customFieldValuesIn(JsonObject fields, JsonObject renderedFields) {
        HashMap<String, Object> customFieldValues = new HashMap<String, Object>();
        for (String customFieldName : this.customFields) {
            CustomField customField = this.getCustomFieldsIndex().get(customFieldName);
            if (!this.customFieldDefined(fields, renderedFields, customField)) continue;
            Object customFieldValue = this.readFieldValue(fields, customField);
            customFieldValues.put(customFieldName, customFieldValue);
        }
        return customFieldValues;
    }

    private boolean customFieldDefined(JsonObject fields, JsonObject renderedFields, CustomField customField) {
        if (customField != null) {
            return this.hasCustomFieldValue(fields, customField) || this.hasCustomFieldValue(renderedFields, customField);
        }
        return false;
    }

    private boolean hasCustomFieldValue(JsonObject fields, CustomField customField) {
        return fields.has(customField.getId()) && !fields.get(customField.getId()).equals(null);
    }

    private Object readFieldValue(JsonObject fields, CustomField customField) {
        String fieldId = customField.getId();
        String fieldValue = "";
        if (this.fieldIsDefined(fields, fieldId)) {
            if (fields.get(fieldId).isJsonPrimitive()) {
                fieldValue = fields.getAsJsonPrimitive(fieldId).getAsString();
            } else if (fields.get(fieldId).isJsonObject()) {
                fieldValue = fields.getAsJsonObject(fieldId).toString();
            }
        }
        if (this.isJSON(fieldValue)) {
            JsonObject field = new JsonParser().parse(fieldValue).getAsJsonObject();
            if (customField.getType().equals("string") || customField.getType().equals("option")) {
                return field.equals((Object)JsonNull.INSTANCE) ? "" : field.getAsJsonPrimitive("value").getAsString();
            }
            if (customField.getType().equals("array") || customField.getType().equals("option-with-child")) {
                return this.readListFrom(field);
            }
        }
        return fieldValue;
    }

    private boolean fieldIsDefined(JsonObject fields, String fieldId) {
        return fields.has(fieldId) && !fields.get(fieldId).isJsonNull();
    }

    private boolean isJSON(String fieldValue) {
        return fieldValue.trim().startsWith("{");
    }

    private List<String> readListFrom(JsonObject jsonField) {
        ArrayList values = Lists.newArrayList();
        values.add(jsonField.getAsJsonPrimitive("value").getAsString());
        if (jsonField.has("child")) {
            values.addAll(this.readListFrom(jsonField.getAsJsonObject("child")));
        }
        return values;
    }

    private List<CustomField> convertToCustomFields(JsonArray customFieldsList) {
        ArrayList customFields = Lists.newArrayList();
        for (int i = 0; i < customFieldsList.size(); ++i) {
            JsonObject fieldObject = customFieldsList.get(i).getAsJsonObject();
            customFields.add(this.convertToCustomField(fieldObject));
        }
        return customFields;
    }

    private CustomField convertToCustomField(JsonObject fieldObject) {
        return new CustomField(fieldObject.getAsJsonPrimitive("id").getAsString(), fieldObject.getAsJsonPrimitive("name").getAsString(), this.fieldTypeOf(fieldObject));
    }

    private String fieldTypeOf(JsonObject fieldObject) {
        if (fieldObject.has("schema")) {
            return fieldObject.getAsJsonObject("schema").getAsJsonPrimitive("type").getAsString();
        }
        return "string";
    }

    private JsonElement optional(JsonObject fields, String fieldName) {
        return fields.has(fieldName) ? fields.get(fieldName) : null;
    }

    private List<String> toList(JsonArray array) {
        ArrayList list = Lists.newArrayList();
        if (array == null) {
            return list;
        }
        for (int i = 0; i < array.size(); ++i) {
            list.add(this.stringValueOf(array.get(i)));
        }
        return list;
    }

    private List<String> toListOfVersions(JsonArray array) {
        ArrayList list = Lists.newArrayList();
        if (array == null) {
            return list;
        }
        for (int i = 0; i < array.size(); ++i) {
            JsonObject versionObject = (JsonObject)array.get(i);
            list.add(versionObject.getAsJsonPrimitive("name").getAsString());
        }
        return list;
    }

    private URI uriFrom(JsonObject issueObject) {
        try {
            return new URI(issueObject.getAsJsonPrimitive("self").getAsString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Self field not a valid URL");
        }
    }

    public Integer countByJQL(String query) {
        WebTarget target = this.buildWebTargetFor(REST_SEARCH).queryParam("jql", new Object[]{query}).queryParam("maxResults", new Object[]{0});
        Response response = target.request().get();
        if (this.isEmpty(response)) {
            return 0;
        }
        this.checkValid(response);
        String jsonResponse = (String)response.readEntity(String.class);
        JsonObject responseObject = new JsonParser().parse(jsonResponse).getAsJsonObject();
        int total = responseObject.getAsJsonPrimitive("total").getAsInt();
        this.logger.debug("Count by JQL for {}", (Object)query);
        return total;
    }

    private Optional<String> readFieldValues(String url, String path) {
        WebTarget target = this.restClient().target(url).path(path).queryParam("expand", new Object[]{"renderedFields"});
        Response response = target.request().get();
        if (response.getStatus() == 302) {
            response = Redirector.forPath(path).usingClient(this.restClient()).followRedirectsIn(response);
        }
        if (this.resourceDoesNotExist(response)) {
            return Optional.empty();
        }
        this.checkValid(response);
        return Optional.of((String)response.readEntity(String.class));
    }

    private Optional<String> readFieldMetadata(String url, String path) {
        WebTarget target = this.restClient().target(url).path(path).queryParam("expand", new Object[]{"renderedFields"}).queryParam("project", new Object[]{this.project}).queryParam("issuetypeName", new Object[]{this.metadataIssueType}).queryParam("expand", new Object[]{"projects.issuetypes.fields"});
        Response response = target.request().get();
        if (response.getStatus() == 302) {
            response = Redirector.forPath(path).usingClient(this.restClient()).followRedirectsIn(response);
        }
        if (this.resourceDoesNotExist(response)) {
            return Optional.empty();
        }
        this.checkValid(response);
        return Optional.of((String)response.readEntity(String.class));
    }

    public Client restClient() {
        return ((ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().register((Object)HttpAuthenticationFeature.basic((String)this.username, (String)this.password))).property("jersey.config.client.followRedirects", (Object)Boolean.TRUE)).build();
    }

    private String stringValueOf(JsonElement field) {
        if (field != null) {
            if (field.isJsonPrimitive()) {
                return field.getAsJsonPrimitive().getAsString();
            }
            if (field.isJsonObject()) {
                return field.getAsJsonObject().toString();
            }
            return field.toString();
        }
        return null;
    }

    private boolean booleanValueOf(JsonElement field) {
        if (field != null) {
            return Boolean.valueOf(field.toString());
        }
        return false;
    }

    public boolean resourceDoesNotExist(Response response) {
        return response.getStatus() == 404;
    }

    public boolean isEmpty(Response response) {
        return response.getStatus() == 400;
    }

    public void checkValid(Response response) {
        int status = response.getStatus();
        if (status != 200 && status != 201 && status != 204) {
            switch (status) {
                case 400: {
                    return;
                }
                case 401: {
                    this.handleAuthenticationError("Authentication error (401) for user " + this.username);
                }
                case 403: {
                    this.handleAuthenticationError("Forbidden error (403) for user " + this.username);
                }
                case 404: {
                    this.handleConfigurationError("Service not found (404) - try checking the JIRA URL?");
                }
                case 407: {
                    this.handleConfigurationError("Proxy authentication required (407)");
                }
            }
            throw new JQLException("JIRA query failed: error " + status);
        }
    }

    private void handleAuthenticationError(String message) {
        throw new JIRAAuthenticationError(message);
    }

    private void handleConfigurationError(String message) {
        throw new JIRAConfigurationError(message);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    private Map<String, CustomField> getCustomFieldsIndex() {
        if (this.customFieldsIndex == null) {
            this.customFieldsIndex = this.indexCustomFields();
        }
        return this.customFieldsIndex;
    }

    private Map<String, String> getCustomFieldNameIndex() {
        if (this.customFieldNameIndex == null) {
            this.customFieldNameIndex = this.indexCustomFieldNames();
        }
        return this.customFieldNameIndex;
    }

    private Map<String, String> indexCustomFieldNames() {
        HashMap<String, String> index = new HashMap<String, String>();
        for (CustomField field : this.getExistingCustomFields()) {
            index.put(field.getId(), field.getName());
        }
        return index;
    }

    private Map<String, CustomField> indexCustomFields() {
        HashMap<String, CustomField> index = new HashMap<String, CustomField>();
        for (CustomField field : this.getExistingCustomFields()) {
            index.put(field.getName(), field);
        }
        return index;
    }

    private List<CustomField> getExistingCustomFields() {
        Optional<String> jsonResponse = this.readFieldValues(this.url, "rest/api/2/field");
        if (jsonResponse.isPresent()) {
            JsonArray responseObject = new JsonParser().parse(jsonResponse.get()).getAsJsonArray();
            return this.convertToCustomFields(responseObject);
        }
        return Collections.EMPTY_LIST;
    }

    List<CustomField> getCustomFields() {
        ArrayList registeredCustomFields = Lists.newArrayList();
        for (String fieldName : this.customFields) {
            registeredCustomFields.add(this.getCustomFieldsIndex().get(fieldName));
        }
        return registeredCustomFields;
    }

    public List<CascadingSelectOption> findOptionsForCascadingSelect(String fieldName) {
        ArrayList<CascadingSelectOption> result = new ArrayList<CascadingSelectOption>();
        Optional<String> jsonResponse = this.readFieldMetadata(this.url, "rest/api/2/issue/createmeta");
        if (jsonResponse.isPresent()) {
            JsonObject responseObject = new JsonParser().parse(jsonResponse.get()).getAsJsonObject();
            JsonArray projects = responseObject.getAsJsonArray("projects");
            for (JsonElement pr : projects) {
                JsonObject project = pr.getAsJsonObject();
                JsonArray issueTypes = project.getAsJsonArray("issuetypes");
                for (JsonElement st : issueTypes) {
                    JsonObject issueType = st.getAsJsonObject();
                    JsonObject fields = issueType.getAsJsonObject("fields");
                    Iterator fieldKeys = fields.entrySet().iterator();
                    while (fieldKeys.hasNext()) {
                        String entryFieldName = (String)((Map.Entry)fieldKeys.next()).getKey();
                        JsonObject entry = fields.getAsJsonObject(entryFieldName);
                        if (!entry.getAsJsonPrimitive("name").getAsString().equalsIgnoreCase(fieldName) || entry.getAsJsonArray("allowedValues") == null) continue;
                        result.addAll(this.convertToCascadingSelectOptions(entry.getAsJsonArray("allowedValues")));
                    }
                }
            }
        }
        return this.removeDuplicated(result);
    }

    private List<CascadingSelectOption> removeDuplicated(List<CascadingSelectOption> options) {
        LinkedList<CascadingSelectOption> filtered = new LinkedList<CascadingSelectOption>();
        HashMap<String, CascadingSelectOption> filter = new HashMap<String, CascadingSelectOption>();
        for (CascadingSelectOption option : options) {
            filter.put(this.identification(option).toString(), option);
        }
        filtered.addAll(filter.values());
        return filtered;
    }

    private StringBuilder identification(CascadingSelectOption option) {
        StringBuilder builder = new StringBuilder(option.getOption());
        HashMap<String, CascadingSelectOption> filter = new HashMap<String, CascadingSelectOption>();
        for (CascadingSelectOption children : option.getNestedOptions()) {
            filter.put(this.identification(children).toString(), children);
        }
        for (String key : filter.keySet()) {
            builder.append(key);
        }
        return builder;
    }

    private List<CascadingSelectOption> convertToCascadingSelectOptions(JsonArray allowedValues) {
        return this.convertToCascadingSelectOptions(allowedValues, null);
    }

    private List<CascadingSelectOption> convertToCascadingSelectOptions(JsonArray allowedValues, CascadingSelectOption parentOption) {
        ArrayList options = Lists.newArrayList();
        for (int i = 0; i < allowedValues.size(); ++i) {
            JsonObject entry = (JsonObject)allowedValues.get(i);
            String value = entry.getAsJsonPrimitive("value").getAsString();
            CascadingSelectOption option = new CascadingSelectOption(value, parentOption);
            List<Object> children = Lists.newArrayList();
            if (entry.has("children")) {
                children = this.convertToCascadingSelectOptions(entry.getAsJsonArray("children"), option);
            }
            option.addChildren(children);
            options.add(option);
        }
        return options;
    }

    public IssueSummary createIssue(IssueSummary issue) {
        WebTarget target = this.restClient().target(this.url).path(ISSUE);
        JsonObject fields = new JsonObject();
        JsonObject project = new JsonObject();
        project.add("key", (JsonElement)new JsonPrimitive(issue.getProject()));
        fields.add("project", (JsonElement)project);
        JsonObject issueType = new JsonObject();
        issueType.add("id", (JsonElement)new JsonPrimitive(issue.getType()));
        fields.add("issuetype", (JsonElement)issueType);
        fields.add("summary", (JsonElement)new JsonPrimitive(issue.getSummary()));
        fields.add("description", (JsonElement)new JsonPrimitive("Lorem ipsum..."));
        JsonObject jsonIssue = new JsonObject();
        jsonIssue.add("fields", (JsonElement)fields);
        Response response = target.request().post(Entity.json((Object)jsonIssue.toString()));
        this.checkValid(response);
        return IssueSummary.fromJsonString((String)response.readEntity(String.class));
    }

    public void deleteIssue(IssueSummary issue) throws Exception {
        WebTarget target = this.restClient().target(issue.getSelf());
        this.checkValid(target.request().delete());
    }

    public Project getProjectByKey(String projectKey) {
        WebTarget target = this.restClient().target(this.url).path("rest/api/latest/project/" + projectKey);
        Response response = target.request().get();
        this.checkValid(response);
        return Project.fromJsonString((String)response.readEntity(String.class));
    }

    public IssueSummary getIssue(String issueKey) {
        WebTarget target = this.restClient().target(this.url).path(ISSUE + issueKey);
        Response response = target.request().get();
        this.checkValid(response);
        return IssueSummary.fromJsonString((String)response.readEntity(String.class));
    }

    public void addComment(String issueKey, IssueComment newComment) {
        String url = String.format(ADD_COMMENT, issueKey);
        WebTarget target = this.buildWebTargetFor(url);
        JsonObject jsonComment = new JsonObject();
        jsonComment.add("body", (JsonElement)new JsonPrimitive(newComment.getBody()));
        Response response = target.request().post(Entity.json((Object)jsonComment.toString()));
        this.checkValid(response);
        this.issueSummaryCache.invalidate((Object)issueKey);
    }

    public void updateComment(String key, IssueComment updatedComment) {
        WebTarget target = this.restClient().target(updatedComment.getSelf());
        Response response = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get();
        JsonObject jsonComment = new JsonParser().parse((String)response.readEntity(String.class)).getAsJsonObject();
        jsonComment.addProperty("body", updatedComment.getBody());
        target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).put(Entity.entity((Object)jsonComment.toString(), (String)"application/json"));
        this.issueSummaryCache.invalidate((Object)key);
    }

    public List<IssueComment> getComments(String issueKey) throws ParseException {
        WebTarget target = this.restClient().target(this.url).path(ISSUE + issueKey + "/comment");
        Response response = target.request().get();
        this.checkValid(response);
        String jsonIssueRepresentation = (String)response.readEntity(String.class);
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(jsonIssueRepresentation).getAsJsonObject();
        JsonArray commentsArray = jsonObject.getAsJsonArray("comments");
        ArrayList<IssueComment> comments = new ArrayList<IssueComment>();
        for (int i = 0; i < commentsArray.size(); ++i) {
            JsonObject currentCommentJson = commentsArray.get(i).getAsJsonObject();
            comments.add(IssueComment.fromJsonString(currentCommentJson.toString()));
        }
        return comments;
    }

    public List<IssueTransition> getAvailableTransitions(String issueKey) throws ParseException {
        ArrayList<IssueTransition> availableActions = new ArrayList<IssueTransition>();
        WebTarget target = this.buildWebTargetFor(String.format(GET_TRANSITIONS, issueKey));
        Response response = target.request().get();
        this.checkValid(response);
        String jsonIssueRepresentation = (String)response.readEntity(String.class);
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(jsonIssueRepresentation).getAsJsonObject();
        JsonArray transitionsArray = jsonObject.getAsJsonArray("transitions");
        for (int i = 0; i < transitionsArray.size(); ++i) {
            JsonObject currentTransitionJson = transitionsArray.get(i).getAsJsonObject();
            availableActions.add(IssueTransition.fromJsonString(currentTransitionJson.toString()));
        }
        return availableActions;
    }

    public void progressWorkflowTransition(String issueKey, String transitionId) throws ParseException {
        WebTarget target = this.buildWebTargetFor(String.format(GET_TRANSITIONS, issueKey));
        JsonObject jsonTransition = new JsonObject();
        jsonTransition.add("transition", (JsonElement)new JsonPrimitive(transitionId));
        Response response = target.request().post(Entity.json((Object)jsonTransition.toString()));
        this.checkValid(response);
    }
}

